/**
 * core common
 * 
 * @package Sngine JSL
 * @author Zamblek
 */

$(function() {
	
    $('.languageDialog').live('click', 
        function() {
			$.popups.popup({source: SITE_URL+"ajax/translation/dialog.php", data: null, width: 450});
        }
    );
    
    $('.changeLanguage').live('click', 
        function() {
            
            var lang = $(this).attr('id');
            $.ajax({
                url: SITE_URL+'ajax/translation/change.php',
                type: 'POST',
                data: 'lang=' + encodeURIComponent(lang),
                success: function(data){
                    setTimeout("window.location.reload()", 1000);
                }
            });
        }
    );
	
	$('.uiButton').live('mousedown', 
        function() {
            $(this).addClass("clicked");
        }
    );
    
    $('.uiButton').live('mouseup', 
        function() {
            $(this).removeClass("clicked");
        }
    );
    
    $('.uiInput, .uiTextArea').live('focus', 
        function() {
			
			if($(this).hasClass('active')) { return; }
			
            if($(this).data('value') == undefined) {
                $(this).data('value', $(this).val());
            }
            if($(this).val() == $(this).data('value')) {
               $(this).val('');
            }
            if($(this).val() == '') {
               $(this).addClass("active");
               if($(this).hasClass('uiTextArea')) {
                    $(this).parent().next().show();
               }
            }
        }
    );
    
    $('.uiInput, .uiTextArea').live('blur', 
        function() {
            if($(this).val() == '') {
               $(this).val($(this).data('value'));
               $(this).removeClass("active");
               if($(this).hasClass('uiTextArea') && !$(this).hasClass('shareNews')) {
                    $(this).parent().next().hide();
               }
            }
        }
    );
    
    $('#searchForm .glass').click(
        function() {
            $(this).parent("form").submit();
        }
    );
    
    $('.showHoverCard').live('mouseenter', 
        function() {
			var button = $(this);
			var t = setTimeout(function() {
				button.find('.hoverCardWrapper').html('<div class="hoverCard"><div class="hoverCardHeader">Loading</div></div><div class="hoverCardArrow"></div>').show();
				$.ajax({
					type: 'GET',
                    url: SITE_URL+'ajax/users/hovercard.php',
                    data: 'id=' + button.attr('id'),
                    success: function(data) {
						button.find('.hoverCard').html(data);
					}
                });
			}, 1000);
            $(this).data('timeout', t);
        }
    );
	
	$('.showHoverCard').live('mouseleave', 
        function() {
            clearTimeout($(this).data('timeout'));
            $(this).find(".hoverCardWrapper").hide();
        }
    );
	
	$('.showShareButtons').live('mouseenter', 
        function() {
			var button = $(this);
			var t = setTimeout(function() {
				button.find('.shareButtonsWrapper').show();
			}, 500);
            $(this).data('timeout', t);
        }
    );
	
	$('.showShareButtons').live('mouseleave', 
        function() {
            clearTimeout($(this).data('timeout'));
            $(this).find(".shareButtonsWrapper").hide();
        }
    );
    
    $('.showflyHint').live('mouseenter', 
        function() {
			hint = $(this).find(".flyHintWrapper");
			hint.css({bottom: $(this).children().last().outerHeight() + 6 + 'px', right: 0 + 'px'}).show();
			if($(this).hasClass('toLeft')) {
				hint.css({left: 0 + 'px', right: 'auto'});
				hint.find('i.arrow').css({left: 8 + 'px', right: 'auto'});
			}
		}
    );
    
    $('.showflyHint').live('mouseleave', 
        function() {
            $(this).find(".flyHintWrapper").hide();
        }    
    );
	
	$('.reportError').live('click', 
        function() {
			var message = $(this).attr('id');
			var parent = $(this).parents('.errorContianer')
            parent.html('<img src="'+SITE_URL+'content/themes/default/images/buttons/spinner.gif" />');
			$.ajax({
				type: 'POST',
				url: SITE_URL+'ajax/system/report.php',
				data: 'error=' + encodeURIComponent(message),
				cache: false,
				success: function(data){
					if(!data) {
						parent.html('Thanks for feedback');
					}else {
						parent.html('Reporting failed');
					}
				}
			});
			return false;
        }
    );
	
});