{if $userArray.UserMessages > 0 && $hasRows}
    {foreach $conversations as $conversation}
        <li class="feedItem {if $conversation.Viewed == 'N'}unread{/if}" id="{$conversation.ID}-{$conversation.ID}">
            <a class="msgContainer" href="{$SITE_URL}/message/{$conversation.ID}/">
                <div class="dataSideWrapper ml5">
                    {if !$conversation.MixedAvatar}
                        <img src="{$SITE_URL}/{$conversation.AvatarPath}" />
                    {else}
                        <span class="uiMixedAvatars">
                            <span class="uiSplitAvatars leftAvatar"><img src="{$SITE_URL}/{$conversation.LeftAvatarPath}" /></span>
                            <span class="uiSplitAvatars"><img src="{$SITE_URL}/{$conversation.RightAvatarPath}" /></span>
                        </span>
                    {/if}
                </div>
                <div class="dataContentWrapper ml10 mr5">
                    <div class="dataContent mb5 mt5">
                        <!-- Conversation Buttons -->
                        <div class="right mt10">
                            <span title="Delete this conversation" class="msgButtonDelete doRemoveConversation mr5"></span>
                            <span {if $conversation.Viewed == 'N'}title="Mark as Read" class="mr5 msgButtonRead doRead"{else}title="Mark as Unread" class="mr5 msgButtonUnRead doUnRead"{/if}></span>
                            <span class="showflyHint">
                                <!-- flyHint -->
                                <div class="flyHintWrapper hidden">{$conversation.Messages} Messages<i class="arrow"></i></div>
                                <!-- flyHint -->
                                <span class="uiGaintNumber msgCounter">{$conversation.Messages}</span>
                            </span>
                        </div>
                        <!-- Conversation Buttons -->
                        
                        <span class="white">
                            {foreach $conversation.users as $recipient}
                                <strong>{$recipient.UserFirstName} {$recipient.UserLastName}</strong>{if !$recipient@last},{/if}
                            {/foreach}
                            {if $conversation.hasOthers}
                                <strong>&amp; {$conversation.others} others</strong>
                            {/if}
                        </span> <span class="timeago gray" data-time="{$conversation.LastUpdate}"></span>
                    </div>
                    <div class="dataContent">{if $conversation.LastSenderID == $userArray.UserID}<span class="msgButtonSent mr5"></span>{/if}{$conversation.LastMessage|truncate:85}</div>
                </div>
            </a>
        </li>
    {/foreach}
    
    <!-- Pagination -->
    <div class="appsFooter gray">
        <div class="right">{$pager}</div>
    </div>
    <!-- Pagination -->
    
{else}
    <div class="dataNullState">No Messages</div>
{/if}

<script>jQuery("span[class*=timeago]").timeago();</script>