<?php 
/**
 * bootstrap
 * 
 * @package Sngine
 * @author Zamblek
 */

// set absolut path
define('ABSPATH',dirname(__FILE__).'/');

if(!file_exists(ABSPATH.'libs/config.php')) {
    
    /* the config file doesn't exist - start the installer */
    
    // get version & system functions
    require_once(ABSPATH.'libs/version.php');
    
    // get system functions
    require(ABSPATH.'libs/functions-system.php');
	
    // check php & mysql version
    _check_php_mysql_versions();
    
    // start the installer
    $path = (strpos($_SERVER['PHP_SELF'], 'admin') !== false)? 'install.php': 'admin/install.php';
	header('Location: '.$path);
    
}else {
    
    /* the config file exist - start the Sngine :) */
    
    // get system configurations
    require(ABSPATH.'libs/config.php');
    
    // get system functions
    require(ABSPATH.'libs/functions-system.php');
    
    // enviroment setting
    if(DEBUGGING) {
        error_reporting(E_ALL ^ E_NOTICE);
    }else {
        error_reporting(0);
    }
    
    // start session
    session_start();
    
    // connect to the db
    $db = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, DB_NAME);
    if(mysqli_connect_error()) {
        _error("System Error", "Cannot connect to the server");
    }
    
}

?>