<?php
/**
 * picture | upload
 * 
 * @package Sngine
 * @author Zamblek
 */

// fetch kernal
$depth = '../../../';
require($depth.'kernal.php');
require($depth.'libs/class-image.php');

// check if user exist
if(!$userExist) {
    exit('Access Denied');
}

// check user verified
if($userArray['Verified'] == "N") {
    exit('Access Denied');
}

// check secret
if($_SESSION['secret'] != $_POST['secret']) {
    exit('Access Denied');
}

// define the template
$template = "ajax.upload";

$data['status'] = 0;

// collect file info
$file = $_FILES['uploadFile'];
$fileName = $file['name'];
$fileTmp  = $file['tmp_name'];
$fileType = $file['type'];
$fileSize = $file['size'];
$dirPath = $depth.'content/uploads/avatars/';

// check file extension
if(ValidImg($fileName)) {
    // check file size [700K Max]
    if($fileSize < 716800) {
        try {
            $image = new Image($fileTmp);
        }catch (Exception $e) {
            $data['error'] = $e->getMessage();
            $data['key'] = $_POST['key'];
            $smarty->assign('data', $data);
            $smarty->display($template.".tpl");
            exit;
        }
        // generate image & thumbnail names
        $prefix = 's_'.md5(time()*rand(1, 9999));
        $imgName = $prefix.'.jpg';
        $thumbMediumName = $prefix.'_medium.jpg';
        $thumbSmallName = $prefix.'_small.jpg';
        $tmpPath = $dirPath.$fileName;
        $imgPath = $dirPath.$imgName;
        $thumMediumPath = $dirPath.$thumbMediumName;
        $thumSmallPath = $dirPath.$thumbSmallName;
        
        // upload the new image
        if(@move_uploaded_file ($fileTmp, $tmpPath)) {
            
            // resize original img
            $avatar = new Image($tmpPath);
            $avatar->resize(128, 128);
            $avatar->save($imgPath);
            
            // generate medium thumbnail
            $thumbnailMedium = new Image($tmpPath);
            $thumbnailMedium->resize(50, 50);
            $thumbnailMedium->save($thumMediumPath);
            
            // generate small thumbnail
            $thumbnailSmall = new Image($tmpPath);
            $thumbnailSmall->resize(30, 30);
            $thumbnailSmall->save($thumSmallPath);
            
            // delete tmp img
            unlink($tmpPath);
            
            // prepare url
            $url = 'content/uploads/avatars/';
            
            // update user avatar
            $db->query(sprintf("UPDATE users SET UserAvatarPath = %s, UserAvatarPathMedium = %s, UserAvatarPathSmall = %s WHERE UserID = %s", Secure($url.$imgName), Secure($url.$thumbMediumName), Secure($url.$thumbSmallName), Secure($userArray['UserID'], 'int') )) or die("sql error #1");
            
            // return data
            $data['img'] = SITE_URL."/".$url.$imgName;
            $data['thumbnail'] = '';
            $data['status'] = 1;
            
        }else {
            $data['error'] = "cannot upload the file!";
        }
    }else {
        $data['error'] = "The file size is so big";
    }
}else {
    $data['error'] = "The file type is not valid image";
}
$data['key'] = $_POST['key'];

// assign variables
$smarty->assign('data', $data);

// display page templete
$smarty->display($template.".tpl");

?>