<?php
/**
 * hovercard
 * 
 * @package Sngine
 * @author Zamblek
 */


// fetch kernal
$depth = '../../';
require($depth.'kernal.php');

// check AJAX Request
if(!IsAJAX()) {
    header('Location: '.SITE_URL);
}

// check page parameters
if(!isset($_GET['id'])) {
    exit(ReportError('parameters error[1] @/ajax/users/hovercard'));
}

// parse parameters
if(!preg_match('/^([0-9]+)$/', $_GET['id'])) {
    exit(ReportError('parameters error[2] @/ajax/users/hovercard'));
}

// get user basic info
$getUser = $db->query(sprintf("SELECT UserID, UserName, UserFirstName, UserLastName, UserAvatarPathSmall AS UserAvatarPath, UserPosts, UserFollowings, UserFollowers FROM users WHERE UserID = %s", SafeSQL($_GET['id'], 'int') )) or die(ReportError('sql error #1 @/ajax/users/hovercard'));
if($getUser->num_rows == 0) {
    exit(ReportError('parameters error[3] @/ajax/users/hovercard'));
}
$user = $getUser->fetch_array(MYSQLI_ASSOC);

// check in user followings
if(count($userFollowings) > 0) {
    $user['FollowingHim'] = (in_array($user['UserID'], $userFollowings))? true: false;
}else {
    $user['FollowingHim'] = false;
}

// assign variables
$smarty->assign('user', $user);

// page footer
PageFooter("ajax.users.hovercard");

?>