<?php
/**
 * follow|unfollow user
 * 
 * @package Sngine
 * @author Zamblek
 */


// fetch kernal
$depth = '../../';
require($depth.'kernal.php');

// check AJAX Request
if(!IsAJAX()) {
    header('Location: '.SITE_URL);
}

// check user exist
if(!$userExist) {
    exit(PopupError('Please log in to continue.', 'Not Logged In'));
}

// check user verified
if($userArray['Verified'] == "N") {
    VerifyError();
}

// check page parameters
if(!isset($_POST['uid']) || !isset($_POST['do'])) {
    exit(PopupError(ReportError('parameters error[1] @/ajax/users/follow')));
}

// valid inputs
$valid['do'] = array('follow', 'unfollow');
if(!in_array($_POST['do'], $valid['do'])) {
    exit(PopupError(ReportError('parameters error[2] @/ajax/users/follow')));
}

// parse parameters
if(!preg_match('/^([0-9]+)$/', $_POST['uid'])) {
    exit(PopupError(ReportError('parameters error[3] @/ajax/users/follow')));
}

// check user
$checkUser = $db->query(sprintf("SELECT * FROM users WHERE UserID = %s", SafeSQL($_POST['uid'], 'int') )) or die(ReportError('sql error #1 @/ajax/users/follow'));
if($checkUser->num_rows == 0) {
    exit(PopupError(ReportError('parameters error[4] @/ajax/users/follow')));
}

if($_POST['do'] == 'follow') {
    // check if user already follow this user
    if(in_array($_POST['uid'], $userFollowings)) {
        exit();
    }
    // insert following
    $db->query(sprintf("INSERT INTO users_followings (UserID, FollowingID) VALUES (%s, %s)", SafeSQL($userArray['UserID'], 'int'), SafeSQL($_POST['uid'], 'int') )) or die(PopupError(ReportError('sql error #2 @/ajax/users/follow')));
    // update followings & followers counters
    $db->query(sprintf("UPDATE users SET UserFollowings = UserFollowings + 1 WHERE UserID = %s", SafeSQL($userArray['UserID'], 'int') )) or die(PopupError(ReportError('sql error #3 @/ajax/users/follow')));
    $db->query(sprintf("UPDATE users SET UserFollowers = UserFollowers + 1 WHERE UserID = %s", SafeSQL($_POST['uid'], 'int') )) or die(PopupError(ReportError('sql error #4 @/ajax/users/follow')));
    // insert notification
    $db->query(sprintf("INSERT INTO notifications (UserID, Action, AuthorID, Time) VALUES (%s, 1, %s, %s)", SafeSQL($userArray['UserID'], 'int'), SafeSQL($_POST['uid'], 'int'), $now )) or die(PopupError(ReportError('sql error #5 @/ajax/users/follow')));
    $db->query(sprintf("UPDATE users SET UserNotifications = UserNotifications + 1, UserNewNotifications = UserNewNotifications + 1 WHERE UserID = %s", SafeSQL($_POST['uid'], 'int'))) or die(PopupError(ReportError('sql error #6 @/ajax/users/follow')));
}else {
    // check if user already not follow this user
    if(!in_array($_POST['uid'], $userFollowings)) {
        exit();
    }
    // delete following
    $db->query(sprintf("DELETE FROM users_followings WHERE UserID = %s AND FollowingID = %s", SafeSQL($userArray['UserID'], 'int'),SafeSQL($_POST['uid'], 'int') )) or die(PopupError(ReportError('sql error #7 @/ajax/users/follow')));
    // update followings & followers counters
    $db->query(sprintf("UPDATE users SET UserFollowings = IF(UserFollowings=0,0,UserFollowings-1) WHERE UserID = %s", SafeSQL($userArray['UserID'], 'int') )) or die(PopupError(ReportError('sql error #8 @/ajax/users/follow')));
    $db->query(sprintf("UPDATE users SET UserFollowers = IF(UserFollowers=0,0,UserFollowers-1) WHERE UserID = %s", SafeSQL($_POST['uid'], 'int') )) or die(PopupError(ReportError('sql error #9 @/ajax/users/follow')));
    // delete notification
    $db->query(sprintf("DELETE FROM notifications WHERE UserID = %s AND Action = 1 AND AuthorID = %s", SafeSQL($userArray['UserID'], 'int'),SafeSQL($_POST['uid'], 'int') )) or die(PopupError(ReportError('sql error #10 @/ajax/users/follow')));
    $db->query(sprintf("UPDATE users SET UserNotifications = IF(UserNotifications=0,0,UserNotifications-1), UserNewNotifications = IF(UserNewNotifications=0,0,UserNewNotifications-1) WHERE UserID = %s", SafeSQL($_POST['uid'], 'int'))) or die(PopupError(ReportError('sql error #11 @/ajax/users/follow')));
}

?>