<?php
/**
 * resend confirmation email
 * 
 * @package Sngine
 * @author Zamblek
 */

// fetch kernal
$depth = '../../../';
require($depth.'kernal.php');

// check AJAX Request
if(!IsAJAX()) {
    header('Location: '.SITE_URL);
}

// check user exist
if(!$userExist) {
    exit(PopupError('Please log in to continue.', 'Not Logged In'));
}

// check user verified
if($userArray['Verified'] == "Y") {
    exit(PopupError('Your account already verified.', 'Thanks'));
}

// create activation code
$code = md5(time()*rand(1, 9999));

// update user
$updateUser = $db->query(sprintf("UPDATE users SET ActivationCode = %s WHERE UserID = %s", Secure($code), Secure($userArray['UserID']) ));
if(!$updateUser) {
    exit(PopupError('There is some thing wrong happened. Try again later.', 'Error'));
}

// prepare to send activation email
$subject = "Just one more step to get started on ".SITE_TITLE."";
$body  = "Hi ".$userArray['UserFirstName'].",";
$body .= "\r\n\r\nTo complete the sign-up process, please follow this link:";
$body .= "\r\n\r\nhttp://".SITE_DOMAIN."/confirm.php?id=".$userArray['UserID']."&code=".$code;
$body .= "\r\n\r\nWelcome to ".SITE_TITLE."!";
$body .= "\r\n\r".SITE_TITLE." Team";

// send activation email
if(!SendMail($userArray['UserEmail'], $subject, $body)) {
    exit(PopupError('There is some thing wrong happened. Try again later.', 'Error'));
}else {
    exit(PopupError('<p class="fs11 mb10">Another email was sent to: <span class="blue">'.$userArray['UserEmail'].'</span>.</p><p class="fs11">Please click on the link in that email to confirm your email address. Be sure to check your spam/junk folder.</p>', 'Email Resent'));
}

?>