<?php
/**
 * get posts
 * 
 * @package Sngine
 * @author Zamblek
 */

// fetch kernal
$depth = '../../';
require($depth.'kernal.php');

// check AJAX Request
if(!IsAJAX()) {
    header('Location: '.SITE_URL);
}

// define the tple
$page = "ajax.search.get";

// check page parameters
if(!isset($_GET['q']) || !isset($_GET['app']) || !isset($_GET['get']) || !isset($_GET['filter']) || !isset($_GET['sort'])) {
    exit(ReportError('parameters error[1] @/ajax/search/get'));
}

// valid & sanitize inputs
$valid['app'] = array('people', 'news', 'music', 'photos', 'videos', 'discussions', 'questions', 'polls', 'links');
$valid['get'] = array('all', 'new', 'old');
$valid['filter'] = array('', 'All', 'Just Me', 'Just User', 'Just Followers', 'Just Followings');
$valid['sort'] = array('', 'Most Recent', 'Most Liked', 'Most Favorited', 'Most Discussed', 'Most Answered');

if(!in_array($_GET['app'], $valid['app']) || !in_array($_GET['get'], $valid['get']) || !in_array($_GET['filter'], $valid['filter']) || !in_array($_GET['sort'], $valid['sort'])) {
    exit(ReportError('parameters error[2] @/ajax/search/get'));
}

// prepare where statement
if(count($userBlockedUsers) > 0) {
    $whereStatement = ' AND post.UserID NOT IN (' . implode(',', $userBlockedUsers) . ')';
    $whereStatementComments = ' AND comm.UserID NOT IN (' . implode(',', $userBlockedUsers) . ')';
}

if(count($userBlockedPosts) > 0 && ($_GET['app'] != 'people' || $_GET['app'] != 'photos' || $_GET['app'] != 'videos')) {
    $whereStatement .= ' AND post.ID NOT IN (' . implode(',', $userBlockedPosts) . ')';
}

if($_GET['get'] == "new") {
    $tid = ($_GET['app'] == 'people')? 'UserID' : 'ID';
    $whereStatement .= " AND post.".$tid." > ".Secure($_GET['startPoint'], 'int');
}elseif ($_GET['get'] == "old") {
    $tid = ($_GET['app'] == 'people')? 'UserID' : 'ID';
    $whereStatement .= " AND post.".$tid." < ".Secure($_GET['startPoint'], 'int');
}

if($_GET['filter'] == "Just Followings") {
    if(count($userFollowings) > 0) {
        $whereStatement .= ' AND post.UserID IN (' . implode(',', $userFollowings) . ')';
    }else {
        exit('<div class="dataNullState stopCronJobs">You do not have any followings yet!</div>');
    }
}elseif ($_GET['filter'] == "Just Followers") {
    if(count($userFollowers) > 0) {
        $whereStatement .= ' AND post.UserID IN (' . implode(',', $userFollowers) . ')';
    }else {
        exit('<div class="dataNullState stopCronJobs">You do not have any followers yet!</div>');
    }
}elseif ($_GET['filter'] == "Just Me") {
    $whereStatement .= ' AND post.UserID = '.Secure($userArray['UserID'], 'int');
}elseif ($_GET['filter'] == "Just User") {
    if(!isset($_GET['id'])) {
        exit(ReportError('parameters error[3] @/ajax/search/get'));
    }
    $whereStatement .= ' AND post.UserID = '.Secure($_GET['id'], 'int');
}

// get post
function getPost(&$post) {
    
    global $db, $userArray, $systemSetting, $whereStatementComments;
    
    // check if user favorited this post before
    $getPostStatus = $db->query(sprintf("SELECT Favorited FROM users_posts_favorites WHERE UserID = %s AND PostType = %s AND PostID = %s", Secure($userArray['UserID'], 'int'), Secure($post['PostType'], 'int'), Secure($post['PostID'], 'int') )) or die(ReportError('sql error #1 @/ajax/search/get'));
    if($getPostStatus->num_rows > 0) {
        $post['favorited'] = true;
    }else {
        $post['favorited'] = false;
    }
    
    // check if user liked|disliked this post before
    $getPostStatus = $db->query(sprintf("SELECT Liked FROM users_posts_likes WHERE UserID = %s AND PostType = %s AND PostID = %s", Secure($userArray['UserID'], 'int'), Secure($post['PostType'], 'int'), Secure($post['PostID'], 'int') )) or die(ReportError('sql error #2 @/ajax/search/get'));
    if($getPostStatus->num_rows > 0) {
        $postStatus = $getPostStatus->fetch_array(MYSQLI_ASSOC);
        $post['liked'] = $postStatus['Liked'];
    }
    
    // get comments
    if($post['Comments'] > 0 && $post['Comments'] <= $systemSetting['MaxQComments']) {
        $post['prevComments'] = ($post['Comments'] > $systemSetting['MaxQCommentsViewed'])? $post['Comments'] - $systemSetting['MaxQCommentsViewed']: 0;
        $getComments = $db->query(sprintf("SELECT comm.*, user.UserName, user.UserFirstName, user.UserLastName, user.UserAvatarPathSmall AS UserAvatarPath FROM posts_comments comm INNER JOIN users user ON comm.UserID = user.UserID WHERE comm.PostType = %s AND comm.PostID = %s ".$whereStatementComments." ORDER BY comm.Time ASC LIMIT %s,".$systemSetting['MaxQCommentsViewed'], Secure($post['PostType'], 'int'), Secure($post['PostID'], 'int'), $post['prevComments'] )) or die(ReportError('sql error #3 @/ajax/search/get'));
        while($comment = $getComments->fetch_array(MYSQLI_ASSOC)) {
            
            // check if user liked|disliked this comment before
            $getCommentStatus = $db->query(sprintf("SELECT Liked FROM users_comments_likes WHERE UserID = %s AND CommentID = %s", SafeSQL($userArray['UserID'], 'int'), SafeSQL($comment['ID'], 'int') )) or die(ReportError('sql error #4 @/ajax/search/get'));
            if($getCommentStatus->num_rows > 0) {
                $commentStatus = $getCommentStatus->fetch_array(MYSQLI_ASSOC);
                $comment['liked'] = $commentStatus['Liked'];
            }
            
            // decode comment text
            $comment['Text'] = DecodeText($comment['Text']);
            
            $post['comments'][] = $comment;
        }
    }
}

// search
function search($app, $query) {
    
    global $db, $smarty, $userArray, $systemSetting, $whereStatement, $page;
    
    $limitStatement = " LIMIT ".$systemSetting['MaxResults'];
    switch($app) {
        case 'people':
            $getPeople = $db->query(sprintf("SELECT * FROM users post WHERE (post.UserFirstName LIKE %s OR post.UserLastName LIKE %s) ".$whereStatement." ORDER BY post.UserID DESC ".$limitStatement, Secure($query, 'search'), Secure($query, 'search') )) or die(ReportError('sql error #5 @/ajax/search/get'));
            if($getPeople->num_rows == 0) {
                return false;
            }
            while($person = $getPeople->fetch_array(MYSQLI_ASSOC)) {
                $results[] = $person;
            }
            break;
        case 'news':
            $getPosts = $db->query(sprintf("SELECT post.*, app.Text, user.UserName, user.UserFirstName, user.UserLastName, user.UserAvatarPathMedium AS UserAvatarPath FROM posts_news app INNER JOIN posts post ON app.ID = post.PostID AND post.PostType = 1 INNER JOIN users user ON post.UserID = user.UserID WHERE app.Text LIKE %s".$whereStatement." ORDER BY post.ID DESC ".$limitStatement, Secure($query, 'search') )) or die(ReportError('sql error #6 @/ajax/search/get'));
            if($getPosts->num_rows == 0) {
                return false;
            }
            while($post = $getPosts->fetch_array(MYSQLI_ASSOC)) {
                $post['data']['URL'] = GetURLText($post['Text']);
                $post['data']['Text'] = DecodeText($post['Text']);
                getPost($post);
                $results[] = $post;
            }
            break;
        case 'music':
            $getPosts = $db->query(sprintf("SELECT post.*, app.*, user.UserName, user.UserFirstName, user.UserLastName, user.UserAvatarPathMedium AS UserAvatarPath FROM posts_tracks app INNER JOIN posts post ON app.ID = post.PostID AND post.PostType = 2 INNER JOIN users user ON post.UserID = user.UserID WHERE app.Text LIKE %s OR app.Title LIKE %s OR app.Description LIKE %s".$whereStatement." ORDER BY post.ID DESC ".$limitStatement, Secure($query, 'search'), Secure($query, 'search'), Secure($query, 'search') )) or die(ReportError('sql error #7 @/ajax/search/get'));
            if($getPosts->num_rows == 0) {
                return false;
            }
            while($post = $getPosts->fetch_array(MYSQLI_ASSOC)) {
                $post['data']['ID'] = $post['ID'];
                $post['data']['Source'] = $post['Source'];
                $post['data']['Title'] = $post['Title'];
                $post['data']['Description'] = $post['Description'];
                if(IsEmpty($post['Text'])) {
                    $post['data']['URL'] = GetURLText($post['Title']);
                }else {
                    $post['data']['URL'] = GetURLText($post['Text']);
                }
                $post['data']['Text'] = DecodeText($post['Text']);
                getPost($post);
                $results[] = $post;
            }
            break;
        case 'photos':
            
            // define the tple
            $page = "ajax.search.media";
            
            // prepare pagination
            if(isset($_GET['page'])) {
                $spage = (int) $_GET['page'];
                $spage = ($spage == 0) ? 1 : $spage;
            }else {
                $spage = 1;
            }
            $total = $db->query("SELECT * FROM posts_photos") or die(ReportError('sql error #7 @/ajax/search/get'));
            $total = $total->num_rows;
            require('../../libs/class-pagination.php');
            $pagination = new Pagination($spage, $systemSetting['MaxMediaFeeds'], $total, 'photos.php?page=%s');
            $limitStatement = $pagination->getLimitSql();
            $smarty->assign('pager', $pagination->getPagerMini());
            
            // get photos
            $getMedia = $db->query(sprintf("SELECT source.*, post.IsWall FROM posts_photos_sources source INNER JOIN posts_photos_albums post ON source.AlbumID = post.ID WHERE (source.Text LIKE %s OR post.Title LIKE %s OR post.Text LIKE %s)".$whereStatement." ORDER BY source.ID DESC ".$limitStatement, Secure($query, 'search'), Secure($query, 'search'), Secure($query, 'search') )) or die(ReportError('sql error #8 @/ajax/search/get'));
            if($getMedia->num_rows == 0) {
                return false;
            }
            while($media = $getMedia->fetch_array(MYSQLI_ASSOC)) {
                if($media['IsWall'] == "Y") {
                    $getPost = $db->query(sprintf("SELECT post.* FROM posts_photos media INNER JOIN posts post ON media.ID = post.PostID AND post.PostType = 3 WHERE media.IsAlbum = 'N' AND media.MediaID = %s", SafeSQL($media['ID'], 'int') )) or die('sql error #9 @/ajax/search/get');
                    $post = $getPost->fetch_array(MYSQLI_ASSOC);
                    $media['Favorits'] = $post['Favorits'];
                    $media['Likes'] = $post['Likes'];
                    $media['Dislikes'] = $post['Dislikes'];
                    $media['Comments'] = $post['Comments'];
                    $media['PComments'] = $post['PComments'];
                }
                $results[] = $media;
            }
            break;
        case 'videos':
            
            // define the tple
            $page = "ajax.search.media";
            
            // prepare pagination
            if(isset($_GET['page'])) {
                $spage = (int) $_GET['page'];
                $spage = ($spage == 0) ? 1 : $spage;
            }else {
                $spage = 1;
            }
            $total = $db->query("SELECT * FROM posts_videos_sources") or die(ReportError('sql error #10 @/ajax/search/get'));
            $total = $total->num_rows;
            require('../../libs/class-pagination.php');
            $pagination = new Pagination($spage, $systemSetting['MaxMediaFeeds'], $total, 'photos.php?page=%s');
            $limitStatement = $pagination->getLimitSql();
            $smarty->assign('pager', $pagination->getPagerMini());
            
            // get videos
            $getMedia = $db->query(sprintf("SELECT source.*, post.IsWall FROM posts_videos_sources source INNER JOIN posts_videos_albums post ON source.AlbumID = post.ID WHERE (source.Text LIKE %s OR post.Title LIKE %s OR post.Text LIKE %s)".$whereStatement." ORDER BY source.ID DESC ".$limitStatement, Secure($query, 'search'), Secure($query, 'search'), Secure($query, 'search') )) or die(ReportError('sql error #11 @/ajax/search/get'));
            if($getMedia->num_rows == 0) {
                return false;
            }
            while($media = $getMedia->fetch_array(MYSQLI_ASSOC)) {
                if($media['IsWall'] == "Y") {
                    $getPost = $db->query(sprintf("SELECT post.* FROM posts_videos media INNER JOIN posts post ON media.ID = post.PostID AND post.PostType = 4 WHERE media.IsAlbum = 'N' AND media.MediaID = %s", SafeSQL($media['ID'], 'int') )) or die('sql error #12 @/ajax/search/get');
                    $post = $getPost->fetch_array(MYSQLI_ASSOC);
                    $media['Favorits'] = $post['Favorits'];
                    $media['Likes'] = $post['Likes'];
                    $media['Dislikes'] = $post['Dislikes'];
                    $media['Comments'] = $post['Comments'];
                    $media['PComments'] = $post['PComments'];
                }
                $results[] = $media;
            }
            break;
        case 'discussions':
            $getPosts = $db->query(sprintf("SELECT post.*, app.ID, app.Title, app.Text, user.UserName, user.UserFirstName, user.UserLastName, user.UserAvatarPathMedium AS UserAvatarPath FROM posts_discussions app INNER JOIN posts post ON app.ID = post.PostID AND post.PostType = 5 INNER JOIN users user ON post.UserID = user.UserID WHERE (app.Title LIKE %s OR app.Text LIKE %s)".$whereStatement." ORDER BY post.ID DESC ".$limitStatement, Secure($query, 'search'), Secure($query, 'search') )) or die(ReportError('sql error #13 @/ajax/search/get'));
            if($getPosts->num_rows == 0) {
                return false;
            }
            while($post = $getPosts->fetch_array(MYSQLI_ASSOC)) {
                $post['data']['ID'] = $post['ID'];
                $post['data']['Title'] = $post['Title'];
                $post['data']['Text'] = Parse($post['Text']);
                $post['data']['Text'] = DecodeText($post['data']['Text']);
                $post['data']['URL'] = GetURLText($post['Title']);
                getPost($post);
                $results[] = $post;
            }
            break;
        case 'questions':
            $getPosts = $db->query(sprintf("SELECT post.*, app.Title, app.Answers, user.UserName, user.UserFirstName, user.UserLastName, user.UserAvatarPathMedium AS UserAvatarPath FROM posts_questions app INNER JOIN posts post ON app.ID = post.PostID AND post.PostType = 6 INNER JOIN users user ON post.UserID = user.UserID WHERE (app.Title LIKE %s OR app.Text LIKE %s)".$whereStatement." ORDER BY post.ID DESC ".$limitStatement, Secure($query, 'search'), Secure($query, 'search') )) or die(ReportError('sql error #14 @/ajax/search/get'));
            if($getPosts->num_rows == 0) {
                return false;
            }
            while($post = $getPosts->fetch_array(MYSQLI_ASSOC)) {
                $post['data']['Title'] = $post['Title'];
                $post['data']['Answers'] = $post['Answers'];
                $post['data']['URL'] = GetURLText($post['Title']);
                getPost($post);
                $results[] = $post;
            }
            break;
        case 'polls':
            $getPosts = $db->query(sprintf("SELECT post.*, app.ID, app.Question, app.Votes, user.UserName, user.UserFirstName, user.UserLastName, user.UserAvatarPathMedium AS UserAvatarPath FROM posts_polls app INNER JOIN posts post ON app.ID = post.PostID AND post.PostType = 7 INNER JOIN users user ON post.UserID = user.UserID WHERE app.Question LIKE %s".$whereStatement." ORDER BY post.ID DESC ".$limitStatement, Secure($query, 'search'), Secure($query, 'search') )) or die(ReportError('sql error #15 @/ajax/search/get'));
            if($getPosts->num_rows == 0) {
                return false;
            }
            while($post = $getPosts->fetch_array(MYSQLI_ASSOC)) {
                $post['data']['ID'] = $post['ID'];
                $post['data']['Question'] = $post['Question'];
                $post['data']['Votes'] = $post['Votes'];
                // get poll options
                $getPollOptions = $db->query(sprintf("SELECT * FROM posts_polls_options WHERE PollID = %s", Secure($post['PostID'], 'int') )) or die(ReportError('sql error #16 @/ajax/search/get'));
                while($pollOption = $getPollOptions->fetch_array(MYSQLI_ASSOC)) {
                    $pollOption['Bar'] = ($pollOption['Votes'] / $post['data']['Votes']) * 100;
                    // check if user select the option
                    $getOption = $db->query(sprintf("SELECT * FROM users_polls_options WHERE UserID = %s AND PollID = %s AND OptionID = %s", Secure($userArray['UserID'], 'int'), Secure($post['PostID'], 'int'), Secure($pollOption['ID'], 'int') )) or die(ReportError('sql error #17 @/ajax/search/get'));
                    if($getOption->num_rows == 0) {
                        $pollOption['select'] = false;
                    }else {
                        $pollOption['select'] = true;
                        $post['data']['selected'] = $pollOption['ID'];
                    }
                    $post['pollOptions'][] = $pollOption;
                }
                $post['data']['URL'] = GetURLText($post['Question']);
                getPost($post);
                $results[] = $post;
            }
            break;
        case 'links':
            $getPosts = $db->query(sprintf("SELECT post.*, app.ID, app.Title, app.URL, app.Host, app.Description, app.Text, app.Thumbnail, user.UserName, user.UserFirstName, user.UserLastName, user.UserAvatarPathMedium AS UserAvatarPath FROM posts_links app INNER JOIN posts post ON app.ID = post.PostID AND post.PostType = 8 INNER JOIN users user ON post.UserID = user.UserID WHERE (app.Title LIKE %s OR app.Description LIKE %s OR app.Text LIKE %s)".$whereStatement." ORDER BY post.ID DESC ".$limitStatement, Secure($query, 'search'), Secure($query, 'search'), Secure($query, 'search') )) or die(ReportError('sql error #18 @/ajax/search/get'));
            if($getPosts->num_rows == 0) {
                return false;
            }
            while($post = $getPosts->fetch_array(MYSQLI_ASSOC)) {
                $post['data']['ID'] = $post['ID'];
                $post['data']['Title'] = $post['Title'];
                $post['data']['URL'] = $post['URL'];
                $post['data']['Host'] = $post['Host'];
                $post['data']['Description'] = $post['Description'];
                $post['data']['Text'] = DecodeText($post['Text']);
                $post['data']['Thumbnail'] = $post['Thumbnail'];
                $post['data']['Link'] = GetURLText($post['Title']);
                getPost($post);
                $results[] = $post;
            }
            break;
    }
    return $results;
}

// get search results
if(IsEmpty($_GET['q'])) {
    exit('<div class="highlightContianer stopCronJobs">Please enter a query in the box above.</div>');
}
$results = search($_GET['app'], $_GET['q']);
if(!$results) {
    if($_GET['get'] == "all") {
        exit('<div class="dataNullState stopCronJobs">There are no results</div>');
    }
    exit;
}

// get first & last node
$firstNode = $results[0]['ID'];
$lastNode = end($results);
$lastNode = $lastNode['ID'];

// sort results
switch ($_GET['sort']) {
    case "Most Recent":
        function sortArray($a, $b){
            if($a['Time'] == $b['Time']){
                return 0;
            }
            return ($a['Time'] < $b['Time']) ? 1 : -1;
        }
        usort($results, sortArray);
        break;
    case "Most Liked":
        function sortArray($a, $b){
            if($a['Likes'] == $b['Likes']){
                return 0;
            }
            return ($a['Likes'] < $b['Likes']) ? 1 : -1;
        }
        usort($results, sortArray);
        break;
    case "Most Favorited":
        function sortArray($a, $b){
            if($a['Favorits'] == $b['Favorits']){
                return 0;
            }
            return ($a['Favorits'] < $b['Favorits']) ? 1 : -1;
        }
        usort($results, sortArray);
        break;
    case "Most Discussed":
        function sortArray($a, $b){
            if($a['Comments'] == $b['Comments']){
                return 0;
            }
            return ($a['Comments'] < $b['Comments']) ? 1 : -1;
        }
        usort($results, sortArray);
        break;
    case "Most Answered":
        function sortArray($a, $b){
            if($a['Answers'] == $b['Answers']){
                return 0;
            }
            return ($a['Answers'] < $b['Answers']) ? 1 : -1;
        }
        usort($results, sortArray);
        break;
}

// assign variables
$smarty->assign('app', $_GET['app']);
$smarty->assign('results', $results);
$smarty->assign('firstNode', $firstNode);
$smarty->assign('lastNode', $lastNode);

// display page templete
$smarty->display("$page.tpl");

?>