<?php
/**
 * post new post
 * 
 * @package Sngine
 * @author Yehia Abed
 * @version 0.3
 */

// fetch kernal
$depth = '../../';
require($depth.'kernal.php');

// check AJAX Request
if(!IsAJAX()) {
    header('Location: '.SITE_URL);
}

// check user exist
if(!$userExist) {
    exit(PopupError('Please log in to continue.', 'Not Logged In'));
}

// check user verified
if($userArray['Verified'] == "N") {
    VerifyError();
}

// check page parameters
if(!isset($_POST['app'])) {
    exit(PopupError(ReportError('parameters error[1] @/ajax/posts/post')));
}


// valid inputs
$valid['app'] = array('news', 'music', 'photos', 'videos', 'questions', 'polls', 'links');
if(!in_array($_POST['app'], $valid['app'])) {
    exit(PopupError(ReportError('parameters error[2] @/ajax/posts/post')));
}

// post news
if($_POST['app'] == "news") {
    
    // check page parameters
    if(!isset($_POST['text'])) {
        exit(PopupError(ReportError('parameters error[3] @/ajax/posts/post')));
    }
    
    // check if empty
    if(IsEmpty($_POST['text'])) {
        exit(PopupError('Please enter a valid (non-empty) news.'));
    }
    
    // check length
    if(strlen($_POST['text']) > 102400) {
        exit(PopupError('Your text is too long. The maximum length is 10k characters.'));
    }
    
    // sanitize inputs
    $message = $_POST['text'];
    $_POST['text'] = Sanitize($_POST['text']);
    
    // insert app post
    $db->query(sprintf("INSERT INTO posts_news (Text) VALUES (%s)", SafeSQL($_POST['text']) )) or die(PopupError(ReportError('sql error #1 @/ajax/posts/post')));
    $post['PostID'] = $db->insert_id;
    
    // insert post
    $db->query(sprintf("INSERT INTO posts (UserID, PostType, PostID, Time) VALUES (%s, 1, %s, %s)", Secure($userArray['UserID'], 'int'), Secure($post['PostID'], 'int'), Secure($now) )) or die(PopupError(ReportError('sql error #2 @/ajax/posts/post')));
    $post['ID'] = $db->insert_id;
    
    // update user posts
    $db->query(sprintf("UPDATE users SET UserPosts = UserPosts + 1 WHERE UserID = %s", Secure($userArray['UserID'], 'int') )) or die(PopupError(ReportError('sql error #3 @/ajax/posts/post')));
    
    // post mention
    PostMention($_POST['text'], $post['ID'], $post['PostID'], 1);
    
    $post['PostType'] = 1;
    $post['Time'] = $now;
    $post['Comments'] = 0;
    $post['data']['Text'] = SeeMore(DecodeText($_POST['text']));
    $post['data']['URL'] = GetURLText($_POST['text']);
    
    // post to facebook account
    if($userArray['fb_connected'] == "Y") {
    //if($userArray['fb_UserID'] !== NULL) {
        if($userArray['fb_UserID'] == NULL || $userArray['fb_UserID'] == "" || $userArray['fb_Token'] == NULL || $userArray['fb_Token'] == "") {
            exit(PopupError('There is a problem in your Facebook account connection.', 'Facebook Error #1'));
        }
        $url = "https://graph.facebook.com/".$userArray['fb_UserID']."/feed?";
        $arguments = $userArray['fb_Token']."&message=".$message;
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $arguments);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);
        $contents = curl_exec($ch);
        curl_close($ch);
        $result = json_decode($contents);
        if($result->error) {
            if(strpos($result->error->message, "access token")) {
                exit(PopupError('You have to logout and login againe with your Facebook account.', 'Facebook Error #2'));
            }elseif (strpos($result->error->message, "limit reached")) {
                exit(PopupError('You have reached your Facebook posts limit/day', 'Facebook Error #3'));
            }else {
                exit(PopupError('There is a problem in your Facebook account connection.', 'Facebook Error #4'));
            }
        }
    }
    
    // post to twitter account
    if($userArray['tw_connected'] == "Y") {
    //if($userArray['tw_UserID'] !== NULL) {
        if($userArray['tw_Token'] == NULL || $userArray['tw_TokenSecret'] == "") {
            exit(PopupError('There is a problem in your Twitter account connection.', 'Facebook Error #1'));
        }
        require_once($depth.'libs/oauth/twitter/twitteroauth.php');
        $connection = new TwitterOAuth(TW_APPID, TW_SECRET, $userArray['tw_Token'], $userArray['tw_TokenSecret']);
        $content = $connection->get('account/verify_credentials');
        $connection->post('statuses/update', array('status' => $message));
    }
    
// post music
}elseif($_POST['app'] == "music") {
    
    // check page parameters
    if(!isset($_POST['text']) || !isset($_POST['id']) || !isset($_POST['title']) || !isset($_POST['description'])) {
        exit(PopupError(ReportError('parameters error[4] @/ajax/posts/post')));
    }
    
    // check if empty
    if(IsEmpty($_POST['id']) || IsEmpty($_POST['title'])) {
        exit(PopupError("Something went wrong. We're working on getting it fixed as soon as we can."));
    }
    
    // check length
    if(strlen($_POST['text']) > 1024) {
        exit(PopupError('Your text is too long. The maximum length is 1024 characters.'));
    }
    
    // sanitize inputs
    $message = $_POST['text'];
    $_POST['text'] = Sanitize($_POST['text']);
    $_POST['id'] = Sanitize($_POST['id']);
    $_POST['title'] = Sanitize($_POST['title']);
    $_POST['description'] = Sanitize($_POST['description']);
    
    // insert app post
    $db->query(sprintf("INSERT INTO posts_tracks (Source, Title, Description, Text) VALUES (%s, %s, %s, %s)", SafeSQL($_POST['id']), SafeSQL($_POST['title']), SafeSQL($_POST['description']), SafeSQL($_POST['text']) )) or die(PopupError(ReportError('sql error #4 @/ajax/posts/post')));
    $post['PostID'] = $db->insert_id;
    
    // insert post
    $db->query(sprintf("INSERT INTO posts (UserID, PostType, PostID, Time) VALUES (%s, 2, %s, %s)", Secure($userArray['UserID'], 'int'), Secure($post['PostID'], 'int'), Secure($now) )) or die(PopupError(ReportError('sql error #5 @/ajax/posts/post')));
    $post['ID'] = $db->insert_id;
    
    // update user posts
    $db->query(sprintf("UPDATE users SET UserPosts = UserPosts + 1 WHERE UserID = %s", Secure($userArray['UserID'], 'int') )) or die(PopupError(ReportError('sql error #6 @/ajax/posts/post')));
    
    // post mention
    PostMention($_POST['text'], $post['ID'], $post['PostID'], 2);
    
    $post['PostType'] = 2;
    $post['Time'] = $now;
    $post['Comments'] = 0;
    $post['data']['Text'] = SeeMore(DecodeText($_POST['text']));
    $post['data']['Source'] = $_POST['id'];
    $post['data']['Title'] = $_POST['title'];
    $post['data']['Description'] = $_POST['description'];
    if(IsEmpty($_POST['text'])) {
        $post['data']['URL'] = GetURLText($_POST['title']);
    }else {
        $post['data']['URL'] = GetURLText($_POST['text']);
    }
    
    // post to facebook account
    $link = SITE_URL."/track/".$post['PostID']."/".$post['data']['URL'];
    if($userArray['fb_connected'] == "Y") {
        if($userArray['fb_UserID'] == NULL || $userArray['fb_UserID'] == "" || $userArray['fb_Token'] == NULL || $userArray['fb_Token'] == "") {
            exit(PopupError('There is a problem in your Facebook account connection.', 'Facebook Error #1'));
        }
        $url = "https://graph.facebook.com/".$userArray['fb_UserID']."/feed?";
        $arguments = $userArray['fb_Token']."&message=".$message."&link=".$link;
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $arguments);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);
        $contents = curl_exec($ch);
        curl_close($ch);
        $result = json_decode($contents);
        if($result->error) {
            if(strpos($result->error->message, "access token")) {
                exit(PopupError('You have to logout and login againe with your Facebook account.', 'Facebook Error #2'));
            }elseif (strpos($result->error->message, "limit reached")) {
                exit(PopupError('You have reached your Facebook posts limit/day', 'Facebook Error #3'));
            }else {
                exit(PopupError('There is a problem in your Facebook account connection.', 'Facebook Error #4'));
            }
        }
    }
    
// post photos
}elseif($_POST['app'] == "photos") {
    
    // check page parameters
    if(!isset($_POST['text']) || !isset($_POST['src']) || !isset($_POST['thumbnail'])) {
        exit(PopupError(ReportError('parameters error[5] @/ajax/posts/post')));
    }
    
    // check if empty
    if(IsEmpty($_POST['src']) || IsEmpty($_POST['thumbnail'])) {
        exit(PopupError("Something went wrong. We're working on getting it fixed as soon as we can."));
    }
    
    // check length
    if(strlen($_POST['text']) > 102400) {
        exit(PopupError('Your text is too long. The maximum length is 1024 characters.'));
    }
    
    // sanitize inputs
    $message = $_POST['text'];
    $_POST['text'] = Sanitize($_POST['text']);
    $_POST['src'] = Sanitize($_POST['src']);
    $_POST['thumbnail'] = Sanitize($_POST['thumbnail']);
    
    // insert photo source
    $db->query(sprintf("INSERT INTO posts_photos_sources (AlbumID, Source, Thumbnail, Text, Time) VALUES (%s, %s, %s, %s, %s)", Secure($userArray['UserWallPhotos']), SafeSQL($_POST['src']), SafeSQL($_POST['thumbnail']), SafeSQL($_POST['text']), Secure($now) )) or die(PopupError(ReportError('sql error #7 @/ajax/posts/post')));
    $post['data']['MediaID'] = $db->insert_id;
    
    // update wall photo album
    $db->query(sprintf("UPDATE posts_photos_albums SET Total = Total + 1, Time = %s WHERE ID = %s", Secure($now), Secure($userArray['UserWallPhotos'], 'int') )) or die(PopupError(ReportError('sql error #8 @/ajax/posts/post')));
    
    // insert app post
    $db->query(sprintf("INSERT INTO posts_photos (IsAlbum, MediaID) VALUES ('N', %s)", Secure($post['data']['MediaID'], 'int') )) or die(PopupError(ReportError('sql error #9 @/ajax/posts/post')));
    $post['PostID'] = $db->insert_id;
    
    // insert post
    $db->query(sprintf("INSERT INTO posts (UserID, PostType, PostID, Time) VALUES (%s, 3, %s, %s)", Secure($userArray['UserID'], 'int'), Secure($post['PostID'], 'int'), Secure($now) )) or die(PopupError(ReportError('sql error #10 @/ajax/posts/post')));
    $post['ID'] = $db->insert_id;
    
    // update user posts
    $db->query(sprintf("UPDATE users SET UserPosts = UserPosts + 1 WHERE UserID = %s", Secure($userArray['UserID'], 'int') )) or die(PopupError(ReportError('sql error #11 @/ajax/posts/post')));
    
    // post mention
    PostMention($_POST['text'], $post['ID'], $post['PostID'], 3);
    
    $post['PostType'] = 3;
    $post['Time'] = $now;
    $post['Comments'] = 0;
    $post['data']['media']['Text'] = SeeMore(DecodeText($_POST['text']));
    $post['data']['media']['AlbumID'] = $userArray['UserWallVideos'];
    $post['data']['media']['Source'] = $_POST['src'];
    $post['data']['media']['Thumbnail'] = $_POST['thumbnail'];
    
    // post to facebook account
    $link = SITE_URL."/photo/".$post['data']['MediaID'];
    if($userArray['fb_connected'] == "Y") {
        if($userArray['fb_UserID'] == NULL || $userArray['fb_UserID'] == "" || $userArray['fb_Token'] == NULL || $userArray['fb_Token'] == "") {
            exit(PopupError('There is a problem in your Facebook account connection.', 'Facebook Error #1'));
        }
        $url = "https://graph.facebook.com/".$userArray['fb_UserID']."/feed?";
        $arguments = $userArray['fb_Token']."&message=".$message."&link=".$link."&picture=".$_POST['thumbnail'];
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $arguments);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);
        $contents = curl_exec($ch);
        curl_close($ch);
        $result = json_decode($contents);
        if($result->error) {
            if(strpos($result->error->message, "access token")) {
                exit(PopupError('You have to logout and login againe with your Facebook account.', 'Facebook Error #2'));
            }elseif (strpos($result->error->message, "limit reached")) {
                exit(PopupError('You have reached your Facebook posts limit/day', 'Facebook Error #3'));
            }else {
                exit(PopupError('There is a problem in your Facebook account connection.', 'Facebook Error #4'));
            }
        }
    }
    
// post videos
}elseif($_POST['app'] == "videos") {
    
    // check page parameters
    if(!isset($_POST['text']) || !isset($_POST['id']) || !isset($_POST['type']) || !isset($_POST['thumbnail'])) {
        exit(PopupError(ReportError('parameters error[6] @/ajax/posts/post')));
    }
    
    // check if empty
    if(IsEmpty($_POST['id']) || IsEmpty($_POST['type']) || IsEmpty($_POST['thumbnail'])) {
        exit(PopupError("Something went wrong. We're working on getting it fixed as soon as we can."));
    }
    
    // check length
    if(strlen($_POST['text']) > 1024) {
        exit(PopupError('Your text is too long. The maximum length is 1024 characters.'));
    }
    
    // sanitize inputs
    $message = $_POST['text'];
    $_POST['text'] = Sanitize($_POST['text']);
    $_POST['id'] = Sanitize($_POST['id']);
    $_POST['type'] = Sanitize($_POST['type']);
    $_POST['thumbnail'] = Sanitize($_POST['thumbnail']);
    
    // insert video source
    $db->query(sprintf("INSERT INTO posts_videos_sources (AlbumID, Source, Type, Thumbnail, Text, Time) VALUES (%s, %s, %s, %s, %s, %s)", Secure($userArray['UserWallVideos'], 'int'), SafeSQL($_POST['id']), SafeSQL($_POST['type']), SafeSQL($_POST['thumbnail']), SafeSQL($_POST['text']), Secure($now) )) or die(PopupError(ReportError('sql error #12 @/ajax/posts/post')));
    $post['data']['MediaID'] = $db->insert_id;
    
    // update wall video album
    $db->query(sprintf("UPDATE posts_videos_albums SET Total = Total + 1, Time = %s WHERE ID = %s", Secure($now), Secure($userArray['UserWallVideos'], 'int') )) or die(PopupError(ReportError('sql error #13 @/ajax/posts/post')));
    
    // insert app post
    $db->query(sprintf("INSERT INTO posts_videos (IsAlbum, MediaID) VALUES ('N', %s)", Secure($post['data']['MediaID'], 'int') )) or die(PopupError(ReportError('sql error #14 @/ajax/posts/post')));
    $post['PostID'] = $db->insert_id;
    
    // insert post
    $db->query(sprintf("INSERT INTO posts (UserID, PostType, PostID, Time) VALUES (%s, 4, %s, %s)", Secure($userArray['UserID'], 'int'), Secure($post['PostID'], 'int'), Secure($now) )) or die(PopupError(ReportError('sql error #15 @/ajax/posts/post')));
    $post['ID'] = $db->insert_id;
    
    // update user posts
    $db->query(sprintf("UPDATE users SET UserPosts = UserPosts + 1 WHERE UserID = %s", Secure($userArray['UserID'], 'int') )) or die(PopupError(ReportError('sql error #16 @/ajax/posts/post')));
    
    // post mention
    PostMention($_POST['text'], $post['ID'], $post['PostID'], 4);
    
    $post['PostType'] = 4;
    $post['Time'] = $now;
    $post['Comments'] = 0;
    $post['data']['media']['Text'] = SeeMore(DecodeText($_POST['text']));
    $post['data']['media']['Thumbnail'] = $_POST['thumbnail'];
    $post['data']['media']['AlbumID'] = $userArray['UserWallVideos'];
    $post['data']['media']['Type'] = $_POST['type'];
    $post['data']['media']['Source'] = $_POST['id'];
    
    // post to facebook account
    $link = SITE_URL."/video/".$post['data']['MediaID'];
    if($userArray['fb_connected'] == "Y") {
        if($userArray['fb_UserID'] == NULL || $userArray['fb_UserID'] == "" || $userArray['fb_Token'] == NULL || $userArray['fb_Token'] == "") {
            exit(PopupError('There is a problem in your Facebook account connection.', 'Facebook Error #1'));
        }
        $url = "https://graph.facebook.com/".$userArray['fb_UserID']."/feed?";
        $arguments = $userArray['fb_Token']."&message=".$message."&link=".$link."&picture=".$_POST['thumbnail'];
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $arguments);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);
        $contents = curl_exec($ch);
        curl_close($ch);
        $result = json_decode($contents);
        if($result->error) {
            if(strpos($result->error->message, "access token")) {
                exit(PopupError('You have to logout and login againe with your Facebook account.', 'Facebook Error #2'));
            }elseif (strpos($result->error->message, "limit reached")) {
                exit(PopupError('You have reached your Facebook posts limit/day', 'Facebook Error #3'));
            }else {
                exit(PopupError('There is a problem in your Facebook account connection.', 'Facebook Error #4'));
            }
        }
    }
    
// post questions
}elseif($_POST['app'] == "questions") {
    
    // check page parameters
    if(!isset($_POST['title']) || !isset($_POST['text'])) {
        exit(PopupError(ReportError('parameters error[7] @/ajax/posts/post')));
    }
    
    // check if empty
    if(IsEmpty($_POST['title'])) {
        exit(PopupError('Please enter a valid (non-empty) question.'));
    }
    
    // check length
    if(strlen($_POST['title']) > 255) {
        exit(PopupError('Your question is too long. The maximum length is 255 characters.'));
    }
    if(strlen($_POST['title']) < 3) {
        exit(PopupError('Your question is too short.'));
    }
    if(strlen($_POST['text']) > 1024) {
        exit(PopupError('Your description is too long. The maximum length is 1024 characters.'));
    }
    
    // sanitize inputs
    $message = $_POST['text'];
    $_POST['title'] = Sanitize($_POST['title']);
    $_POST['text'] = Sanitize($_POST['text']);
    
    // insert app post
    $db->query(sprintf("INSERT INTO posts_questions (Title, Text) VALUES (%s, %s)", SafeSQL($_POST['title']), SafeSQL($_POST['text']) )) or die(PopupError(ReportError('sql error #17 @/ajax/posts/post')));
    $post['PostID'] = $db->insert_id;
    
    // insert post
    $db->query(sprintf("INSERT INTO posts (UserID, PostType, PostID, Time) VALUES (%s, 6, %s, %s)", Secure($userArray['UserID'], 'int'), Secure($post['PostID'], 'int'), Secure($now) )) or die(PopupError(ReportError('sql error #18 @/ajax/posts/post')));
    $post['ID'] = $db->insert_id;
    
    // update user posts
    $db->query(sprintf("UPDATE users SET UserPosts = UserPosts + 1 WHERE UserID = %s", Secure($userArray['UserID'], 'int') )) or die(PopupError(ReportError('sql error #19 @/ajax/posts/post')));
    
    // post mention
    PostMention($_POST['text'], $post['ID'], $post['PostID'], 6);
    
    $post['PostType'] = 6;
    $post['Time'] = $now;
    $post['data']['Answers'] = 0;
    $post['data']['Title'] = $_POST['title'];
    $post['data']['URL'] = GetURLText($_POST['title']);
    
    // post to facebook account
    $link = SITE_URL."/question/".$post['PostID']."/".$post['data']['URL'];
    if($userArray['fb_connected'] == "Y") {
        if($userArray['fb_UserID'] == NULL || $userArray['fb_UserID'] == "" || $userArray['fb_Token'] == NULL || $userArray['fb_Token'] == "") {
            exit(PopupError('There is a problem in your Facebook account connection.', 'Facebook Error #1'));
        }
        $url = "https://graph.facebook.com/".$userArray['fb_UserID']."/feed?";
        $arguments = $userArray['fb_Token']."&message=".$message."&link=".$link;
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $arguments);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);
        $contents = curl_exec($ch);
        curl_close($ch);
        $result = json_decode($contents);
        if($result->error) {
            if(strpos($result->error->message, "access token")) {
                exit(PopupError('You have to logout and login againe with your Facebook account.', 'Facebook Error #2'));
            }elseif (strpos($result->error->message, "limit reached")) {
                exit(PopupError('You have reached your Facebook posts limit/day', 'Facebook Error #3'));
            }else {
                exit(PopupError('There is a problem in your Facebook account connection.', 'Facebook Error #4'));
            }
        }
    }
    
// post polls
}elseif($_POST['app'] == "polls") {
    
    // check page parameters
    if(!isset($_POST['title']) || !isset($_POST['len'])) {
        exit(PopupError(ReportError('parameters error[8] @/ajax/posts/post')));
    }
    
    // check if empty
    if(IsEmpty($_POST['title'])) {
        exit(PopupError('Please enter a valid (non-empty) poll.'));
    }
    
    // check length
    if(strlen($_POST['title']) > 255) {
        exit(PopupError('Your poll is too long. The maximum length is 255 characters.'));
    }
    if(strlen($_POST['title']) < 3) {
        exit(PopupError('Your poll is too short.'));
    }
    
    // check poll options
    if(intval($_POST['len']) < 2) {
        exit(PopupError('Please add at least two options.'));
    }
    
    $index = 0;
    $counter = 0;
    while($counter < intval($_POST['len'])) {
        $key = 'opt'.$index;
        if(isset($_POST[$key]) && !IsEmpty($_POST[$key])) {
            if(in_array($_POST[$key], $options)) {
                exit(PopupError('You were trying to add a poll option that already exists on this poll.'));
            }
            $options[] = $_POST[$key];
            $counter++;
        }
        $index++;
    }
    
    if(count($options) < 2) {
        exit(PopupError('Please add at least two options.'));
    }
    
    // sanitize inputs
    $message = $_POST['title'];
    $_POST['title'] = Sanitize($_POST['title']);
    
    // insert app post
    $db->query(sprintf("INSERT INTO posts_polls (Question) VALUES (%s)", SafeSQL($_POST['title']) )) or die(PopupError(ReportError('sql error #20 @/ajax/posts/post')));
    $post['PostID'] = $db->insert_id;
    
    // insert poll options
    foreach($options as $key => $value) {
        $value = Sanitize($value);
        $db->query(sprintf("INSERT INTO posts_polls_options (Title, PollID) VALUES (%s, %s)", SafeSQL($value),  Secure($post['PostID'], 'int') )) or die(PopupError(ReportError('sql error #21 @/ajax/posts/post')));
        $pollOptions[$key]['ID'] = $db->insert_id;
        $pollOptions[$key]['Title'] = $value;
    }
    
    // insert post
    $db->query(sprintf("INSERT INTO posts (UserID, PostType, PostID, Time) VALUES (%s, 7, %s, %s)", Secure($userArray['UserID'], 'int'), Secure($post['PostID'], 'int'), Secure($now) )) or die(PopupError(ReportError('sql error #22 @/ajax/posts/post')));
    $post['ID'] = $db->insert_id;
    
    // update user posts
    $db->query(sprintf("UPDATE users SET UserPosts = UserPosts + 1 WHERE UserID = %s", Secure($userArray['UserID'], 'int') )) or die(PopupError(ReportError('sql error #23 @/ajax/posts/post')));
    
    // post mention
    if(isset($_POST['mention']) && $_POST['mention'] == '1') {
        if($_POST['type'] == 'p') {
            $isUser = 'N';
            $db->query(sprintf("INSERT INTO posts_mentions (PostID, MentionID, IsUser) VALUES (%s, %s, %s)", Secure($post['ID'], 'int'), Secure($_POST['mid'], 'int'), Secure($isUser) )) or SQLError();
        }elseif ($_POST['type'] == 'u') {
            $isUser = 'Y';
            $db->query(sprintf("INSERT INTO posts_mentions (PostID, MentionID, IsUser) VALUES (%s, %s, %s)", Secure($post['ID'], 'int'), Secure($_POST['mid'], 'int'), Secure($isUser) )) or SQLError();
            $db->query(sprintf("INSERT INTO notifications (UserID, Action, AuthorID, PostType, PostID, Time) VALUES (%s, 9, %s, 7, %s, %s)", Secure($userArray['UserID'], 'int'), Secure($_POST['mid'], 'int'), Secure($post['PostID'], 'int'), Secure($now) )) or SQLError();
            $db->query(sprintf("UPDATE users SET UserNotifications = UserNotifications + 1, UserNewNotifications = UserNewNotifications + 1 WHERE UserID = %s", Secure($_POST['mid'], 'int'))) or SQLError();
        }
    }
    
    $post['PostType'] = 7;
    $post['Time'] = $now;
    $post['Comments'] = 0;
    $post['data']['Question'] = $_POST['title'];
    $post['pollOptions'] = $pollOptions;
    $post['data']['URL'] = GetURLText($_POST['title']);
    
    // post to facebook account
    $link = SITE_URL."/poll/".$post['PostID']."/".$post['data']['URL'];
    if($userArray['fb_connected'] == "Y") {
        if($userArray['fb_UserID'] == NULL || $userArray['fb_UserID'] == "" || $userArray['fb_Token'] == NULL || $userArray['fb_Token'] == "") {
            exit(PopupError('There is a problem in your Facebook account connection.', 'Facebook Error #1'));
        }
        $url = "https://graph.facebook.com/".$userArray['fb_UserID']."/feed?";
        $arguments = $userArray['fb_Token']."&message=".$message."&link=".$link;
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $arguments);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);
        $contents = curl_exec($ch);
        curl_close($ch);
        $result = json_decode($contents);
        if($result->error) {
            if(strpos($result->error->message, "access token")) {
                exit(PopupError('You have to logout and login againe with your Facebook account.', 'Facebook Error #2'));
            }elseif (strpos($result->error->message, "limit reached")) {
                exit(PopupError('You have reached your Facebook posts limit/day', 'Facebook Error #3'));
            }else {
                exit(PopupError('There is a problem in your Facebook account connection.', 'Facebook Error #4'));
            }
        }
    }
    
// post links
}elseif($_POST['app'] == "links") {
    
    // check page parameters
    if(!isset($_POST['text']) || !isset($_POST['title']) || !isset($_POST['url']) || !isset($_POST['host']) || !isset($_POST['description']) || !isset($_POST['thumbnail'])) {
        exit(PopupError(ReportError('parameters error[9] @/ajax/posts/post')));
    }
    
    // check if empty
    if(IsEmpty($_POST['url']) || IsEmpty($_POST['host'])) {
        exit(PopupError("Something went wrong. We're working on getting it fixed as soon as we can."));
    }
    
    // check length
    if(strlen($_POST['text']) > 1024) {
        exit(PopupError('Your text is too long. The maximum length is 1024 characters.'));
    }
    
    // sanitize inputs
    $message = $_POST['text'];
    $_POST['text'] = Sanitize($_POST['text']);
    $_POST['title'] = Sanitize($_POST['title']);
    $_POST['url'] = Sanitize($_POST['url']);
    $_POST['host'] = Sanitize($_POST['host']);
    $_POST['description'] = Sanitize($_POST['description']);
    $_POST['thumbnail'] = Sanitize($_POST['thumbnail']);
    
    // insert app post
    $db->query(sprintf("INSERT INTO posts_links (Title, URL, Host, Description, Text, Thumbnail) VALUES (%s, %s, %s, %s, %s, %s)", SafeSQL($_POST['title']), SafeSQL($_POST['url']), SafeSQL($_POST['host']), SafeSQL($_POST['description']), SafeSQL($_POST['text']), SafeSQL($_POST['thumbnail']) )) or die(PopupError(ReportError('sql error #24 @/ajax/posts/post')));
    $post['PostID'] = $db->insert_id;
    
    // insert post
    $db->query(sprintf("INSERT INTO posts (UserID, PostType, PostID, Time) VALUES (%s, 8, %s, %s)", Secure($userArray['UserID'], 'int'), Secure($post['PostID'], 'int'), Secure($now) )) or die(PopupError(ReportError('sql error #25 @/ajax/posts/post')));
    $post['ID'] = $db->insert_id;
    
    // update user posts
    $db->query(sprintf("UPDATE users SET UserPosts = UserPosts + 1 WHERE UserID = %s", Secure($userArray['UserID'], 'int') )) or die(PopupError(ReportError('sql error #26 @/ajax/posts/post')));
    
    // post mention
    PostMention($_POST['text'], $post['ID'], $post['PostID'], 8);
    
    $post['PostType'] = 8;
    $post['Time'] = $now;
    $post['Comments'] = 0;
    $post['data']['Title'] = $_POST['title'];
    $post['data']['URL'] = $_POST['url'];
    $post['data']['Host'] = $_POST['host'];
    $post['data']['Description'] = $_POST['description'];
    $post['data']['Text'] = DecodeText($_POST['text']);
    $post['data']['Thumbnail'] = $_POST['thumbnail'];
    $post['data']['Link'] = GetURLText($_POST['title']);
    
    // post to facebook account
    $link = SITE_URL."/link/".$post['PostID']."/".$post['data']['Link'];
    if($userArray['fb_connected'] == "Y") {
        if($userArray['fb_UserID'] == NULL || $userArray['fb_UserID'] == "" || $userArray['fb_Token'] == NULL || $userArray['fb_Token'] == "") {
            exit(PopupError('There is a problem in your Facebook account connection.', 'Facebook Error #1'));
        }
        $url = "https://graph.facebook.com/".$userArray['fb_UserID']."/feed?";
        $arguments = $userArray['fb_Token']."&message=".$message."&link=".$link;
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $arguments);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);
        $contents = curl_exec($ch);
        curl_close($ch);
        $result = json_decode($contents);
        if($result->error) {
            if(strpos($result->error->message, "access token")) {
                exit(PopupError('You have to logout and login againe with your Facebook account.', 'Facebook Error #2'));
            }elseif (strpos($result->error->message, "limit reached")) {
                exit(PopupError('You have reached your Facebook posts limit/day', 'Facebook Error #3'));
            }else {
                exit(PopupError('There is a problem in your Facebook account connection.', 'Facebook Error #4'));
            }
        }
    }
    
}

// assigne variables
$smarty->assign('post', $post);
$smarty->assign('app', $_POST['app']);

// return data
$data['status'] = 'success';
$data['value'] = $smarty->fetch("ajax.posts.post.tpl");
exit(json_encode($data));

?>