<?php
/**
 * get posts
 * 
 * @package Sngine
 * @author Yehia Abed
 * @version 0.3
 */

// fetch kernal
$depth = '../../';
require($depth.'kernal.php');

// check AJAX Request
if(!IsAJAX()) {
    header('Location: '.SITE_URL);
}

// define the tple
$page = "ajax.posts.get";

// check page parameters
if(!isset($_GET['app']) || !isset($_GET['get']) || !isset($_GET['filter']) || !isset($_GET['sort']) || !isset($_GET['startPoint'])) {
    exit(ReportError('parameters error[1] @/ajax/posts/get'));
}

// valid inputs
$valid['app'] = array('home', 'wall', 'news', 'music', 'photos', 'videos', 'discussions', 'questions', 'polls', 'links');
$valid['get'] = array('all', 'new', 'old');
$valid['filter'] = array('All', 'Just Me', 'Just User', 'Just Mention', 'Just Followers', 'Just Followings');
$valid['sort'] = array('','Most Recent', 'Most Liked', 'Most Favorited', 'Most Discussed', 'Most Answered');

if(!in_array($_GET['app'], $valid['app']) || !in_array($_GET['get'], $valid['get']) || !in_array($_GET['filter'], $valid['filter']) || !in_array($_GET['sort'], $valid['sort'])) {
    exit(ReportError('parameters error[2] @/ajax/posts/get'));
}

// prepare where statement
if(count($userBlockedUsers) > 0) {
    $whereStatement = ' WHERE post.UserID NOT IN (' . implode(',', $userBlockedUsers) . ')';
    $whereStatementComments = ' AND comm.UserID NOT IN (' . implode(',', $userBlockedUsers) . ')';
}

if(count($userBlockedPosts) > 0) {
    if(empty($whereStatement)) {
        $whereStatement  = ' WHERE post.ID NOT IN (' . implode(',', $userBlockedPosts) . ')';
    }else {
        $whereStatement .= ' AND post.ID NOT IN (' . implode(',', $userBlockedPosts) . ')';
    }
}

if($_GET['get'] == "new") {
    if(empty($whereStatement)) {
        $whereStatement  = " WHERE post.ID > ".Secure($_GET['startPoint'], 'int');
    }else {
        $whereStatement .= " AND post.ID > ".Secure($_GET['startPoint'], 'int');
    }
}elseif ($_GET['get'] == "old") {
    if(empty($whereStatement)) {
        $whereStatement  = " WHERE post.ID < ".Secure($_GET['startPoint'], 'int');
    }else {
        $whereStatement .= " AND post.ID < ".Secure($_GET['startPoint'], 'int');
    }
}

if($_GET['filter'] == "Just Followings") {
    if(count($userFollowings) > 0) {
        if(empty($whereStatement)) {
            $whereStatement  = ' WHERE post.UserID IN (' . implode(',', $userFollowings) . ')';
        }else {
            $whereStatement .= ' AND post.UserID IN (' . implode(',', $userFollowings) . ')';
        }
    }else {
        exit('<div class="dataNullState stopCronJobs">You do not have any followings yet!</div>');
    }
}elseif ($_GET['filter'] == "Just Followers") {
    if(count($userFollowers) > 0) {
        if(empty($whereStatement)) {
            $whereStatement  = ' WHERE post.UserID IN (' . implode(',', $userFollowers) . ')';
        }else {
            $whereStatement .= ' AND post.UserID IN (' . implode(',', $userFollowers) . ')';
        }
    }else {
        exit('<div class="dataNullState stopCronJobs">You do not have any followers yet!</div>');
    }
}elseif ($_GET['filter'] == "Just Me") {
    if(empty($whereStatement)) {
        $whereStatement  = ' WHERE post.UserID = '.Secure($userArray['UserID'], 'int');
    }else {
        $whereStatement .= ' AND post.UserID = '.Secure($userArray['UserID'], 'int');
    }
}elseif ($_GET['filter'] == "Just User") {
    if(!isset($_GET['id'])) {
        exit(ReportError('parameters error[3] @/ajax/posts/get'));
    }
    $mentionStatement = ' LEFT JOIN posts_mentions mention ON post.ID = mention.PostID ';
    if(empty($whereStatement)) {
        $whereStatement  = " WHERE ((mention.IsUser = 'Y' AND mention.MentionID = ".Secure($_GET['id'], 'int').") OR post.UserID = ".Secure($_GET['id'], 'int').")";
    }else {
        $whereStatement .= " AND ((mention.IsUser = 'Y' AND mention.MentionID = ".Secure($_GET['id'], 'int').") OR post.UserID = ".Secure($_GET['id'], 'int').")";
    }
}elseif ($_GET['filter'] == "Just Mention") {
    if(!isset($_GET['id'])) {
        exit(ReportError('parameters error[4] @/ajax/posts/get'));
    }
    $mentionStatement = ' INNER JOIN posts_mentions mention ON post.ID = mention.PostID ';
    if(empty($whereStatement)) {
        $whereStatement  = " WHERE mention.IsUser = 'N' AND mention.MentionID = ".Secure($_GET['id'], 'int');
    }else {
        $whereStatement .= " AND mention.IsUser = 'N' AND mention.MentionID = ".Secure($_GET['id'], 'int');
    }
}

// prepare application
$limitStatement = " LIMIT ".$systemSetting['MaxFeeds'];
switch ($_GET['app']) {
    case "news":
        if(empty($whereStatement)) {
            $whereStatement  = " WHERE post.PostType = 1";
        }else {
            $whereStatement .= " AND post.PostType = 1";
        }
        break;
    case "music":
        if(empty($whereStatement)) {
            $whereStatement  = " WHERE post.PostType = 2";
        }else {
            $whereStatement .= " AND post.PostType = 2";
        }
        break;
    case "photos":
        $page = "ajax.posts.media";
        // prepare pagination
        if(isset($_GET['page'])) {
            $spage = (int) $_GET['page'];
            $spage = ($spage == 0) ? 1 : $spage;
        }else {
            $spage = 1;
        }
        if($_GET['filter'] == "Just User") {
            $total = $db->query(sprintf("SELECT * FROM posts post INNER JOIN posts_photos photo ON post.PostID = photo.ID AND post.PostType = 3 WHERE post.UserID = %s", Secure($_GET['id'], 'int'))) or die(ReportError('sql error #1 @/ajax/posts/get'));
        }else {
            $total = $db->query("SELECT * FROM posts_photos") or die(ReportError('sql error #2 @/ajax/posts/get'));
        }
        $total = $total->num_rows;
        require($depth.'libs/class-pagination.php');
        $pagination = new Pagination($spage, $systemSetting['MaxMediaFeeds'], $total, 'photos.php?page=%s');
        $limitStatement = $pagination->getLimitSql();
        $smarty->assign('pager', $pagination->getPagerMini());
        
        if(empty($whereStatement)) {
            $whereStatement  = " WHERE post.PostType = 3";
        }else {
            $whereStatement .= " AND post.PostType = 3";
        }
        break;
    case "videos":
        $page = "ajax.posts.media";
        // prepare pagination
        if(isset($_GET['page'])) {
            $spage = (int) $_GET['page'];
            $spage = ($spage == 0) ? 1 : $spage;
        }else {
            $spage = 1;
        }
        if($_GET['filter'] == "Just User") {
            $total = $db->query(sprintf("SELECT * FROM posts post INNER JOIN posts_videos video ON post.PostID = video.ID AND post.PostType = 4 WHERE post.UserID = %s", Secure($_GET['id'], 'int'))) or die(ReportError('sql error #3 @/ajax/posts/get'));
        }else {
            $total = $db->query("SELECT * FROM posts_videos") or die(ReportError('sql error #4 @/ajax/posts/get'));
        }
        $total = $total->num_rows;
        require($depth.'libs/class-pagination.php');
        $pagination = new Pagination($spage, $systemSetting['MaxMediaFeeds'], $total, 'videos.php?page=%s');
        $limitStatement = $pagination->getLimitSql();
        $smarty->assign('pager', $pagination->getPagerMini());
        if(empty($whereStatement)) {
            $whereStatement  = " WHERE post.PostType = 4";
        }else {
            $whereStatement .= " AND post.PostType = 4";
        }
        break;
    case "discussions":
        if(empty($whereStatement)) {
            $whereStatement  = " WHERE post.PostType = 5";
        }else {
            $whereStatement .= " AND post.PostType = 5";
        }
        break;
    case "questions":
        if(empty($whereStatement)) {
            $whereStatement  = " WHERE post.PostType = 6";
        }else {
            $whereStatement .= " AND post.PostType = 6";
        }
        break;
    case "polls":
        if(empty($whereStatement)) {
            $whereStatement  = " WHERE post.PostType = 7";
        }else {
            $whereStatement .= " AND post.PostType = 7";
        }
        break;
    case "links":
        if(empty($whereStatement)) {
            $whereStatement  = " WHERE post.PostType = 8";
        }else {
            $whereStatement .= " AND post.PostType = 8";
        }
        break;
    }
    
// get posts
if(empty($whereStatement)) $whereStatement = "";
if(empty($mentionStatement)) $mentionStatement = "";
$getPosts = $db->query("SELECT post.*, user.UserName, user.UserFirstName, user.UserLastName, user.UserAvatarPathMedium AS UserAvatarPath FROM posts post INNER JOIN users user ON post.UserID = user.UserID".$mentionStatement.$whereStatement." ORDER BY post.ID DESC ".$limitStatement) or die(ReportError('sql error #5 @/ajax/posts/get'));

if($getPosts->num_rows == 0) {
    if($_GET['get'] == "all") {
        exit('<div class="dataNullState stopCronJobs">There are no more '.$_GET['app'].' to show.</div>');
    }
    exit;
}

while($post = $getPosts->fetch_array(MYSQLI_ASSOC)) {
    
    // news posts
    if($post['PostType'] == 1) {
        
        $getData = $db->query(sprintf("SELECT * FROM posts_news WHERE ID = %s", Secure($post['PostID'], 'int'))) or die(ReportError('sql error #6 @/ajax/posts/get'));
        $post['data'] = $getData->fetch_array(MYSQLI_ASSOC);
        $post['data']['URL'] = GetURLText($post['data']['Text']);
        $post['data']['Text'] = SeeMore(DecodeText($post['data']['Text']));
        
    // music posts
    }elseif ($post['PostType'] == 2) {
        
        $getData = $db->query(sprintf("SELECT * FROM posts_tracks WHERE ID = %s", Secure($post['PostID'], 'int'))) or die(ReportError('sql error #7 @/ajax/posts/get'));
        $post['data'] = $getData->fetch_array(MYSQLI_ASSOC);
        if(IsEmpty($post['data']['Text'])) {
            $post['data']['URL'] = GetURLText($post['data']['Title']);
        }else {
            $post['data']['URL'] = GetURLText($post['data']['Text']);
        }
        $post['data']['Text'] = SeeMore(DecodeText($post['data']['Text']));
        
    // photos posts
    }elseif ($post['PostType'] == 3) {
        
        $getData = $db->query(sprintf("SELECT IsAlbum, MediaID FROM posts_photos WHERE ID = %s", Secure($post['PostID'], 'int'))) or die(ReportError('sql error #8 @/ajax/posts/get'));
        $post['data'] = $getData->fetch_array(MYSQLI_ASSOC);
        
        if($post['data']['IsAlbum'] == 'Y') {
            $getMedia =  $db->query(sprintf("SELECT album.Title, album.Text, album.New, album.ThumbnailID, source.Thumbnail FROM posts_photos_albums album LEFT JOIN posts_photos_sources source ON album.ThumbnailID = source.ID WHERE album.ID = %s", Secure($post['data']['MediaID'], 'int'))) or die(ReportError('sql error #9 @/ajax/posts/get'));
            $post['data']['media'] = $getMedia->fetch_array(MYSQLI_ASSOC);
        }else {
            $getMedia =  $db->query(sprintf("SELECT source.Source, source.Thumbnail, source.Text, source.AlbumID, album.Title FROM posts_photos_sources source INNER JOIN posts_photos_albums album ON source.AlbumID = album.ID WHERE source.ID = %s", Secure($post['data']['MediaID'], 'int'))) or die(ReportError('sql error #10 @/ajax/posts/get'));
            $post['data']['media'] = $getMedia->fetch_array(MYSQLI_ASSOC);
        }
        $post['data']['media']['Text'] = SeeMore(DecodeText($post['data']['media']['Text']));
        
    // videos posts
    }elseif ($post['PostType'] == 4) {
        
        $getData = $db->query(sprintf("SELECT IsAlbum, MediaID FROM posts_videos WHERE ID = %s", Secure($post['PostID'], 'int'))) or die(ReportError('sql error #11 @/ajax/posts/get'));
        $post['data'] = $getData->fetch_array(MYSQLI_ASSOC);
        
        if($post['data']['IsAlbum'] == 'Y') {
            $getMedia =  $db->query(sprintf("SELECT album.Title, album.Text, album.New, album.ThumbnailID, source.Thumbnail FROM posts_videos_albums album LEFT JOIN posts_videos_sources source ON album.ThumbnailID = source.ID WHERE album.ID = %s", Secure($post['data']['MediaID'], 'int'))) or die(ReportError('sql error #12 @/ajax/posts/get'));
            $post['data']['media'] = $getMedia->fetch_array(MYSQLI_ASSOC);
        }else {
            $getMedia =  $db->query(sprintf("SELECT source.Source, source.Type, source.Thumbnail, source.Text, source.AlbumID, album.Title FROM posts_videos_sources source INNER JOIN posts_videos_albums album ON source.AlbumID = album.ID WHERE source.ID = %s", Secure($post['data']['MediaID'], 'int'))) or die(ReportError('sql error #13 @/ajax/posts/get'));
            $post['data']['media'] = $getMedia->fetch_array(MYSQLI_ASSOC);
        }
        $post['data']['media']['Text'] = SeeMore(DecodeText($post['data']['media']['Text']));
        
    // discussions posts
    }elseif ($post['PostType'] == 5) {
        
        $getData = $db->query(sprintf("SELECT * FROM posts_discussions WHERE ID = %s", Secure($post['PostID'], 'int') )) or die(ReportError('sql error #14 @/ajax/posts/get'));
        $post['data'] = $getData->fetch_array(MYSQLI_ASSOC);
        $post['data']['Text'] = Parse($post['data']['Text']);
        $post['data']['URL'] = GetURLText($post['data']['Title']);
        
    // questions posts
    }elseif ($post['PostType'] == 6) {
        
        $getData = $db->query(sprintf("SELECT * FROM posts_questions WHERE ID = %s", Secure($post['PostID'], 'int') )) or die(ReportError('sql error #15 @/ajax/posts/get'));
        $post['data'] = $getData->fetch_array(MYSQLI_ASSOC);
        $post['Answers'] = $post['data']['Answers'];
        $post['data']['URL'] = GetURLText($post['data']['Title']);
        
    // polls posts
    }elseif ($post['PostType'] == 7) {
        
        $getData = $db->query(sprintf("SELECT * FROM posts_polls WHERE ID = %s", Secure($post['PostID'], 'int') )) or die(ReportError('sql error #16 @/ajax/posts/get'));
        $post['data'] = $getData->fetch_array(MYSQLI_ASSOC);
        
        // get poll options
        $getPollOptions = $db->query(sprintf("SELECT * FROM posts_polls_options WHERE PollID = %s", Secure($post['PostID'], 'int') )) or die(ReportError('sql error #17 @/ajax/posts/get'));
        while($pollOption = $getPollOptions->fetch_array(MYSQLI_ASSOC)) {
            if($post['data']['Votes'] == 0) {
                $pollOption['Bar'] = 0;
            }else {
                $pollOption['Bar'] = ($pollOption['Votes'] / $post['data']['Votes']) * 100;
            }
            // check if user select the option
            $getOption = $db->query(sprintf("SELECT * FROM users_polls_options WHERE UserID = %s AND PollID = %s AND OptionID = %s", Secure($userArray['UserID'], 'int'), Secure($post['PostID'], 'int'), Secure($pollOption['ID'], 'int') )) or die(ReportError('sql error #18 @/ajax/posts/get'));
            if($getOption->num_rows == 0) {
                $pollOption['select'] = false;
            }else {
                $pollOption['select'] = true;
                $post['data']['selected'] = $pollOption['ID'];
            }
            $post['pollOptions'][] = $pollOption;
        }
        $post['data']['URL'] = GetURLText($post['data']['Question']);
        
    // links posts
    }elseif ($post['PostType'] == 8) {
        
        $getData = $db->query(sprintf("SELECT * FROM posts_links WHERE ID = %s", Secure($post['PostID'], 'int') )) or die(ReportError('sql error #19 @/ajax/posts/get'));
        $post['data'] = $getData->fetch_array(MYSQLI_ASSOC);
        $post['data']['Text'] = DecodeText($post['data']['Text']);
        $post['data']['Link'] = GetURLText($post['data']['Title']);
        
    // forums posts
    }elseif ($post['PostType'] == 9) {
        
        $getData = $db->query(sprintf("SELECT * FROM posts_forums WHERE ID = %s", Secure($post['PostID'], 'int') )) or die(ReportError('sql error #19r @/ajax/posts/get'));
        $post['data'] = $getData->fetch_array(MYSQLI_ASSOC);
        $post['data']['URL'] = GetURLText($post['data']['Title']);
        
    }
    
    // check if user favorited this post before
    $getPostStatus = $db->query(sprintf("SELECT Favorited FROM users_posts_favorites WHERE UserID = %s AND PostType = %s AND PostID = %s", Secure($userArray['UserID'], 'int'), Secure($post['PostType'], 'int'), Secure($post['PostID'], 'int') )) or die(ReportError('sql error #20 @/ajax/posts/get'));
    if($getPostStatus->num_rows > 0) {
        $post['favorited'] = true;
    }else {
        $post['favorited'] = false;
    }
    
    // check if user liked|disliked this post before
    $getPostStatus = $db->query(sprintf("SELECT Liked FROM users_posts_likes WHERE UserID = %s AND PostType = %s AND PostID = %s", Secure($userArray['UserID'], 'int'), Secure($post['PostType'], 'int'), Secure($post['PostID'], 'int') )) or die(ReportError('sql error #21 @/ajax/posts/get'));
    if($getPostStatus->num_rows > 0) {
        $postStatus = $getPostStatus->fetch_array(MYSQLI_ASSOC);
        $post['liked'] = $postStatus['Liked'];
    }
    
    // get comments
    if($post['Comments'] > 0 && $post['Comments'] <= $systemSetting['MaxQComments']) {
        $post['prevComments'] = ($post['Comments'] > $systemSetting['MaxQCommentsViewed'])? $post['Comments'] - $systemSetting['MaxQCommentsViewed']: 0;
        $getComments = $db->query(sprintf("SELECT comm.*, user.UserName, user.UserFirstName, user.UserLastName, user.UserAvatarPathSmall AS UserAvatarPath FROM posts_comments comm INNER JOIN users user ON comm.UserID = user.UserID WHERE comm.PostType = %s AND comm.PostID = %s ".$whereStatementComments." ORDER BY comm.Time ASC LIMIT %s,".$systemSetting['MaxQCommentsViewed'], Secure($post['PostType'], 'int'), Secure($post['PostID'], 'int'), $post['prevComments'] )) or die(ReportError('sql error #22 @/ajax/posts/get'));
        while($comment = $getComments->fetch_array(MYSQLI_ASSOC)) {
            
            // check if user liked|disliked this comment before
            $getCommentStatus = $db->query(sprintf("SELECT Liked FROM users_comments_likes WHERE UserID = %s AND CommentID = %s", SafeSQL($userArray['UserID'], 'int'), SafeSQL($comment['ID'], 'int') )) or die(ReportError('sql error #23 @/ajax/posts/get'));
            if($getCommentStatus->num_rows > 0) {
                $commentStatus = $getCommentStatus->fetch_array(MYSQLI_ASSOC);
                $comment['liked'] = $commentStatus['Liked'];
            }
            
            // decode comment text
            $comment['Text'] = DecodeText($comment['Text']);
            
            $post['comments'][] = $comment;
        }
    }
    $posts[] = $post;
}

// get first & last node
$firstNode = $posts[0]['ID'];
$lastNode = end($posts);
$lastNode = $lastNode['ID'];

// prepare sorting
switch ($_GET['sort']) {
    case "Most Recent":
        function sortArray($a, $b){
            if($a['Time'] == $b['Time']){
                return 0;
            }
            return ($a['Time'] < $b['Time']) ? 1 : -1;
        }
        usort($posts, sortArray);
        break;
    case "Most Liked":
        function sortArray($a, $b){
            if($a['Likes'] == $b['Likes']){
                return 0;
            }
            return ($a['Likes'] < $b['Likes']) ? 1 : -1;
        }
        usort($posts, sortArray);
        break;
    case "Most Favorited":
        function sortArray($a, $b){
            if($a['Favorits'] == $b['Favorits']){
                return 0;
            }
            return ($a['Favorits'] < $b['Favorits']) ? 1 : -1;
        }
        usort($posts, sortArray);
        break;
    case "Most Discussed":
        function sortArray($a, $b){
            if($a['Comments'] == $b['Comments']){
                return 0;
            }
            return ($a['Comments'] < $b['Comments']) ? 1 : -1;
        }
        usort($posts, sortArray);
        break;
    case "Most Answered":
        function sortArray($a, $b){
            if($a['Answers'] == $b['Answers']){
                return 0;
            }
            return ($a['Answers'] < $b['Answers']) ? 1 : -1;
        }
        usort($posts, sortArray);
        break;
}

// assign variables
$smarty->assign('app', $_GET['app']);
$smarty->assign('posts', $posts);
$smarty->assign('firstNode', $firstNode);
$smarty->assign('lastNode', $lastNode);

// display page templete
$smarty->display("$page.tpl");

?>