<?php
/**
 * filter post
 * 
 * @package Sngine
 * @author Zamblek
 */

// fetch kernal
$depth = '../../';
require($depth.'kernal.php');

// check AJAX Request
if(!IsAJAX()) {
    header('Location: '.SITE_URL);
}

// check user exist
if(!$userExist) {
    exit(PopupError('Please log in to continue.', 'Not Logged In'));
}

// check user verified
if($userArray['Verified'] == "N") {
    VerifyError();
}

// check page parameters
if(!isset($_POST['id']) || !isset($_POST['do'])) {
    exit(PopupError(ReportError('parameters error[1] @/ajax/posts/filter')));
}

// valid inputs
$valid['do'] = array('hidepost', 'unhidepost', 'hideuser', 'unhideuser', 'spam', 'unspam');
if(!in_array($_POST['do'], $valid['do'])) {
    exit(PopupError(ReportError('parameters error[2] @/ajax/posts/filter')));
}

// parse parameters
$id = ParseId($_POST['id'], 4);
if(!$id) {
    exit(PopupError(ReportError('parameters error[3] @/ajax/posts/filter')));
}
$activityId = $id[1];
$postType = $id[2];
$postId = $id[3];
$authorId = $id[4];

// check if valid post
$checkPost = $db->query(sprintf("SELECT * FROM posts WHERE PostType = %s AND PostID = %s AND UserID = %s", SafeSQL($postType, 'int'), SafeSQL($postId, 'int'), SafeSQL($authorId, 'int') )) or die(PopupError(ReportError('sql error #1 @/ajax/posts/filter')));
if($checkPost->num_rows == 0) {
    exit(PopupError('<div class="highlightContianer">This content is unavailable, It may be deleted by the author</div>'));
}

// hide post
if($_POST['do'] == "hidepost") {
    $db->query(sprintf("INSERT INTO users_hidden_posts (UserID, ActivityID) VALUES (%s, %s)", SafeSQL($userArray['UserID'], 'int'), SafeSQL($activityId, 'int') )) || exit;
// unhide post
}elseif ($_POST['do'] == "unhidepost") {
    $db->query(sprintf("DELETE FROM users_hidden_posts WHERE UserID = %s AND ActivityID = %s", SafeSQL($userArray['UserID'], 'int'), SafeSQL($activityId, 'int') )) || exit;
// hide user
}elseif ($_POST['do'] == "hideuser") {
    $db->query(sprintf("INSERT INTO users_hidden_users (UserID, HiddenID) VALUES (%s, %s)", SafeSQL($userArray['UserID'], 'int'), SafeSQL($authorId, 'int') )) || exit;
// unhide user
}elseif ($_POST['do'] == "unhideuser") {
    $db->query(sprintf("DELETE FROM users_hidden_users WHERE UserID = %s AND HiddenID = %s", SafeSQL($userArray['UserID'], 'int'), SafeSQL($authorId, 'int') )) || exit;
// spam
}elseif ($_POST['do'] == "spam") {
    $db->query(sprintf("INSERT INTO users_spammers (UserID, SpammerID) VALUES (%s, %s)", SafeSQL($userArray['UserID'], 'int'), SafeSQL($authorId, 'int') )) || exit;
// unspam
}elseif ($_POST['do'] == "unspam") {
    $db->query(sprintf("DELETE FROM users_spammers WHERE UserID = %s AND SpammerID = %s", SafeSQL($userArray['UserID'], 'int'), SafeSQL($authorId, 'int') )) || exit;
}

?>