<?php
/**
 * delete post
 * 
 * @package Sngine
 * @author Zamblek
 */

// fetch kernal
$depth = '../../';
require($depth.'kernal.php');

// check AJAX Request
if(!IsAJAX()) {
    header('Location: '.SITE_URL);
}

// check user exist
if(!$userExist) {
    exit(PopupError('Please log in to continue.', 'Not Logged In'));
}

// check user verified
if($userArray['Verified'] == "N") {
    VerifyError();
}

// check page parameters
if(!isset($_POST['id'])) {
    exit(PopupError(ReportError('parameters error[1] @/ajax/posts/delete')));
}

// parse parameters
$id = ParseId($_POST['id'], 4);
if(!$id) {
    exit(PopupError(ReportError('parameters error[2] @/ajax/posts/delete')));
}
$activityId = $id[1];
$postType = $id[2];
$postId = $id[3];
$authorId = $id[4];

// check if valid post
$checkPost = $db->query(sprintf("SELECT * FROM posts WHERE PostType = %s AND PostID = %s AND UserID = %s", Secure($postType, 'int'), Secure($postId, 'int'), Secure($authorId, 'int') )) or die(PopupError(ReportError('sql error #1 @/ajax/posts/delete')));
if($checkPost->num_rows == 0) {
    exit(PopupError('<div class="highlightContianer">This content is unavailable, It may be deleted by the author</div>'));
}

// check if authorized user
if($authorId != $userArray['UserID'] && $userArray['UserGroup'] == 3) {
    exit(PopupError('<div class="highlightContianer">This content is unavailable, It may be deleted by the author</div>'));
}

// get post
$post = $checkPost->fetch_array(MYSQLI_ASSOC);

// delete post comments & replies
if($post['Comments'] > 0) {
    $db->query(sprintf("DELETE FROM posts_comments WHERE PostType = %s AND PostID = %s", Secure($postType, 'int'), Secure($postId, 'int') )) or die(PopupError(ReportError('sql error #2 @/ajax/posts/delete')));
}

// delete post likes & dislikes
if($post['Likes'] > 0 || $post['Dislikes'] > 0) {
    $db->query(sprintf("DELETE FROM users_posts_likes WHERE PostType = %s AND PostID = %s", Secure($postType, 'int'), Secure($postId, 'int') )) or die(PopupError(ReportError('sql error #3 @/ajax/posts/delete')));
}

// delete post favorits
if($post['Favorits'] > 0) {
    $db->query(sprintf("DELETE FROM users_posts_favorites WHERE PostType = %s AND PostID = %s", Secure($postType, 'int'), Secure($postId, 'int') )) or die(PopupError(ReportError('sql error #4 @/ajax/posts/delete')));
}

// delete post notifications
$db->query(sprintf("DELETE FROM notifications WHERE PostType = %s AND PostID = %s AND AuthorID = %s AND Type = 'P' AND IsMedia = 'N'", Secure($postType, 'int'), Secure($postId, 'int'), Secure($authorId, 'int') )) or die(PopupError(ReportError('sql error #5 @/ajax/posts/delete')));

// delete app post
switch($postType) {
    
    // news app
    case 1:
        $db->query(sprintf("DELETE FROM posts_news WHERE ID = %s", Secure($postId, 'int') )) or die(PopupError(ReportError('sql error #6 @/ajax/posts/delete')));
        break;
    // photos app
    case 3:
        $getMedia = $db->query(sprintf("SELECT * FROM posts_photos WHERE ID = %s", Secure($postId, 'int'))) or die(PopupError(ReportError('sql error #7 @/ajax/posts/delete')));
        $media = $getMedia->fetch_array(MYSQLI_ASSOC);
        if($media['IsAlbum'] == 'Y') {
            // delets sources
            $db->query(sprintf("DELETE FROM posts_photos_sources WHERE AlbumID = %s", Secure($media['MediaID'], 'int') )) or die(PopupError(ReportError('sql error #8 @/ajax/posts/delete')));
            // delete album
            $db->query(sprintf("DELETE FROM posts_photos_albums WHERE ID = %s", Secure($media['MediaID'], 'int') )) or die(PopupError(ReportError('sql error #9 @/ajax/posts/delete')));
            // delete photo post
            $db->query(sprintf("DELETE FROM posts_photos WHERE ID = %s", Secure($postId, 'int') )) or die('sql error #10 @/ajax/posts/delete');
        }else {
            // get wall album
            $getSource = $db->query(sprintf("SELECT * FROM posts_photos_sources WHERE ID = %s", Secure($media['MediaID'], 'int') )) or die(PopupError(ReportError('sql error #11 @/ajax/posts/delete')));
            $source = $getSource->fetch_array(MYSQLI_ASSOC);
            // delets source
            $db->query(sprintf("DELETE FROM posts_photos_sources WHERE ID = %s", Secure($media['MediaID'], 'int') )) or die(PopupError(ReportError('sql error #12 @/ajax/posts/delete')));
            // update album
            $db->query(sprintf("UPDATE posts_photos_albums SET Total = IF(Total=0,0,Total-1), ThumbnailID = IF(ThumbnailID=%s,0,ThumbnailID) WHERE ID = %s", Secure($media['MediaID'], 'int'), Secure($source['AlbumID'], 'int') )) or die(PopupError(ReportError('sql error #13 @/ajax/posts/delete')));
            // delete photo post
            $db->query(sprintf("DELETE FROM posts_photos WHERE ID = %s", Secure($postId, 'int') )) or die(PopupError(ReportError('sql error #14 @/ajax/posts/delete')));
        }
        break;
    // videos app
    case 4:
        $getMedia = $db->query(sprintf("SELECT * FROM posts_videos WHERE ID = %s", Secure($postId, 'int'))) or die(PopupError(ReportError('sql error #15 @/ajax/posts/delete')));
        $media = $getMedia->fetch_array(MYSQLI_ASSOC);
        if($media['IsAlbum'] == 'Y') {
            // delets sources
            $db->query(sprintf("DELETE FROM posts_videos_sources WHERE AlbumID = %s", Secure($media['MediaID'], 'int') )) or die(PopupError(ReportError('sql error #16 @/ajax/posts/delete')));
            // delete album
            $db->query(sprintf("DELETE FROM posts_videos_albums WHERE ID = %s", Secure($media['MediaID'], 'int') )) or die(PopupError(ReportError('sql error #17 @/ajax/posts/delete')));
            // delete video post
            $db->query(sprintf("DELETE FROM posts_videos WHERE ID = %s", Secure($postId, 'int') )) or die(PopupError(ReportError('sql error #18 @/ajax/posts/delete')));
        }else {
            // get wall album
            $getSource = $db->query(sprintf("SELECT * FROM posts_videos_sources WHERE ID = %s", Secure($media['MediaID'], 'int') )) or die(PopupError(ReportError('sql error #19 @/ajax/posts/delete')));
            $source = $getSource->fetch_array(MYSQLI_ASSOC);
            // delets source
            $db->query(sprintf("DELETE FROM posts_videos_sources WHERE ID = %s", Secure($media['MediaID'], 'int') )) or die(PopupError(ReportError('sql error #20 @/ajax/posts/delete')));
            // update album
            $db->query(sprintf("UPDATE posts_videos_albums SET Total = IF(Total=0,0,Total-1), ThumbnailID = IF(ThumbnailID=%s,0,ThumbnailID) WHERE ID = %s", Secure($media['MediaID'], 'int'), Secure($source['AlbumID'], 'int') )) or die(PopupError(ReportError('sql error #21 @/ajax/posts/delete')));
            // delete video post
            $db->query(sprintf("DELETE FROM posts_videos WHERE ID = %s", Secure($postId, 'int') )) or die(PopupError(ReportError('sql error #22 @/ajax/posts/delete')));
        }
        break;
    // discussions app
    case 5:
        $db->query(sprintf("DELETE FROM posts_discussions WHERE ID = %s", Secure($postId, 'int') )) or die(PopupError(ReportError('sql error #23 @/ajax/posts/delete')));
        break;
    // questions app
    case 6:
        // delete question
        $db->query(sprintf("DELETE FROM posts_questions WHERE ID = %s", Secure($postId, 'int') )) or die(PopupError(ReportError('sql error #24 @/ajax/posts/delete')));
        // delete answers
        $db->query(sprintf("DELETE FROM posts_questions_answers WHERE QuestionID = %s", Secure($postId, 'int') )) or die(PopupError(ReportError('sql error #25 @/ajax/posts/delete')));
        break;
    // polls app
    case 7:
        // delete poll
        $db->query(sprintf("DELETE FROM posts_polls WHERE ID = %s", Secure($postId, 'int') )) or die(PopupError(ReportError('sql error #26 @/ajax/posts/delete')));
        // delete options
        $db->query(sprintf("DELETE FROM posts_polls_options WHERE PollID = %s", Secure($postId, 'int') )) or die(PopupError(ReportError('sql error #27 @/ajax/posts/delete')));
        break;
    // links app
    case 8:
        $db->query(sprintf("DELETE FROM posts_links WHERE ID = %s", Secure($postId, 'int') )) or die(PopupError(ReportError('sql error #28 @/ajax/posts/delete')));
        break;
}

// delete post
$db->query(sprintf("DELETE FROM posts WHERE PostType = %s AND PostID = %s AND UserID = %s", Secure($postType, 'int'), Secure($postId, 'int'), Secure($authorId, 'int') )) or die(PopupError(ReportError('sql error #29 @/ajax/posts/delete')));

// update user posts
$db->query(sprintf("UPDATE users SET UserPosts = IF(UserPosts=0,0,UserPosts-1) WHERE UserID = %s", Secure($authorId, 'int') )) or die(PopupError(ReportError('sql error #30 @/ajax/posts/delete')));

?>