<?php
/**
 * who vote option
 * 
 * @package Sngine
 * @author Zamblek
 */

// fetch kernal
$depth = '../../';
require($depth.'kernal.php');

// check AJAX Request
if(!IsAJAX()) {
    header('Location: '.SITE_URL);
}

// check user exist
if(!$userExist) {
    exit('<div class="popupHeader"><div class="button-close popup right" onclick="$.popups._hide();"></div>Not Logged In</div><div class="popupContent"><div class="pt5 pb5 pr5 pl5 fs12 white">Please log in to continue.</div></div>');
}

// check user verified
if($userArray['Verified'] == "N") {
    exit('<div class="popupHeader"><div class="button-close popup right" onclick="$.popups._hide();"></div>Confirm Your Email Address</div><div class="popupContent"><div class="pt5 pb5 pr5 pl5"><p class="fs11 mb10 tjustify">Before you can interact with other users, you need to confirm your email address. A confirmation email has been sent to <span class="blue fwb">'.$userArray['UserEmail'].'</span>. Check your email to complete your account confirmation.</p><p><small>Don\'t see the confirmation email? <span class="uiButtonText blue resendEmail">Resend to '.$userArray['UserEmail'].'</span></small><br/><small>Don\'t have access to '.$userArray['UserEmail'].'? <span class="uiButtonText blue changeEmail">Change your contact email.</span></small></p></div></div>');
}

// check page parameters
if(!isset($_POST['id'])) {
    exit('<div class="popupHeader"><div class="button-close popup right" onclick="$.popups._hide();"></div>Error</div><div class="popupContent">'.ReportError('parameters error[1] @/ajax/polls/who'.'</div>'));
}

// parse parameters
$id = ParseId($_POST['id']);
if(!$id) {
    exit('<div class="popupHeader"><div class="button-close popup right" onclick="$.popups._hide();"></div>Error</div><div class="popupContent">'.ReportError('parameters error[3] @/ajax/posts/who'.'</div>'));
}
$pollId = $id[1];
$optionId = $id[2];

// check if valid option
$checkOption = $db->query(sprintf("SELECT * FROM posts_polls_options WHERE ID = %s AND PollID = %s", SafeSQL($optionId, 'int'), SafeSQL($pollId, 'int') )) or die('<div class="popupHeader"><div class="button-close popup right" onclick="$.popups._hide();"></div>Error</div><div class="popupContent">'.ReportError('sql error #1 @/ajax/polls/who'.'</div>'));
if($checkOption->num_rows == 0) {
    exit('<div class="highlightContianer">This content is unavailable, It may be deleted by the author</div>');
}

$getUsers = $db->query(sprintf("SELECT user.UserID, user.UserName, user.UserFirstName, user.UserLastName, user.UserAvatarPathMedium AS UserAvatarPath FROM users_polls_options poll INNER JOIN users user ON poll.UserID = user.UserID WHERE poll.PollID = %s AND poll.OptionID = %s LIMIT 0,".$systemSetting['MaxWho'], SafeSQL($pollId, 'int'), SafeSQL($optionId, 'int') )) or die('<div class="popupHeader"><div class="button-close popup right" onclick="$.popups._hide();"></div>Error</div><div class="popupContent">'.ReportError('sql error #2 @/ajax/polls/who'.'</div>'));
if($getUsers->num_rows == 0) {
    exit('<div class="popupHeader"><div class="button-close popup right" onclick="$.popups._hide();"></div>Error</div><div class="popupContent"><div class="errorContianer">There is no one '.$_POST['view'].'s this post right now.</div></div>');
}
while($userWho = $getUsers->fetch_array(MYSQLI_ASSOC)) {
    // check if post writer in user followings
    $userWho['FollowingHim'] = (in_array($userWho['UserID'], $userFollowings))? true: false;
    $usersWho[] = $userWho;
}

// assign variables
$smarty->assign('usersWho', $usersWho);
$smarty->assign('usersWhoNums', count($usersWho));
$smarty->assign('view', 'select');

// page footer
PageFooter("popup.who");

?>