<?php
/**
 * select|unselect poll option
 * 
 * @package Sngine
 * @author Zamblek
 */

// fetch kernal
$depth = '../../';
require($depth.'kernal.php');

// check AJAX Request
if(!IsAJAX()) {
    header('Location: '.SITE_URL);
}

// check user exist
if(!$userExist) {
    exit(PopupError('Please log in to continue.', 'Not Logged In'));
}

// check user verified
if($userArray['Verified'] == "N") {
    VerifyError();
}

// check page parameters
if(!isset($_POST['id']) || !isset($_POST['option']) ||!isset($_POST['do'])) {
    exit(PopupError(ReportError('parameters error[1] @/ajax/polls/select')));
}

// valid inputs
$valid['do'] = array('select', 'unselect');
if(!in_array($_POST['do'], $valid['do'])) {
    exit(PopupError(ReportError('parameters error[2] @/ajax/polls/select')));
}

// parse parameters
$id = ParseId($_POST['id'], 4);
if(!$id) {
    exit(PopupError(ReportError('parameters error[3] @/ajax/polls/select')));
}
$activityId = $id[1];
$postType = $id[2];
$postId = $id[3];
$authorId = $id[4];

if(!preg_match('/^([0-9]+)$/', $_POST['option'])) {
    exit(PopupError(ReportError('parameters error[4] @/ajax/polls/select')));
}

// check if valid post
$checkPost = $db->query(sprintf("SELECT * FROM posts WHERE PostType = %s AND PostID = %s AND UserID = %s", SafeSQL($postType, 'int'), SafeSQL($postId, 'int'), SafeSQL($authorId, 'int') )) or die(PopupError(ReportError('sql error #1 @/ajax/polls/select')));
if($checkPost->num_rows == 0) {
    exit(PopupError('<div class="highlightContianer">This content is unavailable, It may be deleted by the author</div>'));
}

// check if valid option
$checkOption = $db->query(sprintf("SELECT * FROM posts_polls_options WHERE ID = %s AND PollID = %s", SafeSQL($_POST['option'], 'int'), SafeSQL($postId, 'int') )) or die(PopupError(ReportError('sql error #2 @/ajax/polls/select')));
if($checkOption->num_rows == 0) {
    exit(PopupError('<div class="highlightContianer">This content is unavailable, It may be deleted by the author</div>'));
}

// select option
if($_POST['do'] == "select") {
    // check selection
    $getSelection = $db->query(sprintf("SELECT OptionID FROM users_polls_options WHERE UserID = %s AND PollID = %s", SafeSQL($userArray['UserID'], 'int'), SafeSQL($postId, 'int') )) or die(PopupError(ReportError('sql error #3 @/ajax/polls/select')));
    if($getSelection->num_rows == 0) {
        // insert selection
        $db->query(sprintf("INSERT INTO users_polls_options (UserID, PollID, OptionID) VALUES (%s, %s, %s)", SafeSQL($userArray['UserID'], 'int'), SafeSQL($postId, 'int'), SafeSQL($_POST['option'], 'int') )) or die(PopupError(ReportError('sql error #4 @/ajax/polls/select')));
        // update option
        $db->query(sprintf("UPDATE posts_polls_options SET Votes = Votes + 1 WHERE ID = %s", SafeSQL($_POST['option'], 'int') )) or die(PopupError(ReportError('sql error #5 @/ajax/polls/select')));
        // update poll
        $db->query(sprintf("UPDATE posts_polls SET Votes = Votes + 1 WHERE ID = %s", SafeSQL($postId, 'int') )) or die(PopupError(ReportError('sql error #6 @/ajax/polls/select')));
        // insert notification
        if($userArray['UserID'] != $authorId) {
            $db->query(sprintf("INSERT INTO notifications (UserID, Action, AuthorID, PostType, PostID, Time) VALUES (%s, 8, %s, %s, %s, %s)", SafeSQL($userArray['UserID'], 'int'), SafeSQL($authorId, 'int'), SafeSQL($postType, 'int'), SafeSQL($postId, 'int'), SafeSQL($now) )) or die(PopupError(ReportError('sql error #7 @/ajax/polls/select')));
            $db->query(sprintf("UPDATE users SET UserNotifications = UserNotifications + 1, UserNewNotifications = UserNewNotifications + 1 WHERE UserID = %s", SafeSQL($authorId, 'int'))) or die(PopupError(ReportError('sql error #8 @/ajax/polls/select')));
        }
    }else {
        // get old option
        $oldOption = $getSelection->fetch_array(MYSQLI_ASSOC);
        if($oldOption['OptionID'] == $_POST['option']) {
            exit;
        }
        // update selection
        $db->query(sprintf("UPDATE users_polls_options SET OptionID = %s WHERE UserID = %s AND PollID = %s", SafeSQL($_POST['option'], 'int'), SafeSQL($userArray['UserID'], 'int'), SafeSQL($postId, 'int') )) or die(PopupError(ReportError('sql error #9 @/ajax/polls/select')));
        // update option
        $db->query(sprintf("UPDATE posts_polls_options SET Votes = Votes + 1 WHERE ID = %s", SafeSQL($_POST['option'], 'int') )) or die(PopupError(ReportError('sql error #10 @/ajax/polls/select')));
        $db->query(sprintf("UPDATE posts_polls_options SET Votes = IF(Votes=0,0,Votes-1) WHERE ID = %s", SafeSQL($oldOption['OptionID'], 'int'))) or die(PopupError(ReportError('sql error #11 @/ajax/polls/select')));
    }
// unselect option
}elseif ($_POST['do'] == "unselect") {
    // delete selection
    $db->query(sprintf("DELETE FROM users_polls_options WHERE UserID = %s AND PollID = %s AND OptionID = %s", SafeSQL($userArray['UserID'], 'int'), SafeSQL($postId, 'int'), SafeSQL($_POST['option'], 'int') )) || exit;
    // check affected rows
    if($db->affected_rows > 0) {
        // update option
        $db->query(sprintf("UPDATE posts_polls_options SET Votes = IF(Votes=0,0,Votes-1) WHERE ID = %s", SafeSQL($_POST['option'], 'int'))) or die(PopupError(ReportError('sql error #12 @/ajax/polls/select')));
        // update poll
        $db->query(sprintf("UPDATE posts_polls SET Votes = IF(Votes=0,0,Votes-1) WHERE ID = %s", SafeSQL($postId, 'int') )) or die(PopupError(ReportError('sql error #13 @/ajax/polls/select')));
        // delete notification
        if($userArray['UserID'] != $authorId) {
            $db->query(sprintf("DELETE FROM notifications WHERE UserID = %s AND Action = 8 AND PostType = %s AND PostID = %s", SafeSQL($userArray['UserID'], 'int'), SafeSQL($postType, 'int'), SafeSQL($postId, 'int') )) or die(PopupError(ReportError('sql error #14 @/ajax/polls/select')));
            $db->query(sprintf("UPDATE users SET UserNotifications = IF(UserNotifications=0,0,UserNotifications-1), UserNewNotifications = IF(UserNewNotifications=0,0,UserNewNotifications-1) WHERE UserID = %s", SafeSQL($authorId, 'int'))) or die(PopupError(ReportError('sql error #15 @/ajax/polls/select')));
        }
    }
}

?>