<?php
/**
 * start new conversation
 * 
 * @package Sngine
 * @author Zamblek
 */

// fetch kernal
$depth = '../../';
require($depth.'kernal.php');

// check AJAX Request
if(!IsAJAX()) {
    header('Location: '.SITE_URL);
}

// check user exist
if(!$userExist) {
    exit(PopupError('Please log in to continue.', 'Not Logged In'));
}

// check user verified
if($userArray['Verified'] == "N") {
    VerifyError();
}

// check page parameters
if(!isset($_POST['recipients']) || !isset($_POST['message'])) {
    exit(PopupError(ReportError('parameters error[1] @/ajax/messages/send')));
}

// parse parameters
preg_match_all('/[0-9]+/', $_POST['recipients'], $matches);
$recipients = $matches[0];

// check recipients
if(count($matches[0]) == 0) {
    exit(PopupError(ReportError('parameters error[2] @/ajax/messages/send')));
}
foreach($matches[0] as $recipient) {
    if($recipient == $userArray['UserID']) continue;
    if(in_array($recipient, $recipientsArray)) continue;
    $getRecipient = $db->query(sprintf("SELECT * FROM users WHERE UserID = %s", Secure($recipient, 'int') )) or die(PopupError(ReportError('sql error #1 @/ajax/messages/send')));
    if($getRecipient->num_rows >= 1) {
        $recipientsArray[] = $recipient;
    }
}
if(count($recipientsArray) == 0) {
    exit(PopupError(ReportError('parameters error[3] @/ajax/messages/send')));
}

// check if empty
if(IsEmpty($_POST['message'])) {
    exit(PopupError('Please enter a valid (non-empty) message.'));
}

// insert new conversation
$db->query(sprintf("INSERT INTO messages_conversations (Recipients, LastMessage, LastSenderID, LastUpdate) VALUES (%s, %s, %s, %s)", SafeSQL(count($recipientsArray), 'int'), Secure($_POST['message']), SafeSQL($userArray['UserID'], 'int'), $now )) or die(PopupError(ReportError('sql error #2 @/ajax/messages/send')));
$conversationId = $db->insert_id;

// insert message
$db->query(sprintf("INSERT INTO messages (UserID, Text, ConversationID, Time) VALUES (%s, %s, %s, %s)", SafeSQL($userArray['UserID'], 'int'), Secure($_POST['message']), SafeSQL($conversationId, 'int'), $now )) or die(PopupError(ReportError('sql error #3 @/ajax/messages/send')));
$messageId = $db->insert_id;

// insert conversation recipients & insert message recipients & update recipients messages counters
foreach($recipientsArray as $recipient) {
    $db->query(sprintf("INSERT INTO messages_conversations_users (ConversationID, UserID) VALUES (%s, %s)", SafeSQL($conversationId, 'int'), Secure($recipient, 'int') )) or die(PopupError(ReportError('sql error #4 @/ajax/messages/send')));
    $db->query(sprintf("INSERT INTO messages_users (MessageID, UserID) VALUES (%s, %s)", SafeSQL($messageId, 'int'), Secure($recipient, 'int') )) or die(PopupError(ReportError('sql error #5 @/ajax/messages/send')));
    $db->query(sprintf("UPDATE users SET UserMessages = UserMessages + 1, UserNewMessages = UserNewMessages + 1, UserMessaged = 'Y' WHERE UserID = %s", Secure($recipient, 'int'))) or die(PopupError(ReportError('sql error #6 @/ajax/messages/send')));
}

// update sender
$db->query(sprintf("INSERT INTO messages_conversations_users (ConversationID, UserID, Viewed) VALUES (%s, %s, 'Y')", SafeSQL($conversationId, 'int'), SafeSQL($userArray['UserID'], 'int') )) or die(PopupError(ReportError('sql error #7 @/ajax/messages/send')));
$db->query(sprintf("INSERT INTO messages_users (MessageID, UserID) VALUES (%s, %s)", SafeSQL($messageId, 'int'), SafeSQL($userArray['UserID'], 'int') )) or die(PopupError(ReportError('sql error #8 @/ajax/messages/send')));
$db->query(sprintf("UPDATE users SET UserMessages = UserMessages + 1, UserMessaged = 'Y' WHERE UserID = %s", SafeSQL($userArray['UserID'], 'int'))) or die(PopupError(ReportError('sql error #9 @/ajax/messages/send')));

// return data
$data['status'] = 'success';
$data['value'] = $conversationId;
exit(json_encode($data));

?>