<?php
/**
 * get recipients
 * 
 * @package Sngine
 * @author Zamblek
 */

// fetch kernal
$depth = '../../';
require($depth.'kernal.php');

// check AJAX Request
if(!IsAJAX()) {
    header('Location: '.SITE_URL);
}

// check user exist & verified
if(!$userExist || $userArray['Verified'] == "N") {
    exit('<p class="pt5 pb5 pr5 pl5">No Results</p>');
}

// check page parameters
if(!isset($_POST['q']) || IsEmpty($_POST['q'])) {
    exit('<p class="pt5 pb5 pr5 pl5">No Results</p>');
}

// get recipients
$getRecipients = $db->query(sprintf("SELECT UserID, UserFirstName, UserLastName, UserAvatarPathSmall AS UserAvatarPath FROM users WHERE (UserFirstName LIKE %s OR UserLastName LIKE %s) AND UserID != %s LIMIT 5", Secure($_POST['q'], 'search'), Secure($_POST['q'], 'search'), SafeSQL($userArray['UserID'], 'int') )) or die('<p class="pt5 pb5 pr5 pl5">No Results</p>');
if($getRecipients->num_rows == 0) {
    exit('<p class="pt5 pb5 pr5 pl5">No Results</p>');
}
while($recipient = $getRecipients->fetch_array(MYSQLI_ASSOC)) {
    $recipients[] = $recipient;
}

// assign variables
$smarty->assign('recipients', $recipients);

// page footer
PageFooter("ajax.messages.recipients");

?>