<?php
/**
 * get messages
 * 
 * @package Sngine
 * @author Zamblek
 */

// fetch kernal
$depth = '../../';
require($depth.'kernal.php');

// check AJAX Request
if(!IsAJAX()) {
    header('Location: '.SITE_URL);
}

// check user exist
if(!$userExist) {
    exit();
}

// check user verified
if($userArray['Verified'] == "N") {
    exit();
}

// check page parameters
if(!isset($_GET['get']) || !isset($_GET['page']) || !isset($_GET['counter'])) {
    exit(ReportError('parameters error[1] @/ajax/messages/get'));
}

// valid inputs
$valid['get'] = array('all', 'new');
if(!in_array($_GET['get'], $valid['get'])) {
    exit(ReportError('parameters error[2] @/ajax/messages/get'));
}

// parse parameters
if(!preg_match('/^([0-9]+)$/', $_GET['page'])) {
    exit(ReportError('parameters error[3] @/ajax/messages/get'));
}
if(!preg_match('/^([0-9]+)$/', $_GET['counter'])) {
    exit(ReportError('parameters error[4] @/ajax/messages/get'));
}

// get conversations
if($userArray['UserMessages'] > 0) {
    // check if user has new messages
    if($_GET['get'] == "new" && $userArray['UserNewMessages'] <= $_GET['counter']) {
        exit;
    }
    // prepare pagination
    if(isset($_GET['page'])) {
        $spage = (int) $_GET['page'];
        $spage = ($spage == 0) ? 1 : $spage;
    }else {
        $spage = 1;
    }
    require_once '../../libs/class-pagination.php';
    $pagination = new Pagination($spage, $systemSetting['MaxConversations'], $userArray['UserMessages'], 'messages.php?page=%s');
    $getConversations = $db->query(sprintf("SELECT * FROM messages_conversations_users user INNER JOIN messages_conversations conv ON user.ConversationID = conv.ID WHERE user.UserID = %s AND user.Deleted = 'N' ORDER BY conv.LastUpdate DESC ".$pagination->getLimitSql(), SafeSQL($userArray['UserID'], 'int') )) or die(ReportError('sql error #1 @/ajax/messages/get'));
    if($getConversations->num_rows > 0) {
        $hasRows = true;
        while($conversation = $getConversations->fetch_array(MYSQLI_ASSOC)) {
            // get conversation recipients
            if($conversation['Recipients'] <= 3) {
                $getRecipients = $db->query(sprintf("SELECT user.UserID, user.UserFirstName, user.UserLastName, user.UserAvatarPathMedium AS UserAvatarPath FROM messages_conversations_users conv INNER JOIN users user ON conv.UserID = user.UserID WHERE conv.ConversationID = %s AND conv.UserID != %s LIMIT 3", SafeSQL($conversation['ConversationID'], 'int'), SafeSQL($userArray['UserID'], 'int') )) or die(ReportError('sql error #2 @/ajax/messages/get'));
                while($recipient = $getRecipients->fetch_array(MYSQLI_ASSOC)) {
                    $conversation['users'][] = $recipient;
                }
                $conversation['hasOthers'] = false;
            }else {
                $getRecipients = $db->query(sprintf("SELECT user.UserID, user.UserFirstName, user.UserLastName, user.UserAvatarPathMedium AS UserAvatarPath FROM messages_conversations_users conv INNER JOIN users user ON conv.UserID = user.UserID WHERE conv.ConversationID = %s AND conv.UserID != %s LIMIT 2", SafeSQL($conversation['ConversationID'], 'int'), SafeSQL($userArray['UserID'], 'int') )) or die(ReportError('sql error #3 @/ajax/messages/get'));
                while($recipient = $getRecipients->fetch_array(MYSQLI_ASSOC)) {
                    $conversation['users'][] = $recipient;
                }
                $conversation['others'] = $conversation['Recipients'] - 2;
                $conversation['hasOthers'] = true;
            }
            // prepare conversation avatar
            if($conversation['Recipients'] > 1) {
                $conversation['MixedAvatar'] = true;
                $conversation['LeftAvatarPath'] = $conversation['users'][0]['UserAvatarPath'];
                $conversation['RightAvatarPath'] = $conversation['users'][1]['UserAvatarPath'];
            }else {
                $conversation['MixedAvatar'] = false;
                $conversation['AvatarPath'] = $conversation['users'][0]['UserAvatarPath'];
            }
            $conversations[] = $conversation;
        }
        $smarty->assign('pager', $pagination->getPagerMini());
        $smarty->assign('conversations', $conversations);
    }else {
        $hasRows = false;
    }
    $smarty->assign('hasRows', $hasRows);
}

// page footer
PageFooter("ajax.messages.get");

?>