<?php
/**
 * delete message|conversations
 * 
 * @package Sngine
 * @author Yehia Abed
 * @version 0.3
 */

// fetch kernal
$depth = '../../';
require($depth.'kernal.php');

// check AJAX Request
if(!IsAJAX()) {
    header('Location: '.SITE_URL);
}

// check user exist
if(!$userExist) {
    exit(PopupError('Please log in to continue.', 'Not Logged In'));
}

// check user verified
if($userArray['Verified'] == "N") {
    VerifyError();
}

// check page parameters
if(!isset($_POST['id']) || !isset($_POST['type'])) {
    exit(PopupError(ReportError('parameters error[1] @/ajax/messages/delete')));
}

// valid inputs
$valid['type'] = array('message', 'conversation');
if(!in_array($_POST['type'], $valid['type'])) {
    exit(PopupError(ReportError('parameters error[2] @/ajax/messages/delete')));
}

// parse parameters
$id = ParseId($_POST['id']);
if(!$id) {
    exit(PopupError(ReportError('parameters error[3] @/ajax/messages/delete')));
}
$conversationId = $id[1];
$messageId = $id[2];

// check if user authorized
$checkAuth = $db->query(sprintf("SELECT * FROM messages_conversations_users WHERE ConversationID = %s AND UserID = %s", Secure($conversationId, 'int'), Secure($userArray['UserID'], 'int') )) or die(PopupError(ReportError('sql error #1 @/ajax/messages/delete')));
if($checkAuth->num_rows == 0) {
    exit(PopupError(ReportError('authorization error @/ajax/messages/delete')));
}

// delete message
if($_POST['type'] == 'message') {
    $db->query(sprintf("UPDATE messages_users SET Deleted = 'Y' WHERE MessageID = %s AND UserID = %s", Secure($messageId, 'int'), Secure($userArray['UserID'], 'int'))) or die(PopupError(ReportError('sql error #2 @/ajax/messages/delete')));
    if($db->affected_rows > 0) {
        $db->query(sprintf("UPDATE messages_conversations_users SET Deleted = IF(Messages=1,'Y','N'), Messages = IF(Messages=0,0,Messages-1) WHERE ConversationID = %s AND UserID = %s", Secure($conversationId, 'int'), Secure($userArray['UserID'], 'int'))) or die(PopupError(ReportError('sql error #3 @/ajax/messages/delete')));
    }
// delete conversation
}else {
    $db->query(sprintf("UPDATE messages_conversations_users SET Deleted = 'Y' WHERE ConversationID = %s AND UserID = %s", Secure($conversationId, 'int'), Secure($userArray['UserID'], 'int'))) or die(PopupError(ReportError('sql error #4 @/ajax/messages/delete')));
}

?>