<?php
/**
 * chat cron job
 * 
 * @package Sngine
 * @author Zamblek
 */

// fetch kernal
$depth = '../../../';
require($depth.'kernal.php');

// check AJAX Request
if(!(isset($_SERVER['HTTP_X_REQUESTED_WITH']) && ($_SERVER['HTTP_X_REQUESTED_WITH'] == 'XMLHttpRequest'))) {
    header('Location: '.SITE_URL);
}

// check new messages
$getConversations = $db->query(sprintf("SELECT * FROM messages_conversations_users user INNER JOIN messages_conversations conv ON user.ConversationID = conv.ID WHERE conv.IsChat = 'Y' AND user.UserID = %s AND user.Viewed = 'N' AND user.Deleted = 'N' ORDER BY conv.LastUpdate DESC", SafeSQL($userArray['UserID'], 'int') )) or die(ReportError('sql error #1 @/ajax/messages/chat/cron'));
if($getConversations->num_rows == 0) {
    exit;
}
while($conversation = $getConversations->fetch_array(MYSQLI_ASSOC)) {
    // update conversation
    $db->query(sprintf("UPDATE messages_conversations_users SET Viewed = 'Y' WHERE ConversationID = %s AND UserID = %s", SafeSQL($conversation['ConversationID'], 'int'), SafeSQL($userArray['UserID'], 'int'))) or die(ReportError('sql error #2 @/ajax/messages/chat/cron'));
    // get sender
    $getSender = $db->query(sprintf("SELECT user.UserID, user.UserFirstName, user.UserLastName FROM messages_conversations_users conv INNER JOIN users user ON conv.UserID = user.UserID WHERE conv.ConversationID = %s AND conv.UserID != %s", SafeSQL($conversation['ConversationID'], 'int'), SafeSQL($userArray['UserID'], 'int') )) or die(ReportError('sql error #2 @/ajax/messages/chat/cron'));
    $sender = $getSender->fetch_array(MYSQLI_ASSOC);
    $conversation['sender'] = $sender['UserID'];
    $conversation['title'] = $sender['UserFirstName']." ".$sender['UserLastName'];
    // get messages
    $getMessages = $db->query(sprintf("SELECT msg.*, user.UserName, user.UserAvatarPathSmall FROM messages msg INNER JOIN users user ON msg.UserID = user.UserID WHERE msg.ConversationID = %s ORDER BY msg.Time ASC", SafeSQL($conversation['ConversationID'], 'int'))) or die(ReportError('sql error #3 @/ajax/messages/chat/cron'));
    while($message = $getMessages->fetch_array(MYSQLI_ASSOC)) {
        // decode text
        $message['Text'] = DecodeText($message['Text']);
        $messages[] = $message;
    }
    $smarty->assign('messages', $messages);
    $conversation['messages'] = $smarty->fetch("ajax.chat.messages.tpl");
    $conversations[] = $conversation;
    // update session
    if(!isset($_SESSION['openChatBoxes'][$conversation['sender']])) {
        $_SESSION['openChatBoxes'][$conversation['sender']] = $conversation['ConversationID'];
    }
}

exit(json_encode($conversations));

?>