<?php
/**
 * get media comments
 * 
 * @package Sngine
 * @author Zamblek
 */

// fetch kernal
$depth = '../../../';
require($depth.'kernal.php');

// check AJAX Request
if(!IsAJAX()) {
    header('Location: '.SITE_URL);
}

// check page parameters
if(!isset($_GET['id']) || !isset($_GET['get'])) {
    exit(ReportError('parameters error[1] @/ajax/media/comments/get'));
}

// valid inputs
$valid['get'] = array('comments', 'replies');
if(!in_array($_GET['get'], $valid['get'])) {
    exit(ReportError('parameters error[2] @/ajax/media/comments/get'));
}

// parse parameters
$id = ParseId($_GET['id'], 5);
if(!$id) {
    exit(ReportError('parameters error[3] @/ajax/media/comments/get'));
}

if($_GET['get'] == 'comments') {
    
    // parse parameters
    $mediaId = $id[1];
    $postType = $id[2];
    $isAlbum = $id[3];
    $authorId = $id[4];
    $prevComments = $id[5];
    
    // get media table
    $mediaTable = GetMediaTable($postType, $isAlbum);
    if(!$mediaTable) {
        exit(PopupError(ReportError('parameters error[4] @/ajax/media/comments/get')));
    }
    $isAlbum = ($isAlbum == 1)? 'Y' : 'N';
    
    // check if valid post
    $checkPost = $db->query(sprintf("SELECT * FROM %s WHERE ID = %s", $mediaTable, SafeSQL($mediaId, 'int') )) or die(PopupError(ReportError('sql error #1 @/ajax/media/comments/get')));
    if($checkPost->num_rows == 0) {
        exit(PopupError(PopupError('<div class="highlightContianer">This content is unavailable, It may be deleted by the author</div>')));
    }
    
    // get comments
    if($prevComments > $systemSetting['MaxComments']) {
        $records = $systemSetting['MaxComments'];
        $prevComments -= $systemSetting['MaxComments'];
    }else {
        $records = $prevComments;
        $prevComments = 0;
    }
    $getComments = $db->query(sprintf("SELECT comm.*, user.UserName, user.UserFirstName, user.UserLastName, user.UserAvatarPathMedium AS UserAvatarPath FROM posts_comments_media comm INNER JOIN users user ON comm.UserID = user.UserID WHERE comm.PostType = %s AND IsAlbum = %s AND comm.MediaID = %s AND comm.ParentNodeID = 0 ORDER BY comm.Time ASC LIMIT %s,%s", SafeSQL($postType, 'int'), SafeSQL($isAlbum), SafeSQL($mediaId, 'int'), $prevComments, $records )) or die(ReportError('sql error #2 @/ajax/media/comments/get'));
    while($comment = $getComments->fetch_array(MYSQLI_ASSOC)) {
        
        // get Replies
        if($comment['Replies'] > 0) {
            if($comment['Replies'] > $systemSetting['MaxReplies']) {
                $records = $systemSetting['MaxReplies'];
                $comment['prevReplies'] = $comment['Replies'] - $systemSetting['MaxReplies'];
            }else {
                $records = $comment['Replies'];
                $comment['prevReplies'] = 0;
            }
            $getReplies = $db->query(sprintf("SELECT comm.*, user.UserName, user.UserFirstName, user.UserLastName, user.UserAvatarPathMedium AS UserAvatarPath FROM posts_comments_media comm INNER JOIN users user ON comm.UserID = user.UserID WHERE comm.ParentNodeID = %s ORDER BY comm.Time ASC LIMIT %s,%s", SafeSQL($comment['ID'], 'int'), $comment['prevReplies'], $records )) or die(ReportError('sql error #3 @/ajax/media/comments/get'));
            while($reply = $getReplies->fetch_array(MYSQLI_ASSOC)) {
                // check if user liked|disliked this reply before
                $getReplyStatus = $db->query(sprintf("SELECT Liked FROM users_comments_media_likes WHERE UserID = %s AND CommentID = %s", SafeSQL($userArray['UserID'], 'int'), SafeSQL($reply['ID'], 'int') )) or die(ReportError('sql error #4 @/ajax/posts/get'));
                if($getReplyStatus->num_rows > 0) {
                    $replyStatus = $getReplyStatus->fetch_array(MYSQLI_ASSOC);
                    $reply['liked'] = $replyStatus['Liked'];
                }
                // decode text
                $reply['Text'] = DecodeText($reply['Text']);
                $comment['replies'][] = $reply;
            }
        }
        
        // check if user liked|disliked this comment before
        $getCommentStatus = $db->query(sprintf("SELECT Liked FROM users_comments_media_likes WHERE UserID = %s AND CommentID = %s", SafeSQL($userArray['UserID'], 'int'), SafeSQL($comment['ID'], 'int') )) or die(ReportError('sql error #5 @/ajax/media/comments/get'));
        if($getCommentStatus->num_rows > 0) {
            $commentStatus = $getCommentStatus->fetch_array(MYSQLI_ASSOC);
            $comment['liked'] = $commentStatus['Liked'];
        }
        
        // decode text
        $comment['Text'] = DecodeText($comment['Text']);
        
        $comments[] = $comment;
    }
    
    // assign variables
    $smarty->assign('prevComments', $prevComments);
    $smarty->assign('comments', $comments);
    
}elseif($_GET['get'] == 'replies') {
    
    // parse parameters
    $commentId = $id[1];
    $postType = $id[2];
    $mediaId = $id[3];
    $authorId = $id[4];
    $prevComments = $id[5];
    
    // check if valid comment
    $checkPost = $db->query(sprintf("SELECT * FROM posts_comments_media WHERE ID = %s AND UserID = %s AND PostType = %s AND MediaID = %s", SafeSQL($commentId, 'int'), SafeSQL($authorId, 'int'), SafeSQL($postType, 'int'), SafeSQL($mediaId, 'int') )) or die(PopupError(ReportError('sql error #6 @/ajax/media/comments/post')));
    if($checkPost->num_rows == 0) {
        exit(PopupError(PopupError('<div class="highlightContianer">This content is unavailable, It may be deleted by the author</div>')));
    }
    
    // get Replies
    if($prevComments > $systemSetting['MaxReplies']) {
        $records = $systemSetting['MaxReplies'];
        $prevComments -= $systemSetting['MaxReplies'];
    }else {
        $records = $prevComments;
        $prevComments = 0;
    }
    $getReplies = $db->query(sprintf("SELECT comm.*, user.UserName, user.UserFirstName, user.UserLastName, user.UserAvatarPathMedium AS UserAvatarPath FROM posts_comments_media comm INNER JOIN users user ON comm.UserID = user.UserID WHERE comm.ParentNodeID = %s ORDER BY comm.Time ASC LIMIT %s,%s", SafeSQL($commentId, 'int'), $prevComments, $records )) or die(ReportError('sql error #7 @/ajax/media/comments/get'));
    while($reply = $getReplies->fetch_array(MYSQLI_ASSOC)) {
        
        // check if user liked|disliked this reply before
        $getReplyStatus = $db->query(sprintf("SELECT Liked FROM users_comments_media_likes WHERE UserID = %s AND CommentID = %s", SafeSQL($userArray['UserID'], 'int'), SafeSQL($reply['ID'], 'int') )) or die(ReportError('sql error #8 @/ajax/media/comments/get'));
        if($getReplyStatus->num_rows > 0) {
            $replyStatus = $getReplyStatus->fetch_array(MYSQLI_ASSOC);
            $reply['liked'] = $replyStatus['Liked'];
        }
        
        // decode text
        $reply['Text'] = DecodeText($reply['Text']);
        
        $replies[] = $reply;
    }
    
    // assign variables
    $smarty->assign('prevComments', $prevComments);
    $smarty->assign('replies', $replies);
    
}

// assign variables
$smarty->assign('get', $_GET['get']);
$smarty->assign('post', array('PostType' => $postType, 'PostID' => $mediaId));

// page footer
PageFooter("ajax.comments.get");

?>