<?php
/**
 * post new album
 * 
 * @package Sngine
 * @author Zamblek
 */

// fetch kernal
$depth = '../../../';
require($depth.'kernal.php');

// check AJAX Request
if(!IsAJAX()) {
    header('Location: '.SITE_URL);
}

// check user exist
if(!$userExist) {
    exit(PopupError('Please log in to continue.', 'Not Logged In'));
}

// check user verified
if($userArray['Verified'] == "N") {
    VerifyError();
}

// check page parameters
if(!isset($_POST['app'])) {
    exit(PopupError(ReportError('parameters error[1] @/ajax/media/albums/post')));
}

// valid inputs
$valid['app'] = array('photos', 'videos');
if(!in_array($_POST['app'], $valid['app'])) {
    exit(PopupError(ReportError('parameters error[2] @/ajax/media/albums/post')));
}

// check page parameters
if(!isset($_POST['title']) || !isset($_POST['text'])) {
    exit(PopupError(ReportError('parameters error[3] @/ajax/media/albums/post')));
}

// check if empty
if(IsEmpty($_POST['title'])) {
    exit(PopupError('Please enter a valid (non-empty) album title.'));
}

// check length
if(strlen($_POST['title']) > 100) {
    exit(PopupError('Your title is too long. The maximum length is 100 characters.'));
}
if(strlen($_POST['text']) > 1024) {
    exit(PopupError('Your description is too long. The maximum length is 1024 characters.'));
}

// insert app album
$albumTable = ($_POST['app'] == "photos")? 'posts_photos_albums' : 'posts_videos_albums';
$db->query(sprintf("INSERT INTO %s (UserID, IsWall, Title, Text, Time) VALUES (%s, 'N', %s, %s, %s)", $albumTable, Secure($userArray['UserID'], 'int'), Secure($_POST['title']), Secure($_POST['text']), $now )) or die(PopupError(ReportError('sql error #1 @/ajax/media/albums/post')));
$albumId = $db->insert_id;

// update user posts
$db->query(sprintf("UPDATE users SET UserPosts = UserPosts + 1 WHERE UserID = %s", Secure($userArray['UserID'], 'int') )) or die(PopupError(ReportError('sql error #2 @/ajax/media/albums/post')));

// return data
$data['status'] = 'success';
$data['value'] = $albumId;
exit(json_encode($data));

?>