<?php
/**
 * get albums
 * 
 * @package Sngine
 * @author Zamblek
 */

// fetch kernal
$depth = '../../../';
require($depth.'kernal.php');

// check AJAX Request
if(!IsAJAX()) {
    header('Location: '.SITE_URL);
}

// check page parameters
if(!isset($_GET['id']) || !isset($_GET['app'])) {
    exit(ReportError('parameters error[1] @/ajax/media/albums/get'));
}

// valid inputs
$valid['app'] = array('photos', 'videos');
if(!in_array($_GET['app'], $valid['app'])) {
    exit(ReportError('parameters error[2] @/ajax/media/albums/get'));
}

// parse parameters
if(!preg_match('/^([0-9]+)$/', $_GET['id'])) {
    exit(ReportError('parameters error[3] @/ajax/media/albums/get'));
}

// get albums
if($_GET['app'] == "photos") {
    $albumTable = "posts_photos_albums";
    $sourceTable = "posts_photos_sources";
}else {
    $albumTable = "posts_videos_albums";
    $sourceTable = "posts_videos_sources";
}
$getAlbums = $db->query(sprintf("SELECT album.*, source.Thumbnail FROM %s album LEFT JOIN %s source ON album.ThumbnailID = source.ID WHERE album.UserID = %s", $albumTable, $sourceTable, SafeSQL($_GET['id'], 'int') )) or die(ReportError('sql error #1 @/ajax/media/albums/post'));
while($album = $getAlbums->fetch_array(MYSQLI_ASSOC)) {
    $albums[] = $album;
}

// assign variables
$smarty->assign('app', $_GET['app']);
$smarty->assign('albums', $albums);

// page footer
PageFooter("ajax.media.albums");

?>