<?php
/**
 * messages
 * 
 * @package Sngine
 * @author Zamblek
 */

// fetch kernal
$depth = '../../';
require($depth.'kernal.php');

// check AJAX Request
if(!IsAJAX()) {
    header('Location: '.SITE_URL);
}

// check user exist & verified
if(!$userExist || $userArray['Verified'] == "N") {
    exit();
}

// check page parameters
if(!isset($_GET['get'])) {
    exit(ReportError('parameters error[1] @/ajax/live/messages'));
}

// valid inputs
$valid['get'] = array('all', 'new');
if(!in_array($_GET['get'], $valid['get'])) {
    exit(ReportError('parameters error[2] @/ajax/live/messages'));
}

// check user conversations
if($userArray['UserMessages'] == 0) {
    exit;
}
if($_GET['get'] == "new" && $userArray['UserMessaged'] == "N") {
    if($userArray['UserNewMessages'] == 0) {
        echo "reseted";
    }
    exit;
}


// update user messaged status
$db->query(sprintf("UPDATE users SET UserMessaged = 'N' WHERE UserID = %s", SafeSQL($userArray['UserID'], 'int') )) or die(ReportError('sql error #1 @/ajax/live/messages'));

// get conversations
$getConversations = $db->query(sprintf("SELECT * FROM messages_conversations_users user INNER JOIN messages_conversations conv ON user.ConversationID = conv.ID WHERE user.UserID = %s AND user.Deleted = 'N' ORDER BY conv.LastUpdate DESC LIMIT 5", SafeSQL($userArray['UserID'], 'int') )) or die(ReportError('sql error #2 @/ajax/live/messages'));
while($conversation = $getConversations->fetch_array(MYSQLI_ASSOC)) {
    // get conversation recipients
    if($conversation['Recipients'] <= 3) {
        $getRecipients = $db->query(sprintf("SELECT user.UserID, user.UserFirstName, user.UserLastName, user.UserAvatarPathSmall AS UserAvatarPath FROM messages_conversations_users conv INNER JOIN users user ON conv.UserID = user.UserID WHERE conv.ConversationID = %s AND conv.UserID != %s LIMIT 3", SafeSQL($conversation['ConversationID'], 'int'), SafeSQL($userArray['UserID'], 'int') )) or die(ReportError('sql error #3 @/ajax/live/messages'));
        while($recipient = $getRecipients->fetch_array(MYSQLI_ASSOC)) {
            $conversation['users'][] = $recipient;
        }
        $conversation['hasOthers'] = false;
    }else {
        $getRecipients = $db->query(sprintf("SELECT user.UserID, user.UserFirstName, user.UserLastName, user.UserAvatarPathSmall AS UserAvatarPath FROM messages_conversations_users conv INNER JOIN users user ON conv.UserID = user.UserID WHERE conv.ConversationID = %s AND conv.UserID != %s LIMIT 2", SafeSQL($conversation['ConversationID'], 'int'), SafeSQL($userArray['UserID'], 'int') )) or die(ReportError('sql error #4 @/ajax/live/messages'));
        while($recipient = $getRecipients->fetch_array(MYSQLI_ASSOC)) {
            $conversation['users'][] = $recipient;
        }
        $conversation['others'] = $conversation['Recipients'] - 2;
        $conversation['hasOthers'] = true;
    }
    // prepare conversation avatar
    if($conversation['Recipients'] > 1) {
        $conversation['MixedAvatar'] = true;
        $conversation['LeftAvatarPath'] = $conversation['users'][0]['UserAvatarPath'];
        $conversation['RightAvatarPath'] = $conversation['users'][1]['UserAvatarPath'];
    }else {
        $conversation['MixedAvatar'] = false;
        $conversation['AvatarPath'] = $conversation['users'][0]['UserAvatarPath'];
    }
    $conversations[] = $conversation;
}
$smarty->assign('conversations', $conversations);

// page footer
PageFooter("ajax.live.messages");

?>