<?php

/**
 * (C)Copyright 2011. All Rights Reserved.
 * This software has been designed and developed by Yehia Abed
 *
 * Sngine -> ajax -> comments -> post.php - post new comment|reply
 *
 * Version 0.2 [Start Date: 04/01/2009]
 */
    
    // define the page
    $page = "ajax.comments.post";
    
    // fetch required files
    $depth = '../../';
    require_once($depth.'kernal.php');
    
    // check user exist
    if(!$userExist) {
        exit(PopupError('Please log in to continue.', 'Not Logged In'));
    }
    
    // check user verified
    if($userArray['Verified'] == "N") {
        VerifyError();
    }
    
    // check page parameters
    if(!isset($_POST['id']) || !isset($_POST['text']) || !isset($_POST['type'])) {
        exit(PopupError(ReportError('parameters error[1] @/ajax/comments/post')));
    }
    
    // valid inputs
    $valid['type'] = array('reply', 'qcomment', 'comment');
    if(!in_array($_POST['type'], $valid['type'])) {
        exit(PopupError(ReportError('parameters error[2] @/ajax/comments/post')));
    }
    
    // parse parameters
    $id = ParseId($_POST['id'], 4);
    if(!$id) {
        exit(PopupError(ReportError('parameters error[3] @/ajax/comments/post')));
    }
    $activityId = $id[1];
    $postType = $id[2];
    $postId = $id[3];
    $authorId = $id[4];
    
    // check if empty
    if(IsEmpty($_POST['text'])) {
        exit(PopupError('Please enter a valid (non-empty) comment.'));
    }
    
    // check length
    if(strlen($_POST['text']) > 1024) {
        exit(PopupError('Your comment is too long. The maximum length is 1024 characters.'));
    }
    
    // sanitize inputs
    $_POST['text'] = Sanitize($_POST['text']);
    
    if($_POST['type'] == "reply") {
        
        // parse parameters
        $pid = ParseId($_POST['pid'], 4);
        if(!$pid) {
            exit(PopupError(ReportError('parameters error[4] @/ajax/comments/post')));
        }
        $postAuthorId = $pid[4];
        
        // check if valid comment
        $checkComment = $db->query(sprintf("SELECT * FROM posts_comments WHERE ID = %s", SafeSQL($activityId, 'int') )) or die(PopupError(ReportError('sql error #1 @/ajax/comments/post')));
        if($checkComment->num_rows == 0) {
            exit(PopupError('<div class="highlightContianer">This content is unavailable, It may be deleted by the author</div>'));
        }
        
        // insert comment
        $db->query(sprintf("UPDATE posts_comments SET Replies = Replies + 1 WHERE ID = %s", SafeSQL($activityId, 'int') )) or die(PopupError(ReportError('sql error #2 @/ajax/comments/post')));
        $db->query(sprintf("INSERT INTO posts_comments (UserID, PostType, PostID, Text, Time, ParentNodeID) VALUES (%s, %s, %s, %s, %s, %s)", SafeSQL($userArray['UserID'], 'int'), SafeSQL($postType, 'int'), SafeSQL($postId, 'int'), SafeSQL($_POST['text']), $now, SafeSQL($activityId, 'int') )) or die(PopupError(ReportError('sql error #3 @/ajax/comments/post')));
        $commentId = $db->insert_id;
        
        // update post
        $db->query(sprintf("UPDATE posts SET Comments = Comments + 1 WHERE PostType = %s AND PostID = %s", SafeSQL($postType, 'int'), SafeSQL($postId, 'int') )) or die(PopupError(ReportError('sql error #4 @/ajax/comments/post')));
        
        // insert notification | comment author
        if($userArray['UserID'] != $authorId) {
            $db->query(sprintf("INSERT INTO notifications (UserID, Action, AuthorID, PostType, PostID, Type, Time) VALUES (%s, 5, %s, %s, %s, 'C', %s)", SafeSQL($userArray['UserID'], 'int'), SafeSQL($authorId, 'int'), SafeSQL($postType, 'int'), SafeSQL($postId, 'int'), $now )) or die(PopupError(ReportError('sql error #5 @/ajax/comments/post')));
            $db->query(sprintf("UPDATE users SET UserNotifications = UserNotifications + 1, UserNewNotifications = UserNewNotifications + 1 WHERE UserID = %s", SafeSQL($authorId, 'int'))) or die(PopupError(ReportError('sql error #6 @/ajax/comments/post')));
        }
        
        // insert notification | post author
        if($userArray['UserID'] != $postAuthorId) {
            $db->query(sprintf("INSERT INTO notifications (UserID, Action, AuthorID, PostType, PostID, Time) VALUES (%s, 5, %s, %s, %s, %s)", SafeSQL($userArray['UserID'], 'int'), SafeSQL($postAuthorId, 'int'), SafeSQL($postType, 'int'), SafeSQL($postId, 'int'), $now )) or die(PopupError(ReportError('sql error #7 @/ajax/comments/post')));
            $db->query(sprintf("UPDATE users SET UserNotifications = UserNotifications + 1, UserNewNotifications = UserNewNotifications + 1 WHERE UserID = %s", SafeSQL($postAuthorId, 'int'))) or die(PopupError(ReportError('sql error #8 @/ajax/comments/post')));
        }
        
    }else {
        
        // check if valid post
        $checkPost = $db->query(sprintf("SELECT * FROM posts WHERE PostType = %s AND PostID = %s AND UserID = %s", SafeSQL($postType, 'int'), SafeSQL($postId, 'int'), SafeSQL($authorId, 'int') )) or die(PopupError(ReportError('sql error #9 @/ajax/comments/post')));
        if($checkPost->num_rows == 0) {
            exit(PopupError('<div class="highlightContianer">This content is unavailable, It may be deleted by the author</div>'));
        }
        
        // insert comment
        $db->query(sprintf("INSERT INTO posts_comments (UserID, PostType, PostID, Text, Time) VALUES (%s, %s, %s, %s, %s)", SafeSQL($userArray['UserID'], 'int'), SafeSQL($postType, 'int'), SafeSQL($postId, 'int'), SafeSQL($_POST['text']), $now )) or die(PopupError(ReportError('sql error #10 @/ajax/comments/post')));
        $commentId = $db->insert_id;
        
        // update post
        $db->query(sprintf("UPDATE posts SET Comments = Comments + 1, PComments = PComments + 1 WHERE PostType = %s AND PostID = %s", SafeSQL($postType, 'int'), SafeSQL($postId, 'int') )) or die(PopupError(ReportError('sql error #11 @/ajax/comments/post')));
        
        // insert notification
        if($userArray['UserID'] != $authorId) {
            $db->query(sprintf("INSERT INTO notifications (UserID, Action, AuthorID, PostType, PostID, Time) VALUES (%s, 5, %s, %s, %s, %s)", SafeSQL($userArray['UserID'], 'int'), SafeSQL($authorId, 'int'), SafeSQL($postType, 'int'), SafeSQL($postId, 'int'), $now )) or die(PopupError(ReportError('sql error #12 @/ajax/comments/post')));
            $db->query(sprintf("UPDATE users SET UserNotifications = UserNotifications + 1, UserNewNotifications = UserNewNotifications + 1 WHERE UserID = %s", SafeSQL($authorId, 'int'))) or die(PopupError(ReportError('sql error #13 @/ajax/comments/post')));
        }
        
    }
    
    $post['PostType'] = $postType;
    $post['PostID'] = $postId;
    $comment['ID'] = $commentId;
    $comment['Time'] = $now;
    $comment['Text'] = DecodeText($_POST['text']);
    
    // assigne variables
    $smarty->assign('post', $post);
    $smarty->assign('comment', $comment);
    $smarty->assign('type', $_POST['type']);
    
    // return data
    $data['status'] = 'success';
    $data['value'] = $smarty->fetch("$page.tpl");
    exit(json_encode($data));
    
?>