<?php

/**
 * (C)Copyright 2011. All Rights Reserved.
 * This software has been designed and developed by Yehia Abed
 *
 * Sngine -> ajax -> comments -> get.php - get comments
 *
 * Version 0.2 [Start Date: 04/01/2009]
 */
    
    // define the page
    $page = "ajax.comments.get";
    
    // fetch required files
    $depth = '../../';
    require_once $depth.'kernal.php';
    
    // check page parameters
    if(!isset($_GET['id']) || !isset($_GET['get'])) {
        exit(ReportError('parameters error[1] @/ajax/comments/get'));
    }
    
    // valid inputs
    $valid['get'] = array('qcomments', 'comments', 'replies');
    if(!in_array($_GET['get'], $valid['get'])) {
        exit(ReportError('parameters error[2] @/ajax/comments/get'));
    }
    
    // parse parameters
    $id = ParseId($_GET['id'], 5);
    if(!$id) {
        exit(ReportError('parameters error[3] @/ajax/comments/get'));
    }
    $commentId = $id[1];
    $postType = $id[2];
    $postId = $id[3];
    $authorId = $id[4];
    $prevComments = $id[5];
    
    // check if valid post
    $checkPost = $db->query(sprintf("SELECT * FROM posts WHERE PostType = %s AND PostID = %s", SafeSQL($postType, 'int'), SafeSQL($postId, 'int') )) or die(ReportError('sql error #1 @/ajax/comments/get'));
    if($checkPost->num_rows == 0) {
        exit(ReportError('This content is unavailable, It may be deleted by the author'));
    }
    
    if($_GET['get'] == 'qcomments') {
        
        // get comments
        $getComments = $db->query(sprintf("SELECT comm.*, user.UserName, user.UserFirstName, user.UserLastName, user.UserAvatarPathSmall AS UserAvatarPath FROM posts_comments comm INNER JOIN users user ON comm.UserID = user.UserID WHERE comm.PostType = %s AND comm.PostID = %s ORDER BY comm.Time ASC LIMIT 0, %s", SafeSQL($postType, 'int'), SafeSQL($postId, 'int'), $prevComments )) or die(ReportError('sql error #2 @/ajax/comments/get'));
        while($comment = $getComments->fetch_array(MYSQLI_ASSOC)) {
            
            // check if user liked|disliked this comment before
            $getCommentStatus = $db->query(sprintf("SELECT Liked FROM users_comments_likes WHERE UserID = %s AND CommentID = %s", SafeSQL($userArray['UserID'], 'int'), SafeSQL($comment['ID'], 'int') )) or die(ReportError('sql error #3 @/ajax/comments/get'));
            if($getCommentStatus->num_rows > 0) {
                $commentStatus = $getCommentStatus->fetch_array(MYSQLI_ASSOC);
                $comment['liked'] = $commentStatus['Liked'];
            }
            
            // decode text
            $comment['Text'] = DecodeText($comment['Text']);
            
            $comments[] = $comment;
        }
        
        // assign variables
        $smarty->assign('comments', $comments);
        
    }elseif ($_GET['get'] == 'comments') {
        
        // get comments
        if($prevComments > $systemSetting['MaxComments']) {
            $records = $systemSetting['MaxComments'];
            $prevComments -= $systemSetting['MaxComments'];
        }else {
            $records = $prevComments;
            $prevComments = 0;
        }
        $getComments = $db->query(sprintf("SELECT comm.*, user.UserName, user.UserFirstName, user.UserLastName, user.UserAvatarPathMedium AS UserAvatarPath FROM posts_comments comm INNER JOIN users user ON comm.UserID = user.UserID WHERE comm.PostType = %s AND comm.PostID = %s AND comm.ParentNodeID = 0 ORDER BY comm.Time ASC LIMIT %s,%s", SafeSQL($postType, 'int'), SafeSQL($postId, 'int'), $prevComments, $records )) or die(ReportError('sql error #4 @/ajax/comments/get'));
        while($comment = $getComments->fetch_array(MYSQLI_ASSOC)) {
            // get Replies
            if($comment['Replies'] > 0) {
                if($comment['Replies'] > $systemSetting['MaxReplies']) {
                    $records = $systemSetting['MaxReplies'];
                    $comment['prevReplies'] = $comment['Replies'] - $systemSetting['MaxReplies'];
                }else {
                    $records = $comment['Replies'];
                    $comment['prevReplies'] = 0;
                }
                $getReplies = $db->query(sprintf("SELECT comm.*, user.UserName, user.UserFirstName, user.UserLastName, user.UserAvatarPathMedium AS UserAvatarPath FROM posts_comments comm INNER JOIN users user ON comm.UserID = user.UserID WHERE comm.ParentNodeID = %s ORDER BY comm.Time ASC LIMIT %s,%s", SafeSQL($comment['ID'], 'int'), $comment['prevReplies'], $records )) or die(ReportError('sql error #5 @/ajax/comments/get'));
                while($reply = $getReplies->fetch_array(MYSQLI_ASSOC)) {
                    
                    // check if user liked|disliked this reply before
                    $getReplyStatus = $db->query(sprintf("SELECT Liked FROM users_comments_likes WHERE UserID = %s AND CommentID = %s", SafeSQL($userArray['UserID'], 'int'), SafeSQL($reply['ID'], 'int') )) or die(ReportError('sql error #6 @/ajax/posts/get'));
                    if($getReplyStatus->num_rows > 0) {
                        $replyStatus = $getReplyStatus->fetch_array(MYSQLI_ASSOC);
                        $reply['liked'] = $replyStatus['Liked'];
                    }
                    
                    // decode text
                    $reply['Text'] = DecodeText($reply['Text']);
                    
                    $comment['replies'][] = $reply;
                }
            }
            
            // check if user liked|disliked this comment before
            $getCommentStatus = $db->query(sprintf("SELECT Liked FROM users_comments_likes WHERE UserID = %s AND CommentID = %s", SafeSQL($userArray['UserID'], 'int'), SafeSQL($comment['ID'], 'int') )) or die(ReportError('sql error #7 @/ajax/comments/get'));
            if($getCommentStatus->num_rows > 0) {
                $commentStatus = $getCommentStatus->fetch_array(MYSQLI_ASSOC);
                $comment['liked'] = $commentStatus['Liked'];
            }
            
            // decode text
            $comment['Text'] = DecodeText($comment['Text']);
            
            $comments[] = $comment;
        }
        
        // assign variables
        $smarty->assign('prevComments', $prevComments);
        $smarty->assign('comments', $comments);
        
    }elseif ($_GET['get'] == 'replies') {
        
        // get Replies
        if($prevComments > $systemSetting['MaxReplies']) {
            $records = $systemSetting['MaxReplies'];
            $prevComments -= $systemSetting['MaxReplies'];
        }else {
            $records = $prevComments;
            $prevComments = 0;
        }
        $getReplies = $db->query(sprintf("SELECT comm.*, user.UserName, user.UserFirstName, user.UserLastName, user.UserAvatarPathMedium AS UserAvatarPath FROM posts_comments comm INNER JOIN users user ON comm.UserID = user.UserID WHERE comm.ParentNodeID = %s ORDER BY comm.Time ASC LIMIT %s,%s", SafeSQL($commentId, 'int'), $prevComments, $records )) or die(ReportError('sql error #6 @/ajax/comments/get'));
        while($reply = $getReplies->fetch_array(MYSQLI_ASSOC)) {
            
            // check if user liked|disliked this reply before
            $getReplyStatus = $db->query(sprintf("SELECT Liked FROM users_comments_likes WHERE UserID = %s AND CommentID = %s", SafeSQL($userArray['UserID'], 'int'), SafeSQL($reply['ID'], 'int') )) or die(ReportError('sql error #7 @/ajax/comments/get'));
            if($getReplyStatus->num_rows > 0) {
                $replyStatus = $getReplyStatus->fetch_array(MYSQLI_ASSOC);
                $reply['liked'] = $replyStatus['Liked'];
            }
            
            // decode text
            $reply['Text'] = DecodeText($reply['Text']);
            
            $replies[] = $reply;
        }
        
        // assign variables
        $smarty->assign('prevComments', $prevComments);
        $smarty->assign('replies', $replies);
        
    }
    
    // assign variables
    $smarty->assign('get', $_GET['get']);
    $smarty->assign('post', array('PostType' => $postType, 'PostID' => $postId));
    
    // display page templete
    $smarty->display("$page.tpl");
    
?>