<?php

/**
 * (C)Copyright 2011. All Rights Reserved.
 * This software has been designed and developed by Yehia Abed
 *
 * Sngine -> ajax -> answers -> vote.php - vote answer
 *
 * Version 0.2 [Start Date: 04/01/2009]
 */
    
    // fetch required files
    $depth = '../../';
    require_once($depth.'kernal.php');
    
    // check user exist
    if(!$userExist) {
        exit(PopupError('Please log in to continue.', 'Not Logged In'));
    }
    
    // check user verified
    if($userArray['Verified'] == "N") {
        VerifyError();
    }
    
    // check page parameters
    if(!isset($_POST['id']) || !isset($_POST['vote'])) {
        exit(PopupError(ReportError('parameters error[1] @/ajax/answers/vote')));
    }
    
    // valid inputs
    $valid['vote'] = array('up', 'unup', 'down', 'undown');
    if(!in_array($_POST['vote'], $valid['vote'])) {
        exit(PopupError(ReportError('parameters error[2] @/ajax/answers/vote')));
    }
    
    // parse parameters
    $id = ParseId($_POST['id'], 4);
    if(!$id) {
        exit(PopupError(ReportError('parameters error[3] @/ajax/answers/vote')));
    }
    $answerId = $id[1];
    $postType = $id[2];
    $postId = $id[3];
    $authorId = $id[4];
    
    // check if valid answer
    $checkComment = $db->query(sprintf("SELECT * FROM posts_questions_answers WHERE ID = %s AND QuestionID = %s AND UserID = %s", SafeSQL($answerId, 'int'), SafeSQL($postId, 'int'), SafeSQL($authorId, 'int') )) or die(PopupError(ReportError('sql error #1 @/ajax/answers/vote')));
    if($checkComment->num_rows == 0) {
        exit(PopupError('<div class="highlightContianer">This content is unavailable, It may be deleted by the author</div>'));
    }
    
    // check if user authorized
    if($userArray['UserID'] == $authorId) {
        exit(PopupError('You can not vote your own answer.'));
    }
    
    // up
    if($_POST['vote'] == "up") {
        
        // insert status
        $db->query(sprintf("INSERT INTO users_answers_votes (UserID, AnswerID, Voted) VALUES (%s, %s, 'U')", SafeSQL($userArray['UserID'], 'int'), SafeSQL($answerId, 'int') )) || exit;
        
        // update answers
        $db->query(sprintf("UPDATE posts_questions_answers SET Votes = Votes + 1 WHERE ID = %s", SafeSQL($answerId, 'int') )) or die(PopupError(ReportError('sql error #2 @/ajax/answers/vote')));
        
        // insert notification
        if($userArray['UserID'] != $authorId) {
            $db->query(sprintf("INSERT INTO notifications (UserID, Action, AuthorID, PostType, PostID, Type, Time) VALUES (%s, 2, %s, %s, %s, 'A', %s)", SafeSQL($userArray['UserID'], 'int'), SafeSQL($authorId, 'int'), SafeSQL($postType, 'int'), SafeSQL($postId, 'int'), SafeSQL($now) )) or die(PopupError(ReportError('sql error #3 @/ajax/answers/vote')));
            $db->query(sprintf("UPDATE users SET UserNotifications = UserNotifications + 1, UserNewNotifications = UserNewNotifications + 1 WHERE UserID = %s", SafeSQL($authorId, 'int'))) or die(PopupError(ReportError('sql error #4 @/ajax/answers/vote')));
        }
        
    // unup
    }elseif ($_POST['vote'] == "unup") {
        
        // delete status
        $db->query(sprintf("DELETE FROM users_answers_votes WHERE UserID = %s AND AnswerID = %s", SafeSQL($userArray['UserID'], 'int'), SafeSQL($answerId, 'int'))) or die(PopupError(ReportError('sql error #5 @/ajax/answers/vote')));
        
        // check affected rows
        if($db->affected_rows > 0) {
            
            // update answers
            $db->query(sprintf("UPDATE posts_questions_answers SET Votes = Votes - 1 WHERE ID = %s", SafeSQL($answerId, 'int') )) or die(PopupError(ReportError('sql error #6 @/ajax/answers/vote')));
            
            // delete notification
            if($userArray['UserID'] != $authorId) {
                $db->query(sprintf("DELETE FROM notifications WHERE UserID = %s AND Action = 2 AND PostType = %s AND PostID = %s AND Type = 'A'", SafeSQL($userArray['UserID'], 'int'), SafeSQL($postType, 'int'), SafeSQL($postId, 'int') )) or die(PopupError(ReportError('sql error #7 @/ajax/posts/modify')));
                $db->query(sprintf("UPDATE users SET UserNotifications = IF(UserNotifications=0,0,UserNotifications-1), UserNewNotifications = IF(UserNewNotifications=0,0,UserNewNotifications-1) WHERE UserID = %s", SafeSQL($authorId, 'int'))) or die(PopupError(ReportError('sql error #8 @/ajax/posts/modify')));
            }
            
        }
        
    // down
    }elseif ($_POST['vote'] == "down") {
        
        // insert status
        $db->query(sprintf("INSERT INTO users_answers_votes (UserID, AnswerID, Voted) VALUES (%s, %s, 'D')", SafeSQL($userArray['UserID'], 'int'), SafeSQL($answerId, 'int') )) || exit;
        
        // update answers
        $db->query(sprintf("UPDATE posts_questions_answers SET Votes = Votes - 1 WHERE ID = %s", SafeSQL($answerId, 'int') )) or die(PopupError(ReportError('sql error #9 @/ajax/answers/vote')));
        
        
        // insert notification
        if($userArray['UserID'] != $authorId) {
            $db->query(sprintf("INSERT INTO notifications (UserID, Action, AuthorID, PostType, PostID, Type, Time) VALUES (%s, 3, %s, %s, %s, 'A', %s)", SafeSQL($userArray['UserID'], 'int'), SafeSQL($authorId, 'int'), SafeSQL($postType, 'int'), SafeSQL($postId, 'int'), SafeSQL($now) )) or die(PopupError(ReportError('sql error #10 @/ajax/answers/vote')));
            $db->query(sprintf("UPDATE users SET UserNotifications = UserNotifications + 1, UserNewNotifications = UserNewNotifications + 1 WHERE UserID = %s", SafeSQL($authorId, 'int'))) or die(PopupError(ReportError('sql error #11 @/ajax/answers/vote')));
        }
        
    // undown
    }elseif ($_POST['vote'] == "undown") {
        
        // delete status
        $db->query(sprintf("DELETE FROM users_answers_votes WHERE UserID = %s AND AnswerID = %s", SafeSQL($userArray['UserID'], 'int'), SafeSQL($answerId, 'int'))) or die(PopupError(ReportError('sql error #12 @/ajax/answers/vote')));
        
        // check affected rows
        if($db->affected_rows > 0) {
            
            // update answers
            $db->query(sprintf("UPDATE posts_questions_answers SET Votes = Votes + 1 WHERE ID = %s", SafeSQL($answerId, 'int') )) or die(PopupError(ReportError('sql error #13 @/ajax/answers/vote')));
            
            // delete notification
            if($userArray['UserID'] != $authorId) {
                $db->query(sprintf("DELETE FROM notifications WHERE UserID = %s AND Action = 3 AND PostType = %s AND PostID = %s AND Type = 'A'", SafeSQL($userArray['UserID'], 'int'), SafeSQL($postType, 'int'), SafeSQL($postId, 'int') )) or die(PopupError(ReportError('sql error #14 @/ajax/answers/vote')));
                $db->query(sprintf("UPDATE users SET UserNotifications = IF(UserNotifications=0,0,UserNotifications-1), UserNewNotifications = IF(UserNewNotifications=0,0,UserNewNotifications-1) WHERE UserID = %s", SafeSQL($authorId, 'int'))) or die(PopupError(ReportError('sql error #15 @/ajax/answers/vote')));
            }
            
        }
    }
    
?>