<?php

/**
 * (C)Copyright 2011. All Rights Reserved.
 * This software has been designed and developed by Yehia Abed
 *
 * Sngine -> ajax -> answers -> post.php - post new answer|note
 *
 * Version 0.2 [Start Date: 04/01/2009]
 */
    
    // define the page
    $page = "ajax.answers.post";
    
    // fetch required files
    $depth = '../../';
    require_once($depth.'kernal.php');
    
    // check user exist
    if(!$userExist) {
        exit(PopupError('Please log in to continue.', 'Not Logged In'));
    }
    
    // check user verified
    if($userArray['Verified'] == "N") {
        VerifyError();
    }
    
    // check page parameters
    if(!isset($_POST['id']) || !isset($_POST['text']) || !isset($_POST['type'])) {
        exit(PopupError(ReportError('parameters error[1] @/ajax/answers/post')));
    }
    
    // valid inputs
    $valid['type'] = array('note', 'answer');
    if(!in_array($_POST['type'], $valid['type'])) {
        exit(PopupError(ReportError('parameters error[2] @/ajax/answers/post')));
    }
    
    // parse parameters
    $id = ParseId($_POST['id'], 4);
    if(!$id) {
        exit(PopupError(ReportError('parameters error[3] @/ajax/answers/post')));
    }
    $activityId = $id[1];
    $postType = $id[2];
    $postId = $id[3];
    $authorId = $id[4];
    
    // check if valid (post|answer)
    if($_POST['type'] == 'answer') {
        $checkPost = $db->query(sprintf("SELECT * FROM posts WHERE PostType = %s AND PostID = %s AND UserID = %s", SafeSQL($postType, 'int'), SafeSQL($postId, 'int'), SafeSQL($authorId, 'int') )) or die(PopupError(ReportError('sql error #1 @/ajax/answers/post')));
    }else {
        $checkPost = $db->query(sprintf("SELECT * FROM posts_questions_answers WHERE ID = %s AND QuestionID = %s AND UserID = %s", SafeSQL($activityId, 'int'), SafeSQL($postId, 'int'), SafeSQL($authorId, 'int') )) or die(PopupError(ReportError('sql error #2 @/ajax/answers/post')));
    }
    if($checkPost->num_rows == 0) {
        exit(PopupError('<div class="highlightContianer">This content is unavailable, It may be deleted by the author</div>'));
    }
    
    // check if answered before
    if($_POST['type'] == 'answer') {
        $checkQuestion = $db->query(sprintf("SELECT * FROM posts_questions_answers WHERE QuestionID = %s AND UserID = %s", SafeSQL($postId, 'int'), SafeSQL($userArray['UserID'], 'int') )) or die(PopupError(ReportError('sql error #3 @/ajax/answers/post')));
        if($checkQuestion->num_rows > 0) {
            exit(PopupError('You answered this question before'));
        }
    }
    
    // check if empty
    if(IsEmpty($_POST['text'])) {
        exit(PopupError('Please enter a valid (non-empty) answer.'));
    }
    
    // check length
    if(strlen($_POST['text']) > 1024) {
        exit(PopupError('Your answer is too long. The maximum length is 1024 characters.'));
    }
    
    // sanitize inputs
    $_POST['text'] = Sanitize($_POST['text']);
    
    // insert answer
    if($_POST['type'] == "note") {
        $db->query(sprintf("UPDATE posts_questions_answers SET Notes = Notes + 1 WHERE ID = %s", SafeSQL($activityId, 'int') )) or die(PopupError(ReportError('sql error #4 @/ajax/answers/post')));
        $db->query(sprintf("INSERT INTO posts_questions_notes (UserID, Text, Time, AnswerID) VALUES (%s, %s, %s, %s)", SafeSQL($userArray['UserID'], 'int'), SafeSQL($_POST['text']), $now, SafeSQL($activityId, 'int') )) or die(PopupError(ReportError('sql error #5 @/ajax/answers/post')));
    }else {
        $db->query(sprintf("UPDATE posts_questions SET Answers = Answers + 1 WHERE ID = %s", SafeSQL($postId, 'int') )) or die(PopupError(ReportError('sql error #6 @/ajax/answers/post')));
        $db->query(sprintf("INSERT INTO posts_questions_answers (UserID, Text, Time, QuestionID) VALUES (%s, %s, %s, %s)", SafeSQL($userArray['UserID'], 'int'), SafeSQL($_POST['text']), $now, SafeSQL($postId, 'int') )) or die(PopupError(ReportError('sql error #7 @/ajax/answers/post')));
    }
    $answerId = $db->insert_id;
    
    // insert notification
    if($userArray['UserID'] != $authorId) {
        if($_POST['type'] == "note") {
            $db->query(sprintf("INSERT INTO notifications (UserID, Action, AuthorID, PostType, PostID, Time) VALUES (%s, 7, %s, %s, %s, %s)", SafeSQL($userArray['UserID'], 'int'), SafeSQL($authorId, 'int'), SafeSQL($postType, 'int'), SafeSQL($postId, 'int'), $now )) or die(PopupError(ReportError('sql error #8 @/ajax/answers/post')));
        }else {
            $db->query(sprintf("INSERT INTO notifications (UserID, Action, AuthorID, PostType, PostID, Time) VALUES (%s, 6, %s, %s, %s, %s)", SafeSQL($userArray['UserID'], 'int'), SafeSQL($authorId, 'int'), SafeSQL($postType, 'int'), SafeSQL($postId, 'int'), $now )) or die(PopupError(ReportError('sql error #9 @/ajax/answers/post')));
        }
        $db->query(sprintf("UPDATE users SET UserNotifications = UserNotifications + 1, UserNewNotifications = UserNewNotifications + 1 WHERE UserID = %s", SafeSQL($authorId, 'int'))) or die(PopupError(ReportError('sql error #10 @/ajax/answers/post')));
    }
    
    $post['PostType'] = $postType;
    $post['PostID'] = $postId;
    $answer['ID'] = $answerId;
    $answer['AnswerID'] = $activityId;
    $answer['Time'] = $now;
    $answer['Text'] = DecodeText($_POST['text']);
    
    // assigne variables
    $smarty->assign('post', $post);
    $smarty->assign('answer', $answer);
    $smarty->assign('type', $_POST['type']);
    
    // return data
    $data['status'] = 'success';
    $data['value'] = $smarty->fetch("$page.tpl");
    exit(json_encode($data));
    
?>