<?php

/**
 * (C)Copyright 2011. All Rights Reserved.
 * This software has been designed and developed by Yehia Abed
 *
 * Sngine -> ajax -> answers -> get.php - get answers
 *
 * Version 0.2 [Start Date: 04/01/2009]
 */
    
    // define the page
    $page = "ajax.answers.get";
    
    // fetch required files
    $depth = '../../';
    require_once($depth.'kernal.php');
    
    // check page parameters
    if(!isset($_GET['id']) || !isset($_GET['get'])) {
        exit(ReportError('parameters error[1] @/ajax/answers/get'));
    }
    
    // valid inputs
    $valid['get'] = array('answers', 'notes');
    if(!in_array($_GET['get'], $valid['get'])) {
        exit(ReportError('parameters error[2] @/ajax/answers/get'));
    }
    
    // parse parameters
    $id = ParseId($_GET['id'], 5);
    if(!$id) {
        exit(ReportError('parameters error[3] @/ajax/answers/get'));
    }
    $answerId = $id[1];
    $postType = $id[2];
    $postId = $id[3];
    $authorId = $id[4];
    $startPoint = $id[5];
    
    // check if valid post
    $checkPost = $db->query(sprintf("SELECT question.Answers FROM posts_questions question INNER JOIN posts post ON post.PostType = %s AND question.ID = post.PostID WHERE question.ID = %s", SafeSQL($postType, 'int'), SafeSQL($postId, 'int') )) or die(ReportError('sql error #1 @/ajax/answers/get'));
    if($checkPost->num_rows == 0) {
        exit(ReportError('This content is unavailable, It may be deleted by the author'));
    }
    $question = $checkPost->fetch_array(MYSQLI_ASSOC);
    
    // block spammers
    if(count($userBlockedUsers) > 0) {
        $whereStatement['answers'] = ' AND answer.UserID NOT IN (' . implode(',', $userBlockedUsers) . ')';
        $whereStatement['notes'] = ' AND note.UserID NOT IN (' . implode(',', $userBlockedUsers) . ')';
    }
    
    if($_GET['get'] == 'answers') {
        
        // get answers
        $getAnswers = $db->query(sprintf("SELECT answer.*, user.UserName, user.UserFirstName, user.UserLastName, user.UserAvatarPathSmall AS UserAvatarPath FROM posts_questions_answers answer INNER JOIN users user ON answer.UserID = user.UserID WHERE answer.QuestionID = %s ".$whereStatement['answers']." ORDER BY answer.Votes DESC LIMIT %s,".$systemSetting['MaxAnswers'], SafeSQL($postId, 'int'), $startPoint )) or die(ReportError('sql error #2 @/ajax/answers/get'));
        while($answer = $getAnswers->fetch_array(MYSQLI_ASSOC)) {
            
            // get Notes
            if($answer['Notes'] > 0) {
                $answer['prevNotes'] = ($answer['Notes'] > $systemSetting['MaxNotes'])? $answer['Notes'] - $systemSetting['MaxNotes']: 0;
                $getNotes = $db->query(sprintf("SELECT note.*, user.UserName, user.UserFirstName, user.UserLastName FROM posts_questions_notes note INNER JOIN users user ON note.UserID = user.UserID WHERE note.AnswerID = %s ".$whereStatement['notes']." ORDER BY note.Time ASC LIMIT %s,".$systemSetting['MaxNotes'], SafeSQL($answer['ID'], 'int'), $answer['prevNotes'] )) or die(ReportError('sql error #3 @/ajax/answers/get'));
                while($note = $getNotes->fetch_array(MYSQLI_ASSOC)) {
                    
                    // decode text
                    $note['Text'] = DecodeText($note['Text']);
                    
                    $answer['notes'][] = $note;
                }
            }
            
            // check if user voted for this answer before
            $getAnswerStatus = $db->query(sprintf("SELECT Voted FROM users_answers_votes WHERE UserID = %s AND AnswerID = %s", SafeSQL($userArray['UserID'], 'int'), SafeSQL($answer['ID'], 'int') )) or die(ReportError('sql error #4 @/ajax/answers/get'));
            if($getAnswerStatus->num_rows > 0) {
                $answerStatus = $getAnswerStatus->fetch_array(MYSQLI_ASSOC);
                $answer['voted'] = $answerStatus['Voted'];
            }
            
            // decode text
            $answer['Text'] = DecodeText($answer['Text']);
            
            $answers[] = $answer;
        }
        
        $startPoint += $systemSetting['MaxAnswers'];
        if(($question['Answers'] - $startPoint) > 0) {
            $viewmore = true;
        }else {
            $viewmore = false;
        }
        
        // assign variables
        $smarty->assign('viewmore', $viewmore);
        $smarty->assign('startPoint', $startPoint);
        $smarty->assign('answers', $answers);
        
    }elseif ($_GET['get'] == 'notes') {
        
        // get Replies
        if($startPoint > $systemSetting['MaxNotes']) {
            $records = $systemSetting['MaxNotes'];
            $prevNotes = $startPoint -  $systemSetting['MaxNotes'];
        }else {
            $records = $startPoint;
            $prevNotes = 0;
        }
        $getNotes = $db->query(sprintf("SELECT note.*, user.UserName, user.UserFirstName, user.UserLastName FROM posts_questions_notes note INNER JOIN users user ON note.UserID = user.UserID WHERE note.AnswerID = %s ".$whereStatement['notes']." ORDER BY note.Time ASC LIMIT %s, %s", SafeSQL($answerId, 'int'), $prevNotes, $records )) or die(ReportError('sql error #5 @/ajax/answers/get'));
        while($note = $getNotes->fetch_array(MYSQLI_ASSOC)) {
            
            // decode text
            $note['Text'] = DecodeText($note['Text']);
            
            $notes[] = $note;
        }
        
        // assign variables
        $smarty->assign('prevNotes', $prevNotes);
        $smarty->assign('notes', $notes);
        
    }
    
    // assign variables
    $smarty->assign('get', $_GET['get']);
    $smarty->assign('post', array('PostType' => $postType, 'PostID' => $postId));
    
    // display page templete
    $smarty->display("$page.tpl");
    
?>