<?php

/**
 * (C)Copyright 2011. All Rights Reserved.
 * This software has been designed and developed by Yehia Abed
 *
 * Sngine -> ajax -> answers -> delete.php - delete answers|notes
 *
 * Version 0.2 [Start Date: 04/01/2009]
 */
    
    // fetch required files
    $depth = '../../';
    require_once($depth.'kernal.php');
    
    // check user exist
    if(!$userExist) {
        exit(PopupError('Please log in to continue.', 'Not Logged In'));
    }
    
    // check user verified
    if($userArray['Verified'] == "N") {
        VerifyError();
    }
    
    // check page parameters
    if(!isset($_POST['id']) || !isset($_POST['type'])) {
        exit(PopupError(ReportError('parameters error[1] @/ajax/answers/delete')));
    }
    
    // valid inputs
    $valid['type'] = array('answer', 'note');
    if(!in_array($_POST['type'], $valid['type'])) {
        exit(PopupError(ReportError('parameters error[2] @/ajax/answers/delete')));
    }
    
    // parse parameters
    $id = ParseId($_POST['id'], 4);
    if(!$id) {
        exit(PopupError(ReportError('parameters error[3] @/ajax/answers/delete')));
    }
    $activityId = $id[1]; // answerId|noteId
    $postType = $id[2]; // postType|answerId
    $postId = $id[3];
    $authorId = $id[4];
    
    if($_POST['type'] == 'answer') {
        
        // check if valid answer
        $checkAnswer = $db->query(sprintf("SELECT * FROM posts_questions_answers WHERE ID = %s AND QuestionID = %s AND UserID = %s", SafeSQL($activityId, 'int'), SafeSQL($postId, 'int'), SafeSQL($authorId, 'int') )) or die(PopupError(ReportError('sql error #1 @/ajax/answers/delete')));
        if($checkAnswer->num_rows == 0) {
            exit(PopupError('<div class="highlightContianer">This content is unavailable, It may be deleted by the author</div>'));
        }
        
        // check if user authorized
        if($authorId == $userArray['UserID'] || $userArray['UserGroup'] < 3) {
            
            // delete notes
            $db->query(sprintf("DELETE FROM posts_questions_notes WHERE AnswerID = %s", SafeSQL($activityId, 'int') )) or die(PopupError(ReportError('sql error #2 @/ajax/answers/delete')));
            
            // delete answer
            $db->query(sprintf("DELETE FROM posts_questions_answers WHERE ID = %s", SafeSQL($activityId, 'int') )) or die(PopupError(ReportError('sql error #3 @/ajax/answers/delete')));
            
            // update question
            $db->query(sprintf("UPDATE posts_questions SET Answers = IF(Answers=0,0,Answers-1) WHERE ID = %s", SafeSQL($postId, 'int') )) or die(PopupError(ReportError('sql error #4 @/ajax/answers/delete')));
            
        }else {
            exit(PopupError('<div class="highlightContianer">This content is unavailable, It may be deleted by the author</div>'));
        }
        
    }else {
        
        // check if valid note
        $checkNote = $db->query(sprintf("SELECT * FROM posts_questions_notes WHERE ID = %s AND UserID = %s", SafeSQL($activityId, 'int'), SafeSQL($authorId, 'int') )) or die(PopupError(ReportError('sql error #5 @/ajax/answers/delete')));
        if($checkNote->num_rows == 0) {
            exit(PopupError('<div class="highlightContianer">This content is unavailable, It may be deleted by the author</div>'));
        }
        
        // check if user authorized
        if($authorId == $userArray['UserID'] || $userArray['UserGroup'] < 3) {
            
            // delete note
            $db->query(sprintf("DELETE FROM posts_questions_notes WHERE ID = %s", SafeSQL($activityId, 'int') )) or die(PopupError(ReportError('sql error #6 @/ajax/answers/delete')));
            
            // update answer
            $db->query(sprintf("UPDATE posts_questions_answers SET Notes = IF(Notes=0,0,Notes-1) WHERE ID = %s", SafeSQL($postType, 'int') )) or die(PopupError(ReportError('sql error #7 @/ajax/answers/delete')));
            
        }else {
            exit(PopupError('<div class="highlightContianer">This content is unavailable, It may be deleted by the author</div>'));
        }
        
    }
    
?>