<?php
/**
 * users
 * 
 * @package Sngine
 * @author Zamblek
 */

// fetch kernal
require('kernal.php');

// check admin exist
if(!$adminExist) {
    GetLogin($translate->__("You have to login to access this page"));
}

// page tags
PageHeader($translate->__("Users"));

if(!isset($_GET['tab']) || $_GET['tab'] == "search") {
    $view = "search";
}elseif ($_GET['tab'] == "find") {
    $view = "find";
    $paginationURL = "tab=find";
    // prepare where statement
    if(!IsEmpty($_GET['firstname'])) {
        if(empty($whereStatement)) {
            $whereStatement  = " WHERE UserFirstName LIKE ".Secure($_GET['firstname'], 'search');
        }else {
            $whereStatement .= " AND UserFirstName LIKE ".Secure($_GET['firstname'], 'search');
        }
        $paginationURL .= "&firstname=".$_GET['firstname'];
    }
    if(!IsEmpty($_GET['lastname'])) {
        if(empty($whereStatement)) {
            $whereStatement  = " WHERE UserLastName LIKE ".Secure($_GET['lastname'], 'search');
        }else {
            $whereStatement .= " AND UserLastName LIKE ".Secure($_GET['lastname'], 'search');
        }
        $paginationURL .= "&lastname=".$_GET['lastname'];
    }
    if(!IsEmpty($_GET['group']) && $_GET['group'] != "all") {
        $valid['group'] = array('2', '3');
        if(!in_array($_GET['group'], $valid['group'])) {
            SystemError($translate->__("Invalid Link"), $translate->__("You may have clicked an expired link or mistyped the address."));
        }
        if(empty($whereStatement)) {
            $whereStatement  = " WHERE UserGroup = ".Secure($_GET['group'], 'int');
        }else {
            $whereStatement .= " AND UserGroup = ".Secure($_GET['group'], 'int');
        }
        $paginationURL .= "&group=".$_GET['group'];
    }
    if(!IsEmpty($_GET['username'])) {
        if(empty($whereStatement)) {
            $whereStatement  = " WHERE UserName LIKE ".Secure($_GET['username'], 'search');
        }else {
            $whereStatement .= " AND UserName LIKE ".Secure($_GET['username'], 'search');
        }
        $paginationURL .= "&username=".$_GET['username'];
    }
    if(!IsEmpty($_GET['email'])) {
        if(empty($whereStatement)) {
            $whereStatement  = " WHERE UserEmail LIKE ".Secure($_GET['email'], 'search');
        }else {
            $whereStatement .= " AND UserEmail LIKE ".Secure($_GET['email'], 'search');
        }
        $paginationURL .= "&email=".$_GET['email'];
    }
    if(!IsEmpty($_GET['sex']) && $_GET['sex'] != "either") {
        $valid['sex'] = array('M', 'F');
        if(!in_array($_GET['sex'], $valid['sex'])) {
            SystemError($translate->__("Invalid Link"), $translate->__("You may have clicked an expired link or mistyped the address."));
        }
        if(empty($whereStatement)) {
            $whereStatement  = " WHERE UserSex = ".Secure($_GET['sex']);
        }else {
            $whereStatement .= " AND UserSex = ".Secure($_GET['sex']);
        }
        $paginationURL .= "&sex=".$_GET['sex'];
    }
    if(!IsEmpty($_GET['fb_connected']) && $_GET['fb_connected'] != "either") {
        $valid['fb_connected'] = array('Y', 'N');
        if(!in_array($_GET['fb_connected'], $valid['fb_connected'])) {
            SystemError($translate->__("Invalid Link"), $translate->__("You may have clicked an expired link or mistyped the address."));
        }
        $exp = ($_GET['fb_connected'] == "Y")? "!ISNULL(fb_UserID)" : "ISNULL(fb_UserID)";
        if(empty($whereStatement)) {
            $whereStatement  = " WHERE ".$exp;
        }else {
            $whereStatement .= " AND ".$exp;
        }
        $paginationURL .= "&fb_connected=".$_GET['fb_connected'];
    }
    if(!IsEmpty($_GET['tw_connected']) && $_GET['tw_connected'] != "either") {
        $valid['tw_connected'] = array('Y', 'N');
        if(!in_array($_GET['tw_connected'], $valid['tw_connected'])) {
            SystemError($translate->__("Invalid Link"), $translate->__("You may have clicked an expired link or mistyped the address."));
        }
        $exp = ($_GET['tw_connected'] == "Y")? "!ISNULL(tw_UserID)" : "ISNULL(tw_UserID)";
        if(empty($whereStatement)) {
            $whereStatement  = " WHERE ".$exp;
        }else {
            $whereStatement .= " AND ".$exp;
        }
        $paginationURL .= "&tw_connected=".$_GET['tw_connected'];
    }
    if(!IsEmpty($_GET['blocked']) && $_GET['blocked'] != "either") {
        $valid['blocked'] = array('Y', 'N');
        if(!in_array($_GET['blocked'], $valid['blocked'])) {
            SystemError($translate->__("Invalid Link"), $translate->__("You may have clicked an expired link or mistyped the address."));
        }
        if(empty($whereStatement)) {
            $whereStatement  = " WHERE Blocked = ".Secure($_GET['blocked']);
        }else {
            $whereStatement .= " AND Blocked = ".Secure($_GET['blocked']);
        }
        $paginationURL .= "&blocked=".$_GET['blocked'];
    }
    if(!IsEmpty($_GET['joindate_after'])) {
        if(empty($whereStatement)) {
            $whereStatement  = " WHERE SignupDate > ".Secure(strtotime($_GET['joindate_after']));
        }else {
            $whereStatement .= " AND SignupDate > ".Secure(strtotime($_GET['joindate_after']));
        }
        $paginationURL .= "&joindate_after=".$_GET['joindate_after'];
    }
    if(!IsEmpty($_GET['joindate_before'])) {
        if(empty($whereStatement)) {
            $whereStatement  = " WHERE SignupDate < ".Secure(strtotime($_GET['joindate_before']));
        }else {
            $whereStatement .= " AND SignupDate < ".Secure(strtotime($_GET['joindate_before']));
        }
        $paginationURL .= "&joindate_before=".$_GET['joindate_before'];
    }
    if(!IsEmpty($_GET['lastlogin_after'])) {
        if(empty($whereStatement)) {
            $whereStatement  = " WHERE UserLastLogin > ".Secure(strtotime($_GET['lastlogin_after']));
        }else {
            $whereStatement .= " AND UserLastLogin > ".Secure(strtotime($_GET['lastlogin_after']));
        }
        $paginationURL .= "&lastlogin_after=".$_GET['lastlogin_after'];
    }
    if(!IsEmpty($_GET['lastlogin_before'])) {
        if(empty($whereStatement)) {
            $whereStatement  = " WHERE UserLastLogin < ".Secure(strtotime($_GET['lastlogin_before']));
        }else {
            $whereStatement .= " AND UserLastLogin < ".Secure(strtotime($_GET['lastlogin_before']));
        }
        $paginationURL .= "&lastlogin_before=".$_GET['lastlogin_before'];
    }
    if(!IsEmpty($_GET['posts_gt'])) {
        if(empty($whereStatement)) {
            $whereStatement  = " WHERE UserPosts >= ".Secure($_GET['posts_gt'], 'int');
        }else {
            $whereStatement .= " AND UserPosts >= ".Secure($_GET['posts_gt'], 'int');
        }
        $paginationURL .= "&posts_gt=".$_GET['posts_gt'];
    }
    if(!IsEmpty($_GET['posts_lt'])) {
        if(empty($whereStatement)) {
            $whereStatement  = " WHERE UserPosts < ".Secure($_GET['posts_lt'], 'int');
        }else {
            $whereStatement .= " AND UserPosts < ".Secure($_GET['posts_lt'], 'int');
        }
        $paginationURL .= "&posts_lt=".$_GET['posts_lt'];
    }
    if(!IsEmpty($_GET['ip'])) {
        if(empty($whereStatement)) {
            $whereStatement  = " WHERE UserIP LIKE ".Secure($_GET['ip'], 'search');
        }else {
            $whereStatement .= " AND UserIP LIKE ".Secure($_GET['ip'], 'search');
        }
        $paginationURL .= "&ip=".$_GET['ip'];
    }
    // prepare order statement
    if(!IsEmpty($_GET['order']) && !IsEmpty($_GET['sort'])) {
        $valid['order'] = array('UserID', 'UserName', 'UserEmail', 'SignupDate', 'UserLastLogin', 'UserPosts');
        if(!in_array($_GET['order'], $valid['order'])) {
            SystemError($translate->__("Invalid Link"), $translate->__("You may have clicked an expired link or mistyped the address."));
        }
        $valid['sort'] = array('ASC', 'DESC');
        if(!in_array($_GET['sort'], $valid['sort'])) {
            SystemError($translate->__("Invalid Link"), $translate->__("You may have clicked an expired link or mistyped the address."));
        }
        $orderStatement  = sprintf("ORDER BY %s %s", $_GET['order'], $_GET['sort']);
        $paginationURL .= "&order=".$_GET['order']."&sort=".$_GET['sort'];
    }else {
        $orderStatement = "";
    }
    
    // prepare limit statement
    if(!IsEmpty($_GET['size'])) {
        $size = (int) $_GET['size'];
        $size = ($size == 0) ? 50 : $size;
        $paginationURL .= "&size=".$_GET['size'];
    }else {
        $size = 50;
    }
    
    // prepare pagination
    $spage = (int) $_GET['page'];
    $spage = ($spage == 0) ? 1 : $spage;
    $total = $db->query(sprintf("SELECT * FROM users %s", $whereStatement)) or die('sql error #1');
    $total = $total->num_rows;
    
    require('../libs/class-pagination.php');
    $pagination = new Pagination($spage, $size, $total, SITE_URL.'/admin/users.php?'.$paginationURL."&page=%s");
    $limitStatement = $pagination->getLimitSql();
    $smarty->assign('pager', $pagination->getPagerAdmin());
    
    // get users
    if(empty($whereStatement)) $whereStatement = "";
    $getPeople = $db->query(sprintf("SELECT * FROM users %s %s %s", $whereStatement, $orderStatement, $limitStatement)) or die('sql error #2');
    while($person = $getPeople->fetch_array(MYSQLI_ASSOC)) {
        
        $people[] = $person;
    }
    
    // assign variables
    $smarty->assign('people', $people);
    $smarty->assign('results', $total);
    
}elseif ($_GET['tab'] == "edit") {
    
    $view = "edit";
    
    // check uid
    if(isset($_GET['uid']) && ($_GET['uid'] != 0 || $_GET['uid'] != "")) {
        // get user data
        $getUser = $db->query(sprintf("SELECT * FROM users WHERE UserID = %s", Secure($_GET['uid'], 'int') )) or die("sql error #3");
        if($getUser->num_rows == 0) {
            SystemError($translate->__("This content is currently unavailable"), $translate->__("The page you requested cannot be displayed right now. It may be temporarily unavailable, the link you clicked on may have expired, or you may not have permission to view this page."));
        }
        $profile = $getUser->fetch_array(MYSQLI_ASSOC);
    }else {
        SystemError($translate->__("Invalid Link"), $translate->__("You may have clicked an expired link or mistyped the address."));
    }
    
    if($_GET['modify'] == "basic") {
        if($_POST['submit']) {
            $db->query(sprintf("UPDATE users SET Blocked = %s, Verified = %s, GettingStarted = %s, Updated = %s, Reseted = %s, UserGroup = %s, fb_connected = %s, tw_connected = %s, UserIP = %s WHERE UserID = %s", Secure($_POST['blocked']), Secure($_POST['verified']), Secure($_POST['started']), Secure($_POST['updated']), Secure($_POST['reseted']), Secure($_POST['group']), Secure($_POST['fb_connected']), Secure($_POST['tw_connected']), Secure($_POST['UserIP']), Secure($profile['UserID']) )) or die("sql error #4");
            header('Location: '.SITE_URL.'/admin/users.php?tab=edit&uid='.$profile['UserID']."&saved");
        }
    }elseif ($_GET['modify'] == "name") {
        if($_POST['submit']) {
            $db->query(sprintf("UPDATE users SET UserFirstName = %s, UserLastName = %s WHERE UserID = %s", Secure($_POST['firstname']), Secure($_POST['lastname']), Secure($profile['UserID']) )) or die("sql error #5");
            header('Location: '.SITE_URL.'/admin/users.php?tab=edit&uid='.$profile['UserID']."&saved");
        }
    }elseif ($_GET['modify'] == "username") {
        if($_POST['submit']) {
            $db->query(sprintf("UPDATE users SET UserName = %s WHERE UserID = %s", Secure($_POST['username']), Secure($profile['UserID']) )) or die("sql error #6");
            header('Location: '.SITE_URL.'/admin/users.php?tab=edit&uid='.$profile['UserID']."&saved");
        }
    }elseif ($_GET['modify'] == "email") {
        if($_POST['submit']) {
            $db->query(sprintf("UPDATE users SET UserEmail = %s WHERE UserID = %s", Secure($_POST['email']), Secure($profile['UserID']) )) or die("sql error #7");
            header('Location: '.SITE_URL.'/admin/users.php?tab=edit&uid='.$profile['UserID']."&saved");
        }
    }elseif ($_GET['modify'] == "password") {
        if($_POST['submit']) {
            $db->query(sprintf("UPDATE users SET UserPassword = %s WHERE UserID = %s", Secure(md5($_POST['password'])), Secure($profile['UserID']) )) or die("sql error #8");
            header('Location: '.SITE_URL.'/admin/users.php?tab=edit&uid='.$profile['UserID']."&saved");
        }
    }elseif ($_GET['modify'] == "profile") {
        if($_POST['submit']) {
            $db->query(sprintf("UPDATE users SET UserSex = %s, UserBirthMonth = %s, UserBirthDay = %s, UserBirthYear = %s, UserCountry = %s, UserWebsite = %s, UserBiography = %s WHERE UserID = %s", Secure($_POST['sex']), Secure($_POST['month']), Secure($_POST['day']), Secure($_POST['year']), Secure($_POST['location']), Secure($_POST['website']), Secure($_POST['bio']), Secure($profile['UserID']) )) or die("sql error #9");
            header('Location: '.SITE_URL.'/admin/users.php?tab=edit&uid='.$profile['UserID']."&saved");
        }
    }elseif ($_GET['modify'] == "privacy") {
        if($_POST['submit']) {
            $db->query(sprintf("UPDATE users SET privacyFB = %s, privacyTW = %s WHERE UserID = %s", Secure($_POST['privacyFB']), Secure($_POST['privacyTW']), Secure($profile['UserID']) )) or die("sql error #10");
            header('Location: '.SITE_URL.'/admin/users.php?tab=edit&uid='.$profile['UserID']."&saved");
        }
    }
    
    if(isset($_GET['saved'])) {
        $smarty->assign('highlight', $translate->__("Saved Settings Successfully"));
    }
    
    // assign variables
    $smarty->assign('profile', $profile);
    
}else {
    SystemError($translate->__("Invalid Link"), $translate->__("You may have clicked an expired link or mistyped the address."));
}

// assign variables
$smarty->assign('view', $view);

// page footer
PageFooter("users");

?>