<?php
/**
 * kernal
 * 
 * @package Sngine
 * @author Zamblek
 */

// startup the system
require('../bootstrap.php');

// get security functions
require(ABSPATH.'libs/functions-security.php');

// set language
require(ABSPATH.'libs/class-translation.php');
$translate = new Translator();

// smarty config
require(ABSPATH.'libs/smarty/Smarty.class.php');
$smarty = new Smarty;
$theme = 'admin';
$smarty->template_dir = ABSPATH.'content/themes/'.$theme.'/templates';
$smarty->compile_dir = ABSPATH.'content/themes/'.$theme.'/templates_c';

// get system functions
require(ABSPATH.'libs/functions.php');

// get system settings
$getSystemSetting = $db->query("SELECT * FROM system_settings") or SQLError();
$systemSetting = $getSystemSetting->fetch_array(MYSQLI_ASSOC);

// assign system settings
define('SITE_TITLE', $systemSetting['SystemTitle']);
define('SITE_DESCRIPTION', $systemSetting['SystemDescription']);
define('SITE_DOMAIN', $systemSetting['SystemDescription']);
define('SITE_URL', $systemSetting['SystemURL']);

// set date and time
$now = time();

// set spinner var
$spinner['small'] = SITE_URL."/content/themes/".$theme."/images/buttons/spinner.gif";
$spinner['larg']  = SITE_URL."/content/themes/".$theme."/images/buttons/spinner-larg.gif";

// assign kernal varibles
$smarty->assign('theme', $theme);
$smarty->assign('SITE_URL', SITE_URL);
$smarty->assign('SITE_DOMAIN', SITE_DOMAIN);
$smarty->assign('SITE_TITLE', SITE_TITLE);
$smarty->assign('translate', $translate);
$smarty->assign('spinner', $spinner);
$smarty->assign('systemSetting', $systemSetting);
$smarty->assign('serverHost', $_SERVER["HTTP_HOST"]);
$smarty->assign('year', date('Y'));

// admin config
require(ABSPATH.'libs/class-user.php');
$admin = new User;
$adminExist = $admin->getCookies(true);
if($adminExist) {
    // get user info
    $adminArray = $admin->_userArray;
    // assgin variables
    $smarty->assign('adminArray', $adminArray);
}

// assign variables
$smarty->assign('adminExist', $adminExist);

?>