<?php
/**
 * installer wizard
 * 
 * @package Sngine
 * @author Zamblek
 */

// enviroment setting
error_reporting(E_ALL ^ (E_NOTICE | E_WARNING));

/* the config file doesn't exist - start the installer */
if(file_exists('../libs/config.php')) {
    header('Location: index.php');
}

// get version & system functions
require_once('../libs/version.php');

// get system functions
require('../libs/functions-system.php');

// check php & mysql version
_check_php_mysql_versions();

// get security functions
require('../libs/functions-security.php');

// get libs
require('../libs/smarty/Smarty.class.php');

// smarty config
$smarty = new Smarty;
$theme = 'admin';
$smarty->template_dir = '../content/themes/'.$theme.'/templates';
$smarty->compile_dir = '../content/themes/'.$theme.'/templates_c';

if(!isset($_GET['step']) || $_GET['step'] == "0") {
    
    $step = '0';
    
}elseif($_GET['step'] == "1") {
    
    $step = '1';
    
}elseif($_GET['step'] == "2") {
    
    $step = '2';
    
    if(isset($_POST['submit'])) {
        
        // connect to the db
        $db = new mysqli($_POST['dbhost'], $_POST['uname'], $_POST['pwd'], $_POST['dbname']);
        if(mysqli_connect_error()) {
            _error("Error establishing a database connection", "<p>This either means that the username and password information in your libs/config.php file is incorrect or we can't contact the database server at localhost. This could mean your host's database server is down.</p><br/><p>If you're unsure what these terms mean you should probably contact your host.</p><br/><p><a href='install.php?step=1'>Try again</a></p>");
        }
        
        if(IsEmpty($_POST['title'])) {
            _error("System Error", "<p>You must enter the 'System Title'</p><br/><p><a href='install.php?step=1'>Try again</a></p>");
        }
        
        if(IsEmpty($_POST['domain'])) {
            _error("System Error", "<p>You must enter the 'System Domain'</p><br/><p><a href='install.php?step=1'>Try again</a></p>");
        }
        
        if(IsEmpty($_POST['url'])) {
            _error("System Error", "<p>You must enter the 'System URL'</p><br/><p><a href='install.php?step=1'>Try again</a></p>");
        }
        
        if(IsEmpty($_POST['email'])) {
            _error("System Error", "<p>You must enter the 'Admin Email'</p><br/><p><a href='install.php?step=1'>Try again</a></p>");
        }
        
        if(!ValidEmail($_POST['email'])) {
            _error("System Error", "<p>Please enter a valid email address</p><br/><p><a href='install.php?step=1'>Try again</a></p>");
        }
        
        if(IsEmpty($_POST['username'])) {
            _error("System Error", "<p>You must enter the 'Admin Username'</p><br/><p><a href='install.php?step=1'>Try again</a></p>");
        }
        
        if(!ValidUserName($_POST['username'])) {
            _error("System Error", "<p>Please enter a valid username</p><br/><p><a href='install.php?step=1'>Try again</a></p>");
        }
        
        if(IsEmpty($_POST['password'])) {
            _error("System Error", "<p>You must enter the 'Admin Password'</p><br/><p><a href='install.php?step=1'>Try again</a></p>");
        }
        
        if(strlen($_POST['password']) < 6) {
            _error("System Error", "<p>Your password must be at least 6 characters long. Please try another.</p><br/><p><a href='install.php?step=1'>Try again</a></p>");
        }
        
        if($_POST['password'] != $_POST['confirm']) {
            _error("System Error", "<p>Your password do not match. Please try again.</p><br/><p><a href='install.php?step=1'>Try again</a></p>");
        }
        
        if(IsEmpty($_POST['url'])) {
            _error("System Error", "<p>You must enter the 'System URL'</p><p>System URl is the link for your system so if your script exist here 'http://youdomain.com/' it will be 'http://youdomain.com' - without / at the end - but if your script exist here 'http://youdomain.com/path_to_sngine/' it will be 'http://youdomain.com/path_to_sngine'</p><br/><p><a href='install.php?step=1'>Try again</a></p>");
        }
        
        // create database
        $dbStructure = "
                        --
                        -- Table structure for table `messages`
                        --
                        
                        CREATE TABLE IF NOT EXISTS `messages` (
                          `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
                          `UserID` int(10) unsigned NOT NULL,
                          `Text` text NOT NULL,
                          `Time` varchar(50) NOT NULL,
                          `ConversationID` int(10) unsigned NOT NULL,
                          PRIMARY KEY (`ID`)
                        ) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;
                        
                        -- --------------------------------------------------------
                        
                        --
                        -- Table structure for table `messages_conversations`
                        --
                        
                        CREATE TABLE IF NOT EXISTS `messages_conversations` (
                          `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
                          `Recipients` int(10) unsigned NOT NULL DEFAULT '0',
                          `LastMessage` varchar(255) NOT NULL,
                          `LastSenderID` int(10) unsigned NOT NULL,
                          `LastUpdate` varchar(50) NOT NULL,
                          `IsChat` enum('Y','N') NOT NULL DEFAULT 'N',
                          PRIMARY KEY (`ID`)
                        ) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;
                        
                        -- --------------------------------------------------------
                        
                        --
                        -- Table structure for table `messages_conversations_users`
                        --
                        
                        CREATE TABLE IF NOT EXISTS `messages_conversations_users` (
                          `ConversationID` int(10) unsigned NOT NULL,
                          `UserID` int(10) unsigned NOT NULL,
                          `Messages` int(10) unsigned NOT NULL DEFAULT '1',
                          `Viewed` enum('Y','N') NOT NULL DEFAULT 'N',
                          `Deleted` enum('Y','N') NOT NULL DEFAULT 'N',
                          UNIQUE KEY `ConversationID_UserID` (`ConversationID`,`UserID`)
                        ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
                        
                        -- --------------------------------------------------------
                        
                        --
                        -- Table structure for table `messages_users`
                        --
                        
                        CREATE TABLE IF NOT EXISTS `messages_users` (
                          `MessageID` int(10) unsigned NOT NULL,
                          `UserID` int(10) unsigned NOT NULL,
                          `Deleted` enum('Y','N') NOT NULL DEFAULT 'N',
                          UNIQUE KEY `MessageID_UserID` (`MessageID`,`UserID`)
                        ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
                        
                        -- --------------------------------------------------------
                        
                        --
                        -- Table structure for table `notifications`
                        --
                        
                        CREATE TABLE IF NOT EXISTS `notifications` (
                          `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
                          `UserID` int(10) unsigned NOT NULL,
                          `Action` tinyint(1) unsigned NOT NULL,
                          `AuthorID` int(10) unsigned NOT NULL,
                          `PostType` tinyint(3) unsigned DEFAULT NULL,
                          `PostID` int(10) unsigned DEFAULT NULL,
                          `Type` enum('P','C','A') NOT NULL DEFAULT 'P',
                          `IsMedia` enum('Y','N') NOT NULL DEFAULT 'N',
                          `IsAlbum` enum('Y','N') NOT NULL DEFAULT 'N',
                          `Time` varchar(25) NOT NULL,
                          `Viewed` enum('Y','N') NOT NULL DEFAULT 'N',
                          PRIMARY KEY (`ID`)
                        ) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;
                        
                        -- --------------------------------------------------------
                        
                        --
                        -- Table structure for table `posts`
                        --
                        
                        CREATE TABLE IF NOT EXISTS `posts` (
                          `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
                          `UserID` int(10) unsigned NOT NULL,
                          `PostType` tinyint(1) unsigned NOT NULL,
                          `PostID` int(10) unsigned NOT NULL,
                          `Time` varchar(25) NOT NULL,
                          `Favorits` int(10) unsigned NOT NULL DEFAULT '0',
                          `Likes` int(10) unsigned NOT NULL DEFAULT '0',
                          `Dislikes` int(10) unsigned NOT NULL DEFAULT '0',
                          `Comments` int(10) unsigned NOT NULL DEFAULT '0',
                          `PComments` int(10) unsigned NOT NULL DEFAULT '0',
                          PRIMARY KEY (`ID`),
                          UNIQUE KEY `PostType_PostID` (`PostType`,`PostID`)
                        ) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;
                        
                        -- --------------------------------------------------------
                        
                        --
                        -- Table structure for table `posts_comments`
                        --
                        
                        CREATE TABLE IF NOT EXISTS `posts_comments` (
                          `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
                          `UserID` int(10) unsigned NOT NULL,
                          `PostType` tinyint(1) NOT NULL,
                          `PostID` int(10) unsigned NOT NULL,
                          `Text` text NOT NULL,
                          `Time` varchar(25) NOT NULL,
                          `Replies` int(10) unsigned NOT NULL DEFAULT '0',
                          `ParentNodeID` int(10) unsigned NOT NULL DEFAULT '0',
                          `Likes` int(10) unsigned NOT NULL DEFAULT '0',
                          `Dislikes` int(10) unsigned NOT NULL DEFAULT '0',
                          PRIMARY KEY (`ID`)
                        ) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;
                        
                        -- --------------------------------------------------------
                        
                        --
                        -- Table structure for table `posts_comments_media`
                        --
                        
                        CREATE TABLE IF NOT EXISTS `posts_comments_media` (
                          `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
                          `UserID` int(10) unsigned NOT NULL,
                          `PostType` tinyint(1) NOT NULL,
                          `IsAlbum` enum('Y','N') NOT NULL,
                          `MediaID` int(10) unsigned NOT NULL,
                          `Text` text NOT NULL,
                          `Time` varchar(25) NOT NULL,
                          `Replies` int(10) unsigned NOT NULL DEFAULT '0',
                          `ParentNodeID` int(10) unsigned NOT NULL DEFAULT '0',
                          `Likes` int(10) unsigned NOT NULL DEFAULT '0',
                          `Dislikes` int(10) unsigned NOT NULL DEFAULT '0',
                          PRIMARY KEY (`ID`)
                        ) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;
                        
                        -- --------------------------------------------------------
                        
                        --
                        -- Table structure for table `posts_discussions`
                        --
                        
                        CREATE TABLE IF NOT EXISTS `posts_discussions` (
                          `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
                          `Title` varchar(255) NOT NULL,
                          `Text` text NOT NULL,
                          PRIMARY KEY (`ID`)
                        ) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;
                        
                        -- --------------------------------------------------------
                        
                        --
                        -- Table structure for table `posts_links`
                        --
                        
                        CREATE TABLE IF NOT EXISTS `posts_links` (
                          `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
                          `Title` varchar(255) NOT NULL,
                          `URL` text NOT NULL,
                          `Host` varchar(100) NOT NULL,
                          `Description` text NOT NULL,
                          `Text` text NOT NULL,
                          `Thumbnail` varchar(255) DEFAULT NULL,
                          PRIMARY KEY (`ID`)
                        ) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;
                        
                        -- --------------------------------------------------------
                        
                        --
                        -- Table structure for table `posts_mentions`
                        --
                        
                        CREATE TABLE IF NOT EXISTS `posts_mentions` (
                          `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
                          `PostID` int(10) unsigned NOT NULL,
                          `MentionID` int(10) unsigned NOT NULL,
                          `IsUser` enum('Y','N') DEFAULT 'Y',
                          PRIMARY KEY (`ID`)
                        ) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;
                        
                        -- --------------------------------------------------------
                        
                        --
                        -- Table structure for table `posts_news`
                        --
                        
                        CREATE TABLE IF NOT EXISTS `posts_news` (
                          `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
                          `Text` text NOT NULL,
                          PRIMARY KEY (`ID`)
                        ) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;
                        
                        -- --------------------------------------------------------
                        
                        --
                        -- Table structure for table `posts_photos`
                        --
                        
                        CREATE TABLE IF NOT EXISTS `posts_photos` (
                          `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
                          `IsAlbum` enum('Y','N') NOT NULL,
                          `MediaID` int(10) unsigned NOT NULL,
                          PRIMARY KEY (`ID`)
                        ) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;
                        
                        -- --------------------------------------------------------
                        
                        --
                        -- Table structure for table `posts_photos_albums`
                        --
                        
                        CREATE TABLE IF NOT EXISTS `posts_photos_albums` (
                          `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
                          `UserID` int(10) unsigned NOT NULL,
                          `IsWall` enum('Y','N') NOT NULL,
                          `Title` varchar(255) NOT NULL,
                          `Text` text NOT NULL,
                          `Time` varchar(25) NOT NULL,
                          `ThumbnailID` int(10) unsigned NOT NULL DEFAULT '0',
                          `New` int(10) unsigned NOT NULL DEFAULT '0',
                          `Total` int(10) unsigned NOT NULL DEFAULT '0',
                          `Favorits` int(10) unsigned NOT NULL DEFAULT '0',
                          `Likes` int(10) unsigned NOT NULL DEFAULT '0',
                          `Dislikes` int(10) unsigned NOT NULL DEFAULT '0',
                          `Comments` int(10) unsigned NOT NULL DEFAULT '0',
                          `PComments` int(10) unsigned NOT NULL DEFAULT '0',
                          PRIMARY KEY (`ID`)
                        ) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;
                        
                        -- --------------------------------------------------------
                        
                        --
                        -- Table structure for table `posts_photos_sources`
                        --
                        
                        CREATE TABLE IF NOT EXISTS `posts_photos_sources` (
                          `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
                          `AlbumID` int(10) unsigned NOT NULL,
                          `Source` varchar(255) NOT NULL,
                          `Thumbnail` varchar(255) NOT NULL,
                          `Text` text NOT NULL,
                          `Time` varchar(25) NOT NULL,
                          `Favorits` int(10) unsigned NOT NULL DEFAULT '0',
                          `Likes` int(10) unsigned NOT NULL DEFAULT '0',
                          `Dislikes` int(10) unsigned NOT NULL DEFAULT '0',
                          `Comments` int(10) unsigned NOT NULL DEFAULT '0',
                          `PComments` int(10) unsigned NOT NULL DEFAULT '0',
                          PRIMARY KEY (`ID`)
                        ) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;
                        
                        -- --------------------------------------------------------
                        
                        --
                        -- Table structure for table `posts_polls`
                        --
                        
                        CREATE TABLE IF NOT EXISTS `posts_polls` (
                          `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
                          `Question` varchar(255) NOT NULL,
                          `Votes` int(10) unsigned NOT NULL DEFAULT '0',
                          PRIMARY KEY (`ID`)
                        ) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;
                        
                        -- --------------------------------------------------------
                        
                        --
                        -- Table structure for table `posts_polls_options`
                        --
                        
                        CREATE TABLE IF NOT EXISTS `posts_polls_options` (
                          `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
                          `Title` varchar(255) NOT NULL,
                          `PollID` int(10) unsigned NOT NULL,
                          `Votes` int(10) unsigned NOT NULL DEFAULT '0',
                          PRIMARY KEY (`ID`)
                        ) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;
                        
                        -- --------------------------------------------------------
                        
                        --
                        -- Table structure for table `posts_questions`
                        --
                        
                        CREATE TABLE IF NOT EXISTS `posts_questions` (
                          `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
                          `Title` varchar(255) NOT NULL,
                          `Text` text NOT NULL,
                          `Answers` int(10) unsigned NOT NULL DEFAULT '0',
                          PRIMARY KEY (`ID`)
                        ) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;
                        
                        -- --------------------------------------------------------
                        
                        --
                        -- Table structure for table `posts_questions_answers`
                        --
                        
                        CREATE TABLE IF NOT EXISTS `posts_questions_answers` (
                          `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
                          `UserID` int(10) unsigned NOT NULL,
                          `Text` text NOT NULL,
                          `Time` varchar(25) NOT NULL,
                          `Votes` int(10) NOT NULL DEFAULT '0',
                          `Notes` int(10) unsigned NOT NULL DEFAULT '0',
                          `QuestionID` int(10) unsigned NOT NULL,
                          PRIMARY KEY (`ID`)
                        ) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;
                        
                        -- --------------------------------------------------------
                        
                        --
                        -- Table structure for table `posts_questions_notes`
                        --
                        
                        CREATE TABLE IF NOT EXISTS `posts_questions_notes` (
                          `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
                          `UserID` int(10) unsigned NOT NULL,
                          `Text` text NOT NULL,
                          `Time` varchar(25) NOT NULL,
                          `AnswerID` int(10) unsigned NOT NULL,
                          PRIMARY KEY (`ID`)
                        ) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;
                        
                        -- --------------------------------------------------------
                        
                        --
                        -- Table structure for table `posts_tracks`
                        --
                        
                        CREATE TABLE IF NOT EXISTS `posts_tracks` (
                          `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
                          `Source` int(10) unsigned NOT NULL,
                          `Title` varchar(255) NOT NULL,
                          `Description` varchar(255) NOT NULL,
                          `Text` text NOT NULL,
                          PRIMARY KEY (`ID`)
                        ) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;
                        
                        -- --------------------------------------------------------
                        
                        --
                        -- Table structure for table `posts_videos`
                        --
                        
                        CREATE TABLE IF NOT EXISTS `posts_videos` (
                          `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
                          `IsAlbum` enum('Y','N') NOT NULL,
                          `MediaID` int(10) unsigned NOT NULL,
                          PRIMARY KEY (`ID`)
                        ) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;
                        
                        -- --------------------------------------------------------
                        
                        --
                        -- Table structure for table `posts_videos_albums`
                        --
                        
                        CREATE TABLE IF NOT EXISTS `posts_videos_albums` (
                          `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
                          `UserID` int(10) unsigned NOT NULL,
                          `IsWall` enum('Y','N') NOT NULL,
                          `Title` varchar(255) NOT NULL,
                          `Text` text NOT NULL,
                          `Time` varchar(25) NOT NULL,
                          `ThumbnailID` int(10) unsigned NOT NULL DEFAULT '0',
                          `New` int(10) unsigned NOT NULL DEFAULT '0',
                          `Total` int(10) unsigned NOT NULL DEFAULT '0',
                          `Favorits` int(10) unsigned NOT NULL DEFAULT '0',
                          `Likes` int(10) unsigned NOT NULL DEFAULT '0',
                          `Dislikes` int(10) unsigned NOT NULL DEFAULT '0',
                          `Comments` int(10) unsigned NOT NULL DEFAULT '0',
                          `PComments` int(10) unsigned NOT NULL DEFAULT '0',
                          PRIMARY KEY (`ID`)
                        ) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;
                        
                        -- --------------------------------------------------------
                        
                        --
                        -- Table structure for table `posts_videos_sources`
                        --
                        
                        CREATE TABLE IF NOT EXISTS `posts_videos_sources` (
                          `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
                          `AlbumID` int(10) unsigned NOT NULL,
                          `Source` varchar(255) NOT NULL,
                          `Type` varchar(25) NOT NULL,
                          `Thumbnail` varchar(255) NOT NULL,
                          `Text` text NOT NULL,
                          `Time` varchar(25) NOT NULL,
                          `Favorits` int(10) unsigned NOT NULL DEFAULT '0',
                          `Likes` int(10) unsigned NOT NULL DEFAULT '0',
                          `Dislikes` int(10) unsigned NOT NULL DEFAULT '0',
                          `Comments` int(10) unsigned NOT NULL DEFAULT '0',
                          `PComments` int(10) unsigned NOT NULL DEFAULT '0',
                          PRIMARY KEY (`ID`)
                        ) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;
                        
                        -- --------------------------------------------------------
                        
                        --
                        -- Table structure for table `system_errors`
                        --
                        
                        CREATE TABLE IF NOT EXISTS `system_errors` (
                          `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
                          `Error` text NOT NULL,
                          `Time` varchar(100) NOT NULL,
                          PRIMARY KEY (`ID`)
                        ) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;
                        
                        -- --------------------------------------------------------
                        
                        --
                        -- Table structure for table `system_languages`
                        --
                        
                        CREATE TABLE IF NOT EXISTS `system_languages` (
                          `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
                          `Title` varchar(255) NOT NULL,
                          `Translation` varchar(255) NOT NULL,
                          `Code` varchar(255) NOT NULL,
                          `Dir` enum('LTR','RTL') NOT NULL DEFAULT 'LTR',
                          PRIMARY KEY (`ID`)
                        ) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;
                        
                        --
                        -- Dumping data for table `system_languages`
                        --
                        
                        INSERT INTO `system_languages` (`ID`, `Title`, `Translation`, `Code`, `Dir`) VALUES
                        (1, 'English', 'English', 'EN', 'LTR'),
                        (2, 'Arabic', 'Arabic', 'AR', 'RTL');
                        
                        -- --------------------------------------------------------
                        
                        --
                        -- Table structure for table `system_settings`
                        --
                        
                        CREATE TABLE IF NOT EXISTS `system_settings` (
                          `SystemLive` enum('Y','N') NOT NULL,
                          `SystemMessage` text NOT NULL,
                          `RegistrationLive` enum('Y','N') NOT NULL,
                          `SystemTitle` varchar(255) NOT NULL,
                          `SystemDescription` text NOT NULL,
                          `SystemDomain` varchar(255) NOT NULL,
                          `SystemURL` varchar(255) NOT NULL,
                          `RECAPTCHA_PUBLICKEY` text NOT NULL,
                          `RECAPTCHA_PRIVATEKEY` text NOT NULL,
                          `TW_APPID` text NOT NULL,
                          `TW_SECRET` text NOT NULL,
                          `FB_APPID` text NOT NULL,
                          `FB_SECRET` text NOT NULL,
                          `MaxResults` tinyint(1) NOT NULL DEFAULT '10',
                          `MaxFeeds` tinyint(1) NOT NULL DEFAULT '10',
                          `MaxMediaFeeds` tinyint(1) NOT NULL DEFAULT '24',
                          `MaxQComments` tinyint(1) NOT NULL DEFAULT '10',
                          `MaxQCommentsViewed` tinyint(1) NOT NULL DEFAULT '3',
                          `MaxComments` tinyint(1) NOT NULL DEFAULT '10',
                          `MaxReplies` tinyint(1) NOT NULL DEFAULT '5',
                          `MaxAnswers` tinyint(1) NOT NULL DEFAULT '10',
                          `MaxNotes` tinyint(1) NOT NULL DEFAULT '5',
                          `MaxWho` tinyint(1) NOT NULL DEFAULT '100',
                          `MaxPeople` tinyint(1) NOT NULL DEFAULT '20',
                          `MaxConversations` tinyint(1) NOT NULL DEFAULT '10'
                        ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
                        
                        --
                        -- Dumping data for table `system_settings`
                        --
                        
                        INSERT INTO `system_settings` (`SystemLive`, `SystemMessage`, `RegistrationLive`, `SystemTitle`, `SystemDescription`, `SystemDomain`, `SystemURL`, `RECAPTCHA_PUBLICKEY`, `RECAPTCHA_PRIVATEKEY`, `TW_APPID`, `TW_SECRET`, `FB_APPID`, `FB_SECRET`, `MaxResults`, `MaxFeeds`, `MaxMediaFeeds`, `MaxQComments`, `MaxQCommentsViewed`, `MaxComments`, `MaxReplies`, `MaxAnswers`, `MaxNotes`, `MaxWho`, `MaxPeople`, `MaxConversations`) VALUES
                        ('Y', 'We will back soon', 'Y', '', '', '', '', '', '', '', '', '', '', 10, 10, 12, 10, 3, 5, 5, 5, 5, 50, 10, 10);
                        
                        -- --------------------------------------------------------
                        
                        --
                        -- Table structure for table `users`
                        --
                        
                        CREATE TABLE IF NOT EXISTS `users` (
                          `UserID` int(10) unsigned NOT NULL AUTO_INCREMENT,
                          `UserEmail` varchar(255) NOT NULL,
                          `UserName` varchar(255) NOT NULL,
                          `UserToken` varchar(255) NOT NULL,
                          `UserPassword` varchar(255) NOT NULL,
                          `UserGroup` tinyint(1) unsigned NOT NULL DEFAULT '3',
                          `fb_UserID` varchar(255) DEFAULT NULL,
                          `fb_UserName` varchar(255) DEFAULT NULL,
                          `fb_Token` varchar(255) DEFAULT NULL,
                          `fb_connected` enum('Y','N') NOT NULL DEFAULT 'N',
                          `tw_UserID` int(10) unsigned DEFAULT NULL,
                          `tw_Token` varchar(200) DEFAULT NULL,
                          `tw_UserName` varchar(200) DEFAULT NULL,
                          `tw_TokenSecret` varchar(200) DEFAULT NULL,
                          `tw_connected` enum('Y','N') NOT NULL DEFAULT 'N',
                          `UserFirstName` varchar(200) NOT NULL,
                          `UserLastName` varchar(200) NOT NULL,
                          `UserAvatarPath` varchar(200) NOT NULL DEFAULT 'content/themes/default/images/misc/no_avatar.jpg',
                          `UserAvatarPathMedium` varchar(200) NOT NULL DEFAULT 'content/themes/default/images/misc/no_avatar_medium.jpg',
                          `UserAvatarPathSmall` varchar(200) NOT NULL DEFAULT 'content/themes/default/images/misc/no_avatar_small.jpg',
                          `UserSex` enum('M','F') NOT NULL,
                          `UserBirthMonth` int(10) unsigned NOT NULL,
                          `UserBirthDay` int(10) unsigned NOT NULL,
                          `UserBirthYear` int(10) unsigned NOT NULL,
                          `UserCountry` varchar(25) NOT NULL,
                          `UserWebsite` varchar(255) NOT NULL,
                          `UserBiography` varchar(255) NOT NULL,
                          `privacyFB` enum('Y','N') NOT NULL DEFAULT 'N',
                          `privacyTW` enum('Y','N') NOT NULL DEFAULT 'N',
                          `UserWallPhotos` int(10) unsigned NOT NULL,
                          `UserWallVideos` int(10) unsigned NOT NULL,
                          `UserPosts` int(10) unsigned NOT NULL DEFAULT '0',
                          `UserFollowings` int(10) unsigned NOT NULL DEFAULT '0',
                          `UserFollowers` int(10) unsigned NOT NULL DEFAULT '0',
                          `UserMessages` int(10) unsigned NOT NULL DEFAULT '0',
                          `UserNewMessages` int(10) unsigned NOT NULL DEFAULT '0',
                          `UserMessaged` enum('Y','N') NOT NULL DEFAULT 'N',
                          `UserNotifications` int(10) unsigned NOT NULL DEFAULT '0',
                          `UserNewNotifications` int(10) unsigned NOT NULL DEFAULT '0',
                          `UserNotified` enum('Y','N') NOT NULL DEFAULT 'N',
                          `UserIP` varchar(50) NOT NULL,
                          `UserLastLogin` varchar(25) NOT NULL,
                          `SignupDate` varchar(25) NOT NULL,
                          `Verified` enum('Y','N') NOT NULL DEFAULT 'N',
                          `ActivationCode` varchar(200) NOT NULL,
                          `GettingStarted` enum('Y','N') NOT NULL DEFAULT 'N',
                          `Reseted` enum('Y','N') NOT NULL DEFAULT 'N',
                          `ResetCode` varchar(200) NOT NULL,
                          `Blocked` enum('Y','N') NOT NULL DEFAULT 'N',
                          `Offline` enum('Y','N') NOT NULL DEFAULT 'N',
                          PRIMARY KEY (`UserID`),
                          UNIQUE KEY `UserEmail` (`UserEmail`),
                          UNIQUE KEY `UserToken` (`UserToken`),
                          UNIQUE KEY `UserName` (`UserName`),
                          UNIQUE KEY `tw_UserID` (`tw_UserID`),
                          UNIQUE KEY `fb_UserID` (`fb_UserID`)
                        ) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;
                        
                        -- --------------------------------------------------------
                        
                        --
                        -- Table structure for table `users_answers_votes`
                        --
                        
                        CREATE TABLE IF NOT EXISTS `users_answers_votes` (
                          `UserID` int(10) unsigned NOT NULL,
                          `AnswerID` int(10) unsigned NOT NULL,
                          `Voted` enum('U','D') NOT NULL,
                          UNIQUE KEY `UserID_AnswerID` (`UserID`,`AnswerID`)
                        ) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED;
                        
                        -- --------------------------------------------------------
                        
                        --
                        -- Table structure for table `users_comments_likes`
                        --
                        
                        CREATE TABLE IF NOT EXISTS `users_comments_likes` (
                          `UserID` int(10) unsigned NOT NULL,
                          `CommentID` int(10) unsigned NOT NULL,
                          `Liked` enum('Y','N') NOT NULL,
                          UNIQUE KEY `UserID_CommentID` (`UserID`,`CommentID`)
                        ) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED;
                        
                        -- --------------------------------------------------------
                        
                        --
                        -- Table structure for table `users_comments_media_likes`
                        --
                        
                        CREATE TABLE IF NOT EXISTS `users_comments_media_likes` (
                          `UserID` int(10) unsigned NOT NULL,
                          `CommentID` int(10) unsigned NOT NULL,
                          `Liked` enum('Y','N') NOT NULL,
                          UNIQUE KEY `UserID_CommentID` (`UserID`,`CommentID`)
                        ) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED;
                        
                        -- --------------------------------------------------------
                        
                        --
                        -- Table structure for table `users_followings`
                        --
                        
                        CREATE TABLE IF NOT EXISTS `users_followings` (
                          `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
                          `UserID` int(10) unsigned NOT NULL,
                          `FollowingID` int(10) unsigned NOT NULL,
                          PRIMARY KEY (`ID`),
                          UNIQUE KEY `UserID_FollowingID` (`UserID`,`FollowingID`)
                        ) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;
                        
                        -- --------------------------------------------------------
                        
                        --
                        -- Table structure for table `users_hidden_posts`
                        --
                        
                        CREATE TABLE IF NOT EXISTS `users_hidden_posts` (
                          `UserID` int(10) unsigned NOT NULL,
                          `ActivityID` int(10) unsigned NOT NULL,
                          PRIMARY KEY (`UserID`,`ActivityID`)
                        ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
                        
                        -- --------------------------------------------------------
                        
                        --
                        -- Table structure for table `users_hidden_users`
                        --
                        
                        CREATE TABLE IF NOT EXISTS `users_hidden_users` (
                          `UserID` int(10) unsigned NOT NULL,
                          `HiddenID` int(10) unsigned NOT NULL,
                          PRIMARY KEY (`UserID`,`HiddenID`)
                        ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
                        
                        -- --------------------------------------------------------
                        
                        --
                        -- Table structure for table `users_media_favorites`
                        --
                        
                        CREATE TABLE IF NOT EXISTS `users_media_favorites` (
                          `UserID` int(10) unsigned NOT NULL,
                          `PostType` tinyint(1) unsigned NOT NULL,
                          `IsAlbum` enum('Y','N') NOT NULL,
                          `MediaID` int(10) unsigned NOT NULL,
                          `Favorited` enum('Y','N') NOT NULL DEFAULT 'N',
                          UNIQUE KEY `UserID_PostType_IsAlbum_MediaID` (`UserID`,`PostType`,`IsAlbum`,`MediaID`)
                        ) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED;
                        
                        -- --------------------------------------------------------
                        
                        --
                        -- Table structure for table `users_media_likes`
                        --
                        
                        CREATE TABLE IF NOT EXISTS `users_media_likes` (
                          `UserID` int(10) unsigned NOT NULL,
                          `PostType` tinyint(1) unsigned NOT NULL,
                          `IsAlbum` enum('Y','N') NOT NULL,
                          `MediaID` int(10) unsigned NOT NULL,
                          `Liked` enum('Y','N') NOT NULL,
                          UNIQUE KEY `UserID_PostType_IsAlbum_MediaID` (`UserID`,`PostType`,`IsAlbum`,`MediaID`)
                        ) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED;
                        
                        -- --------------------------------------------------------
                        
                        --
                        -- Table structure for table `users_online`
                        --
                        
                        CREATE TABLE IF NOT EXISTS `users_online` (
                          `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
                          `UserID` int(10) unsigned DEFAULT NULL,
                          `IP` varchar(255) DEFAULT NULL,
                          `Time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
                          PRIMARY KEY (`ID`),
                          UNIQUE KEY `UserID` (`UserID`),
                          UNIQUE KEY `IP` (`IP`)
                        ) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;
                        
                        -- --------------------------------------------------------
                        
                        --
                        -- Table structure for table `users_polls_options`
                        --
                        
                        CREATE TABLE IF NOT EXISTS `users_polls_options` (
                          `UserID` int(10) unsigned NOT NULL,
                          `PollID` int(10) unsigned NOT NULL,
                          `OptionID` int(10) unsigned NOT NULL,
                          UNIQUE KEY `UserID_PollID` (`UserID`,`PollID`)
                        ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
                        
                        -- --------------------------------------------------------
                        
                        --
                        -- Table structure for table `users_posts_favorites`
                        --
                        
                        CREATE TABLE IF NOT EXISTS `users_posts_favorites` (
                          `UserID` int(10) unsigned NOT NULL,
                          `PostType` tinyint(1) unsigned NOT NULL,
                          `PostID` int(10) unsigned NOT NULL,
                          `Favorited` enum('Y','N') NOT NULL DEFAULT 'N',
                          UNIQUE KEY `UserID_PostType_PostID` (`UserID`,`PostType`,`PostID`)
                        ) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED;
                        
                        -- --------------------------------------------------------
                        
                        --
                        -- Table structure for table `users_posts_likes`
                        --
                        
                        CREATE TABLE IF NOT EXISTS `users_posts_likes` (
                          `UserID` int(10) unsigned NOT NULL,
                          `PostType` tinyint(1) unsigned NOT NULL,
                          `PostID` int(10) unsigned NOT NULL,
                          `Liked` enum('Y','N') NOT NULL,
                          UNIQUE KEY `UserID_PostType_PostID` (`UserID`,`PostType`,`PostID`)
                        ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
                        
                        -- --------------------------------------------------------
                        
                        --
                        -- Table structure for table `users_spammers`
                        --
                        
                        CREATE TABLE IF NOT EXISTS `users_spammers` (
                          `UserID` int(10) unsigned NOT NULL,
                          `SpammerID` int(10) unsigned NOT NULL,
                          PRIMARY KEY (`UserID`,`SpammerID`)
                        ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
                        
                        ";
        
        
        $db->multi_query($dbStructure) or _error("System Error", $db->error);
        // flush multi_queries
        while ($db->next_result()) {;}
        
        /** save system settings */
        
        // update system settings
        $db->query(sprintf("UPDATE system_settings SET SystemTitle = %s, SystemDomain = %s, SystemURL = %s, RECAPTCHA_PUBLICKEY = %s, RECAPTCHA_PRIVATEKEY = %s", Secure($_POST['title']), Secure($_POST['domain']), Secure($_POST['url']), Secure($_POST['RECAPTCHA_PUBLICKEY']), Secure($_POST['RECAPTCHA_PRIVATEKEY']) )) or _error("System Error 0", $db->error);
        
        
        /** register the admin */
        
        // create token
        $code = md5(time()*rand(1, 9999));
        
        // insert admin
        $db->query(sprintf("INSERT INTO users (UserGroup, UserEmail, UserName, UserToken, UserFirstName, UserLastName, UserPassword, Verified, GettingStarted, SignupDate, UserIP) VALUES ('1', %s, %s, %s, %s, %s, %s, 'Y', 'Y', %s, %s)", Secure($_POST['email']), Secure($_POST['username']), Secure($code), Secure(ucwords($_POST['firstname'])), Secure(ucwords($_POST['lastname'])), Secure(md5($_POST['password'])), Secure(time()), Secure($_SERVER[REMOTE_ADDR]) )) or _error("System Error 1", $db->error);
        
        // get userid
        $userId = $db->insert_id;
        
        // create media albums
        $db->query(sprintf("INSERT INTO posts_photos_albums (UserID, IsWall, Title, Time) VALUES (%s, 'Y', 'Wall Photos', %s)", Secure($userId, 'int'), Secure($now) ));
        $wallPhotos = $db->insert_id;
        $db->query(sprintf("INSERT INTO posts_videos_albums (UserID, IsWall, Title, Time) VALUES (%s, 'Y', 'Wall Videos', %s)", Secure($userId, 'int'), Secure($now) ));
        $wallVideos = $db->insert_id;
        $db->query(sprintf("UPDATE users SET UserWallPhotos = %s, UserWallVideos = %s WHERE UserID = %s", Secure($wallPhotos, 'int'), Secure($wallVideos, 'int'), Secure($userId, 'int') ));
        
        $configString = '<?php  
        
        define("DB_NAME", "'. $_POST["dbname"]. '");
        define("DB_USER", "'. $_POST["uname"]. '");
        define("DB_PASSWORD", "'. $_POST["pwd"]. '");
        define("DB_HOST", "'. $_POST["dbhost"]. '");
        define("DEBUGGING", "'. $_POST["debugging"]. '");
        
        ?>';
        
        $configFile = '../libs/config.php';
        $handle = fopen($configFile, 'w') or _error("System Error", "Cannot create the config file");
        
        fwrite($handle, $configString);
        fclose($handle);
        
        header('Location: index.php');
        
    }else {
        _error();
    }
    
}else {
    _error();
}

// assign varibles
$smarty->assign('step', $step);
$smarty->assign('domain', $_SERVER['HTTP_HOST']);
$smarty->assign('public_base', _public_base_directory());

// display
$smarty->display("install.tpl");

?>