<?php
/**
 * music app
 * 
 * @package Sngine
 * @author Zamblek
 */

// fetch kernal
require('kernal.php');

// check access level
AccessLevel();

// check data ID
if(!isset($_GET['id']) || $_GET['id'] == 0 || $_GET['id'] == "") {
    SystemError($translate->__("Invalid Link"), $translate->__("You may have clicked an expired link or mistyped the address."));
}else {
    // get post
    $getPost = $db->query(sprintf("SELECT track.*, post.*, user.UserName, user.UserFirstName, user.UserLastName, user.UserAvatarPathMedium AS UserAvatarPath FROM posts_tracks track INNER JOIN posts post ON track.ID = post.PostID AND post.PostType = 2 INNER JOIN users user ON post.UserID = user.UserID WHERE post.PostID = %s", SafeSQL($_GET['id'], 'int') )) or SQLError();
    if($getPost->num_rows == 0) {
        SystemError($translate->__("This content is currently unavailable"), $translate->__("The page you requested cannot be displayed right now. It may be temporarily unavailable, the link you clicked on may have expired, or you may not have permission to view this page."));
    }
    $post = $getPost->fetch_array(MYSQLI_ASSOC);
}

// decode text
$post['Text'] = DecodeText($post['Text']);

// page header
PageHeader($post['Title'], strip_tags($post['Text']." - ".$post['Title']." - ".$post['Description']));

// check if user favorited this post before
$getPostStatus = $db->query(sprintf("SELECT Favorited FROM users_posts_favorites WHERE UserID = %s AND PostType = %s AND PostID = %s", SafeSQL($userArray['UserID'], 'int'), SafeSQL($post['PostType'], 'int'), SafeSQL($post['PostID'], 'int') )) or SQLError();
if($getPostStatus->num_rows > 0) {
    $post['favorited'] = true;
}else {
    $post['favorited'] = false;
}

// check if user liked|disliked this post before
$getPostStatus = $db->query(sprintf("SELECT Liked FROM users_posts_likes WHERE UserID = %s AND PostType = %s AND PostID = %s", SafeSQL($userArray['UserID'], 'int'), SafeSQL($post['PostType'], 'int'), SafeSQL($post['PostID'], 'int') )) or SQLError();
if($getPostStatus->num_rows > 0) {
    $postStatus = $getPostStatus->fetch_array(MYSQLI_ASSOC);
    $post['liked'] = $postStatus['Liked'];
}

// get comments
if($post['Comments'] > 0) {
    // prepare where statement
    if(count($userBlockedUsers) > 0) {
        $whereStatement = ' AND comm.UserID NOT IN (' . implode(',', $userBlockedUsers) . ')';
    }
    $post['prevComments'] = ($post['PComments'] > $systemSetting['MaxComments'])? $post['PComments'] - $systemSetting['MaxComments']: 0;
    $getComments = $db->query(sprintf("SELECT comm.*, user.UserName, user.UserFirstName, user.UserLastName, user.UserAvatarPathMedium AS UserAvatarPath FROM posts_comments comm INNER JOIN users user ON comm.UserID = user.UserID WHERE comm.PostType = %s AND comm.PostID = %s AND comm.ParentNodeID = 0 ".$whereStatement." ORDER BY comm.Time ASC LIMIT %s,".$systemSetting['MaxComments'], SafeSQL($post['PostType'], 'int'), SafeSQL($post['PostID'], 'int'), $post['prevComments'] )) or SQLError();
    while($comment = $getComments->fetch_array(MYSQLI_ASSOC)) {
        // get Replies
        if($comment['Replies'] > 0) {
            $comment['prevReplies'] = ($comment['Replies'] > $systemSetting['MaxReplies'])? $comment['Replies'] - $systemSetting['MaxReplies']: 0;
            $getReplies = $db->query(sprintf("SELECT comm.*, user.UserName, user.UserFirstName, user.UserLastName, user.UserAvatarPathMedium AS UserAvatarPath FROM posts_comments comm INNER JOIN users user ON comm.UserID = user.UserID WHERE comm.ParentNodeID = %s ".$whereStatement." ORDER BY comm.Time ASC LIMIT %s,".$systemSetting['MaxReplies'], SafeSQL($comment['ID'], 'int'), $comment['prevReplies'] )) or SQLError();
            while($reply = $getReplies->fetch_array(MYSQLI_ASSOC)) {
                // check if user liked|disliked this reply before
                $getReplyStatus = $db->query(sprintf("SELECT Liked FROM users_comments_likes WHERE UserID = %s AND CommentID = %s", SafeSQL($userArray['UserID'], 'int'), SafeSQL($reply['ID'], 'int') )) or SQLError();
                if($getReplyStatus->num_rows > 0) {
                    $replyStatus = $getReplyStatus->fetch_array(MYSQLI_ASSOC);
                    $reply['liked'] = $replyStatus['Liked'];
                }
                // decode text
                $reply['Text'] = DecodeText($reply['Text']);
                // check username
                $comment['replies'][] = $reply;
            }
        }
        // check if user liked|disliked this comment before
        $getCommentStatus = $db->query(sprintf("SELECT Liked FROM users_comments_likes WHERE UserID = %s AND CommentID = %s", SafeSQL($userArray['UserID'], 'int'), SafeSQL($comment['ID'], 'int') )) or SQLError();
        if($getCommentStatus->num_rows > 0) {
            $commentStatus = $getCommentStatus->fetch_array(MYSQLI_ASSOC);
            $comment['liked'] = $commentStatus['Liked'];
        }
        // decode comment text
        $comment['Text'] = DecodeText($comment['Text']);
        // check username
        $post['comments'][] = $comment;
    }
}

// assign variables
$smarty->assign('post', $post);
    
// page footer
PageFooter("track");

?>