<?php
/**
 * settings
 * 
 * @package Sngine
 * @author Yehia Abed
 * @version 0.3
 */

// fetch kernal
require('kernal.php');

// check access level
AccessLevel('restricted');

// valid inputs
$valid['edit'] = array('', 'account', 'profile', 'privacy', 'linked');
if(!in_array($_GET['edit'], $valid['edit'])) {
    SystemError($translate->__("Invalid Link"), $translate->__("You may have clicked an expired link or mistyped the address."));
}

// check profile picture
if($userArray['UserAvatarPath'] == 'content/themes/default/images/misc/no_avatar.jpg') {
    $defaultAvatar = true;
}else {
    $defaultAvatar = false;
}

if(!isset($_GET['edit']) || $_GET['edit'] == "account") {
    
    // page header
    PageHeader($translate->__('Account Settings'));
    
    $view = "account";
    
    if($_GET['tab'] == "name") {
        if($_POST['submit']) {
            if(!IsEmpty($_POST['firstname']) && !IsEmpty($_POST['lastname'])) {
                if(ValidString($_POST['firstname'])) {
                    if(ValidString($_POST['lastname'])) {
                        // update user
                        $db->query(sprintf("UPDATE users SET UserFirstName = %s, UserLastName = %s WHERE UserID = %s", Secure(ucwords($_POST['firstname'])), Secure(ucwords($_POST['lastname'])), Secure($userArray['UserID'], 'int') )) or SQLError();
                        header('Location: '.SITE_URL.'/settings/');
                    }else {
                        $error['name'] = "The last name contains invalid characters.";
                    }
                }else {
                    $error['name'] = "The first name contains invalid characters.";
                }
            }else {
                $error['name'] = "You must enter your first name and last name";
            }
        }
    }elseif ($_GET['tab'] == "username") {
        if($_POST['submit']) {
            if(!IsEmpty($_POST['username'])) {
                $forbidden = array('index', 'username', 'usernames', 'yourname', 'yournames', 'admin', 'admins', 'webmaster', 'amrdiab', '3mrdyab', 'amrdyab', '3mrdiab', 'ajax', 'content', 'js', 'libs', '404', 'about', 'album', 'albums', 'apps', 'bug', 'bugs', 'confirm', 'corefile', 'directory', 'discussion', 'discussions', 'editalbum', 'editdiscussion', 'editpage', 'feedback', 'gettingstarted', 'help', 'home', 'link', 'message', 'messages', 'news', 'newsfeed', 'notification', 'notifications', 'page', 'pages', 'photo', 'photos', 'poll', 'polls', 'privacy', 'profile', 'profiles', 'question', 'questions', 'recover', 'reset', 'search', 'settings', 'signin', 'login', 'signup', 'register', 'signout', 'logout', 'terms', 'tour', 'track', 'tracks', 'video', 'videos');
                if(!in_array(strtolower($_POST['username']), $forbidden)) {
                    if(ValidUserName($_POST['username'])) {
                        if(!$user->checkUserName($_POST['username'])) {
                            // update user
                            $db->query(sprintf("UPDATE users SET UserName = %s WHERE UserID = %s", Secure($_POST['username']), Secure($userArray['UserID'], 'int') )) or SQLError();
                            header('Location: '.SITE_URL.'/settings/');
                        }else {
                            $error['username'] = "There is an existing account associated with this username.";
                        }
                    }else {
                        $error['username'] = "Username contains invalid characters";
                    }
                }else {
                    $error['username'] = "Username is not available";
                }
            }else {
                $error['username'] = "You must enter valid (non-empty) username.";
            }
        }
    }elseif ($_GET['tab'] == "email") {
        if($_POST['submit']) {
            if($_POST['email'] != $userArray['UserEmail']) {
                if(!IsEmpty($_POST['email']) && ValidEmail($_POST['email'])) {
                    if(!$user->checkUserEmail($_POST['email'])) {
                        // create activation code
                        $code = md5(time()*rand(1, 9999));
                        // update user
                        $db->query(sprintf("UPDATE users SET UserEmail = %s, ActivationCode = %s, Verified = 'N' WHERE UserID = %s", Secure($_POST['email']), Secure($code), Secure($userArray['UserID'], 'int') )) or SQLError();
                        // prepare to send activation email
                        $subject = "Confirm your new email at ".SITE_TITLE;
                        $body  = "Hi ".$userArray['UserFirstName'].",";
                        $body .= "\r\n\r\nTo confirm your new email, please follow this link:";
                        $body .= "\r\n\r\nhttp://".SITE_DOMAIN."/confirm.php?id=".$userArray['UserID']."&code=".$code;
                        $body .= "\r\n\r\nWelcome to ".SITE_TITLE."!";
                        $body .= "\r\n\r".SITE_TITLE." Team";
                        // send activation email
                        if(SendMail($_POST['email'], $subject, $body)) {
                            header('Location: '.SITE_URL.'/settings/');
                        }else {
                            $error['email'] = "There is some thing wrong happened. Try again later.";
                        }
                    }else {
                        $error['email'] = "There is an existing account associated with this email.";
                    }
                }else {
                    $error['email'] = "You must enter valid email";
                }
            }
        }
    }elseif($_GET['tab'] == "password") {
        if($_POST['submit']) {
            if(!IsEmpty($_POST['password']) && !IsEmpty($_POST['newpass']) && !IsEmpty($_POST['confirm'])) {
                if($userArray['UserPassword'] == md5($_POST['password'])) {
                    if($_POST['newpass'] == $_POST['confirm']) {
                        if(strlen($_POST['newpass']) >= 6) {
                            // update user
                            $db->query(sprintf("UPDATE users SET UserPassword = %s WHERE UserID = %s", Secure(md5($_POST['newpass'])), Secure($userArray['UserID'], 'int') )) or SQLError();
                            header('Location: ./settings.php?edit=account');
                        }else {
                            $error['password'] = "Your new password must be at least 6 characters long. Please try another.";
                        }
                    }else {
                        $error['password'] = "Your passwords do not match.";
                    }
                }else {
                    $error['password'] = "Your current password is incorrect.";
                }
            }else {
                $error['password'] = "You must fill in all of the fields.";
            }
        }
    }
    
}elseif($_GET['edit'] == "profile") {
    
    // page header
    PageHeader($translate->__('Edit Profile'));
    
    $view = "profile";
    
    // generate secret
    $_SESSION['secret'] = md5(time()*rand(1, 9999));
    $smarty->assign('secret', $_SESSION['secret']);
    
    // edit basic info
    if($_GET['tab'] == "basic") {
        
        if($_POST['submit']) {
            if($_POST['sex'] != "none") {
                if($_POST['month'] != "none" && $_POST['day'] != "none" && $_POST['year'] != "none") {
                    if($_POST['year'] < "1999" && $_POST['year'] >= "1905" && $_POST['month'] <= "12" && $_POST['month'] >= "1" && $_POST['day'] <= "31" && $_POST['day'] >= "1" ) {
                        if(strlen($_POST['bio']) <= 255) {
                            // update user
                            $_POST['sex'] = ($_POST['sex'] == "m")? "M" : "F";
                            $db->query(sprintf("UPDATE users SET UserCountry = %s, UserWebsite = %s, UserBiography = %s, UserSex = %s, UserBirthMonth = %s, UserBirthDay = %s, UserBirthYear = %s WHERE UserID = %s", Secure($_POST['location']), Secure($_POST['website']), Secure($_POST['bio']), Secure($_POST['sex']), Secure($_POST['month']), Secure($_POST['day']), Secure($_POST['year']), Secure($userArray['UserID'], 'int') )) or SQLError();
                            header('Location: '.$userArray['URL']);
                        }else {
                            $error = "Your bio is too long. The maximum bio length is 255 characters.";
                        }
                    }else {
                        $error = "Sorry, we are not able to process your request.";
                    }
                }else {
                    $error = "You must indicate your full birthday to complete.";
                }
            }else {
                $error = "Please select either Male or Female.";
            }
        }
    }
    
}elseif($_GET['edit'] == "privacy") {
    
    // page header
    PageHeader($translate->__('Privacy Settings'));
    
    $view = "privacy";
    
    if($_POST['submit']) {
        // update user
        $_POST['facebook'] = ($_POST['facebook'] == "y")? "y" : "n";
        $_POST['twitter'] = ($_POST['twitter'] == "y")? "y" : "n";
        $_POST['chat'] = ($_POST['chat'] == "y")? "y" : "n";
        $db->query(sprintf("UPDATE users SET privacyFB = %s, privacyTW = %s, Offline = %s WHERE UserID = %s", Secure($_POST['facebook']), Secure($_POST['twitter']), Secure($_POST['chat']), Secure($userArray['UserID'], 'int') )) or SQLError();
        header('Location: '.$userArray['URL']);
    }
    
}elseif($_GET['edit'] == "linked") {
    
    // page header
    PageHeader($translate->__('Linked Accounts'));
    
    $view = "linked";
    
    // assign varibles
    $smarty->assign('linkedAccount', $linkedAccount);
    
}

// assign varibles
$smarty->assign('error', $error);
$smarty->assign('edit', $view);
$smarty->assign('defaultAvatar', $defaultAvatar);

// page footer
PageFooter("settings");

?>