<?php
/**
 * recover password
 * 
 * @package Sngine
 * @author Zamblek
 */

// fetch kernal
require('kernal.php');

// check user exist
if($userExist) {
    header('Location: '.SITE_URL.'/home.php');
}

// page header
PageHeader($translate->__("Forgot your password?"));

if(isset($_POST['submit'])) {
    if(!IsEmpty($_POST['email']) && ValidEmail($_POST['email'])) {
        require_once('libs/class-recaptcha.php');
        $resp = recaptcha_check_answer(RECAPTCHA_PRIVATEKEY, $_SERVER["REMOTE_ADDR"], $_POST['recaptcha_challenge_field'], $_POST['recaptcha_response_field']);
        if($resp->is_valid) {
            if($user->checkUserEmail($_POST['email'])) {
                // create reset code
                $code = md5(time()*rand(1, 9999));
                // update user
                $db->query(sprintf("UPDATE users SET ResetCode = %s, Reseted = 'Y' WHERE UserEmail = %s", Secure($code), Secure($_POST['email']) )) or SQLError();
                // prepare to send activation email
                $subject = "Password Reset Confirmation";
                $body  = "Hi,";
                $body .= "\r\n\r\nYou recently requested a new password.  To reset your password, follow the link below: \n";
                $body .= "\r\n\r\nhttp://www.".SITE_DOMAIN."/reset.php?email=".$_POST['email']."&code=".$code;
                $body .= "\r\n\r\n(If clicking on the link doesn't work, try copying and pasting it into your browser.) Please do not close your browser until the password page completely loads, which may take several minutes.";
                $body .= "\r\n\r".SITE_TITLE." Team";
                // send reset email
                if(SendMail($_POST['email'], $subject, $body)) {
                    $highlight = $translate->__("Please check your email now and follow the instructions.");
                }else {
                    $error = $translate->__("There is some thing wrong happened. Try again later");
                }
            }else {
                $error = $translate->__("The email you entered does not belong to any account.");
            }
        }else {
            $error = $translate->__("The secuirty code is incorrect. Please try another.");
        }
    }else {
        $error = $translate->__("Please enter a valid email address.");
    }
}

// assign varibles
$smarty->assign('error', $translate->__($error));
$smarty->assign('highlight', $translate->__($highlight));
$smarty->assign('email', $_POST['email']);

// page footer
PageFooter("recover");

?>