<?php
/**
 * questions app
 * 
 * @package Sngine
 * @author Zamblek
 */

// fetch kernal
require('kernal.php');

// check access level
AccessLevel();

// check data ID
if(!isset($_GET['id']) || $_GET['id'] == 0 || $_GET['id'] == "") {
    SystemError($translate->__("Invalid Link"), $translate->__("You may have clicked an expired link or mistyped the address."));
}else {
    // get post
    $getPost = $db->query(sprintf("SELECT question.*, post.*, user.UserName, user.UserFirstName, user.UserLastName, user.UserAvatarPathSmall AS UserAvatarPath FROM posts_questions question INNER JOIN posts post ON question.ID = post.PostID AND post.PostType = 6 INNER JOIN users user ON post.UserID = user.UserID WHERE post.PostID = %s", SafeSQL($_GET['id'], 'int') )) or SQLError();
    if($getPost->num_rows == 0) {
        SystemError($translate->__("This content is currently unavailable"), $translate->__("The page you requested cannot be displayed right now. It may be temporarily unavailable, the link you clicked on may have expired, or you may not have permission to view this page."));
    }
    $post = $getPost->fetch_array(MYSQLI_ASSOC);
}

// page header
PageHeader($post['Title'], TextCut(strip_tags($post['Text'])));

// decode text
$post['Text'] = DecodeText($post['Text']);

// check if user favorited this post before
$getPostStatus = $db->query(sprintf("SELECT Favorited FROM users_posts_favorites WHERE UserID = %s AND PostType = %s AND PostID = %s", SafeSQL($userArray['UserID'], 'int'), SafeSQL($post['PostType'], 'int'), SafeSQL($post['PostID'], 'int') )) or SQLError();
if($getPostStatus->num_rows > 0) {
    $post['favorited'] = true;
}else {
    $post['favorited'] = false;
}

// check if user liked|disliked this post before
$getPostStatus = $db->query(sprintf("SELECT Liked FROM users_posts_likes WHERE UserID = %s AND PostType = %s AND PostID = %s", SafeSQL($userArray['UserID'], 'int'), SafeSQL($post['PostType'], 'int'), SafeSQL($post['PostID'], 'int') )) or SQLError();
if($getPostStatus->num_rows > 0) {
    $postStatus = $getPostStatus->fetch_array(MYSQLI_ASSOC);
    $post['liked'] = $postStatus['Liked'];
}

// get answers
if($post['Answers'] > 0) {
    // prepare where statement
    if(count($userBlockedUsers) > 0) {
        $whereStatement['answers'] = ' AND answer.UserID NOT IN (' . implode(',', $userBlockedUsers) . ')';
        $whereStatement['notes'] = ' AND note.UserID NOT IN (' . implode(',', $userBlockedUsers) . ')';
    }
    $getAnswers = $db->query(sprintf("SELECT answer.*, user.UserName, user.UserFirstName, user.UserLastName, user.UserAvatarPathSmall AS UserAvatarPath FROM posts_questions_answers answer INNER JOIN users user ON answer.UserID = user.UserID WHERE answer.QuestionID = %s ".$whereStatement['answers']." ORDER BY answer.Votes DESC LIMIT 0,".$systemSetting['MaxAnswers'], SafeSQL($_GET['id'], 'int') )) or SQLError();
    while($answer = $getAnswers->fetch_array(MYSQLI_ASSOC)) {
        // get Notes
        if($answer['Notes'] > 0) {
            $answer['prevNotes'] = ($answer['Notes'] > $systemSetting['MaxNotes'])? $answer['Notes'] - $systemSetting['MaxNotes']: 0;
            $getNotes = $db->query(sprintf("SELECT note.*, user.UserName, user.UserFirstName, user.UserLastName FROM posts_questions_notes note INNER JOIN users user ON note.UserID = user.UserID WHERE note.AnswerID = %s ".$whereStatement['notes']." ORDER BY note.Time ASC LIMIT %s,".$systemSetting['MaxNotes'], SafeSQL($answer['ID'], 'int'), $answer['prevNotes'] )) or SQLError();
            while($note = $getNotes->fetch_array(MYSQLI_ASSOC)) {
                // decode text
                $note['Text'] = DecodeText($note['Text']);
                $answer['notes'][] = $note;
            }
        }
        // check if user voted for this answer before
        $getAnswerStatus = $db->query(sprintf("SELECT Voted FROM users_answers_votes WHERE UserID = %s AND AnswerID = %s", SafeSQL($userArray['UserID'], 'int'), SafeSQL($answer['ID'], 'int') )) or SQLError();
        if($getAnswerStatus->num_rows > 0) {
            $answerStatus = $getAnswerStatus->fetch_array(MYSQLI_ASSOC);
            $answer['voted'] = $answerStatus['Voted'];
        }
        // decode text
        $answer['Text'] = DecodeText($answer['Text']);
        $post['answers'][] = $answer;
    }
    if(($post['Answers'] - $systemSetting['MaxAnswers']) > 0) {
        $post['viewmore'] = true;
    }else {
        $post['viewmore'] = false;
    }
}

// assign variables
$smarty->assign('post', $post);

// page footer
PageFooter("question");

?>