<?php
/**
 * profile app
 * 
 * @package Sngine
 * @author Zamblek
 */

// fetch kernal
require('kernal.php');

// check access level
AccessLevel();

// check id or username
if (isset($_GET['u']) && ($_GET['u'] != 0 || $_GET['u'] != "")) {
    // get profile
    $username = Sanitize($_GET['u']);
    $getProfile = $db->query(sprintf("SELECT * FROM users WHERE UserName = %s", SafeSQL($username) )) or SQLError();
    if($getProfile->num_rows == 0) {
        SystemError($translate->__("This content is currently unavailable"), $translate->__("The page you requested cannot be displayed right now. It may be temporarily unavailable, the link you clicked on may have expired, or you may not have permission to view this page."));
    }
    $profile = $getProfile->fetch_array(MYSQLI_ASSOC);
    // check username case
    if(strtolower($username) == strtolower($profile['UserName']) && $username != $profile['UserName']) {
        header('Location: '.SITE_URL.'/'.$profile['UserName']);
    }
}else {
    SystemError($translate->__("Invalid Link"), $translate->__("You may have clicked an expired link or mistyped the address."));
}

// check if user follow him
if($userExist && $profile['UserID'] != $userArray['UserID']) {
    if(count($userFollowings) > 0) {
        $profile['FollowingHim'] = (in_array($profile['UserID'], $userFollowings))? true: false;
    }else {
        $profile['FollowingHim'] = false;
    }
}

// get featured wall photos
$getWallPhotos = $db->query(sprintf("SELECT * FROM posts_photos_sources WHERE AlbumID = %s ORDER BY ID DESC LIMIT 5", Secure($profile['UserWallPhotos'], 'int') )) or SQLError();
while($wallPhoto = $getWallPhotos->fetch_array(MYSQLI_ASSOC)) {
    $profile['wallPhotos'][] = $wallPhoto;
}

// get followings
$getFollowings = $db->query(sprintf("SELECT user.UserID, user.UserName, user.UserFirstName, user.UserLastName, user.UserAvatarPathSmall FROM users_followings follow INNER JOIN users user ON follow.FollowingID = user.UserID WHERE follow.UserID = %s LIMIT 21", SafeSQL($profile['UserID'], 'int'))) or SQLError();
if($getFollowings->num_rows > 0 ){
    $profile['hasFollowings'] = true;
    while($following = $getFollowings->fetch_array(MYSQLI_ASSOC)) {
        $profile['followings'][] = $following;
    }
}else {
    $profile['hasFollowings'] = false;
}

// get followers
$getFollowers = $db->query(sprintf("SELECT user.UserID, user.UserName, user.UserFirstName, user.UserLastName, user.UserAvatarPathSmall FROM users_followings follow INNER JOIN users user ON follow.UserID = user.UserID WHERE follow.FollowingID = %s LIMIT 21", SafeSQL($profile['UserID'], 'int'))) or SQLError();

if($getFollowers->num_rows > 0) {
    $profile['hasFollowers'] = true;
    while($follower = $getFollowers->fetch_array(MYSQLI_ASSOC)) {
        $profile['followers'][] = $follower;
    }
}else {
    $profile['hasFollowers'] = false;
}

// page header
PageHeader($profile['UserFirstName']." ".$profile['UserLastName'], $profile['UserFirstName']." ".$profile['UserLastName']." - ".$profile['UserBiography']);

// content
if(IsEmpty($_GET['v']) || $_GET['v'] == "info") {
    $view = 'info';
    // check user website link
    if(!IsEmpty($profile['UserWebsite']) && !ValidURL($profile['UserWebsite'])) {
        $profile['UserWebsite'] = 'http://'.$profile['UserWebsite'];
    }
}elseif ($_GET['v'] == "people") {
    $view = 'people';
    if(!isset($_GET['t']) || empty($_GET['t']) || $_GET['t'] == "followings") {
        $tab = 'followings';
    }elseif ($_GET['t'] == "followers") {
        $tab = 'followers';
    }else {
        $tab = 'followings';
    }
}elseif ($_GET['v'] == "wall") {
    $view = 'wall';
}elseif ($_GET['v'] == "news") {
    $view = 'news';
}elseif ($_GET['v'] == "music") {
    $view = 'music';
}elseif ($_GET['v'] == "photos") {
    $view = 'photos';
    if(!isset($_GET['t']) || empty($_GET['t']) || $_GET['t'] == "posts") {
        $tab = 'posts';
    }elseif ($_GET['t'] == "albums") {
        $tab = 'albums';
    }else {
        $tab = 'posts';
    }
}elseif ($_GET['v'] == "videos") {
    $view = 'videos';
    if(!isset($_GET['t']) || empty($_GET['t']) || $_GET['t'] == "posts") {
        $tab = 'posts';
    }elseif ($_GET['t'] == "albums") {
        $tab = 'albums';
    }else {
        $tab = 'posts';
    }
}elseif ($_GET['v'] == "discussions") {
    $view = 'discussions';
}elseif ($_GET['v'] == "questions") {
    $view = 'questions';
}elseif ($_GET['v'] == "polls") {
    $view = 'polls';
}elseif ($_GET['v'] == "links") {
    $view = 'links';
}else {
    header('Location: '.SITE_URL.'/index.php');
}

// assign variables
$smarty->assign('profile', $profile);
$smarty->assign('view', $view);
$smarty->assign('tab', $tab);

// page footer
PageFooter("profile");

?>