<?php
/**
 * photos app
 * 
 * @package Sngine
 * @author Zamblek
 */

// fetch kernal
require('kernal.php');

// check access level
AccessLevel();

// check data ID
if(!isset($_GET['id']) || $_GET['id'] == 0 || $_GET['id'] == "") {
    SystemError($translate->__("Invalid Link"), $translate->__("You may have clicked an expired link or mistyped the address."));
}else {
    // get media
    $getMedia = $db->query(sprintf("SELECT source.*, album.UserID, album.IsWall, album.Title, album.Total, user.UserName, user.UserFirstName, user.UserLastName FROM posts_photos_sources source INNER JOIN posts_photos_albums album ON source.AlbumID = album.ID INNER JOIN users user ON album.UserID = user.UserID WHERE source.ID = %s", SafeSQL($_GET['id'], 'int') )) or SQLError();
    if($getMedia->num_rows == 0) {
        SystemError($translate->__("This content is currently unavailable"), $translate->__("The page you requested cannot be displayed right now. It may be temporarily unavailable, the link you clicked on may have expired, or you may not have permission to view this page."));
    }
    $media = $getMedia->fetch_array(MYSQLI_ASSOC);
    $media['Text'] = DecodeText($media['Text']);
}

// page header
PageHeader($media['UserFirstName']." ".$media['UserLastName']."'s Photos - ".$media['Title'], strip_tags($media['Text']));

// get all album thumbnails
$getAlbumPhotos = $db->query(sprintf("SELECT * FROM posts_photos_sources WHERE AlbumID = %s", $media['AlbumID'])) or SQLError();
while($albumPhoto = $getAlbumPhotos->fetch_array(MYSQLI_ASSOC)) {
    $media['Thumbnials'][$albumPhoto['ID']] = $albumPhoto;
}
$media['Next'] = GetArrayKey($media['Thumbnials'], $media['ID'], 1);
$media['Prev'] = GetArrayKey($media['Thumbnials'], $media['ID'], -1);

// get comments
if($media['IsWall'] == "Y") {
    $getPost = $db->query(sprintf("SELECT post.* FROM posts_photos media INNER JOIN posts post ON media.ID = post.PostID AND post.PostType = 3 WHERE media.IsAlbum = 'N' AND media.MediaID = %s", SafeSQL($media['ID'], 'int') )) or SQLError();
    $post = $getPost->fetch_array(MYSQLI_ASSOC);
    $smarty->assign('post', $post);
    $media['Favorits'] = $post['Favorits'];
    $media['Likes'] = $post['Likes'];
    $media['Dislikes'] = $post['Dislikes'];
    $media['Comments'] = $post['Comments'];
    $media['PComments'] = $post['PComments'];
    // check if user favorited this album before
    $getPostStatus = $db->query(sprintf("SELECT Favorited FROM users_posts_favorites WHERE UserID = %s AND PostType = %s AND PostID = %s", SafeSQL($userArray['UserID'], 'int'), SafeSQL($post['PostType'], 'int'), SafeSQL($post['PostID'], 'int') )) or SQLError();
    if($getPostStatus->num_rows > 0) {
        $media['favorited'] = true;
    }else {
        $media['favorited'] = false;
    }
    // check if user liked|disliked this album before
    $getPostStatus = $db->query(sprintf("SELECT Liked FROM users_posts_likes WHERE UserID = %s AND PostType = %s AND PostID = %s", SafeSQL($userArray['UserID'], 'int'), SafeSQL($post['PostType'], 'int'), SafeSQL($post['PostID'], 'int') )) or SQLError();
    if($getPostStatus->num_rows > 0) {
        $postStatus = $getPostStatus->fetch_array(MYSQLI_ASSOC);
        $media['liked'] = $postStatus['Liked'];
    }
    // get comments
    if($post['Comments'] > 0) {
        // prepare where statement
        if(count($userBlockedUsers) > 0) {
            $whereStatement = ' AND comm.UserID NOT IN (' . implode(',', $userBlockedUsers) . ')';
        }
        $media['prevComments'] = ($post['PComments'] > $systemSetting['MaxComments'])? $post['PComments'] - $systemSetting['MaxComments']: 0;
        $getComments = $db->query(sprintf("SELECT comm.*, user.UserName, user.UserFirstName, user.UserLastName, user.UserAvatarPathMedium AS UserAvatarPath FROM posts_comments comm INNER JOIN users user ON comm.UserID = user.UserID WHERE comm.PostType = %s AND comm.PostID = %s AND comm.ParentNodeID = 0 ".$whereStatement." ORDER BY comm.Time ASC LIMIT %s,".$systemSetting['MaxComments'], SafeSQL($post['PostType'], 'int'), SafeSQL($post['PostID'], 'int'), $media['prevComments'] )) or SQLError();
        while($comment = $getComments->fetch_array(MYSQLI_ASSOC)) {
            // get Replies
            if($comment['Replies'] > 0) {
                $comment['prevReplies'] = ($comment['Replies'] > $systemSetting['MaxReplies'])? $comment['Replies'] - $systemSetting['MaxReplies']: 0;
                $getReplies = $db->query(sprintf("SELECT comm.*, user.UserName, user.UserFirstName, user.UserLastName, user.UserAvatarPathMedium AS UserAvatarPath FROM posts_comments comm INNER JOIN users user ON comm.UserID = user.UserID WHERE comm.ParentNodeID = %s ".$whereStatement." ORDER BY comm.Time ASC LIMIT %s,".$systemSetting['MaxReplies'], SafeSQL($comment['ID'], 'int'), $comment['prevReplies'] )) or SQLError();
                while($reply = $getReplies->fetch_array(MYSQLI_ASSOC)) {
                    // check if user liked|disliked this reply before
                    $getReplyStatus = $db->query(sprintf("SELECT Liked FROM users_comments_likes WHERE UserID = %s AND CommentID = %s", SafeSQL($userArray['UserID'], 'int'), SafeSQL($reply['ID'], 'int') )) or SQLError();
                    if($getReplyStatus->num_rows > 0) {
                        $replyStatus = $getReplyStatus->fetch_array(MYSQLI_ASSOC);
                        $reply['liked'] = $replyStatus['Liked'];
                    }
                    // decode text
                    $reply['Text'] = DecodeText($reply['Text']);
                    $comment['replies'][] = $reply;
                }
            }
            // check if user liked|disliked this comment before
            $getCommentStatus = $db->query(sprintf("SELECT Liked FROM users_comments_likes WHERE UserID = %s AND CommentID = %s", SafeSQL($userArray['UserID'], 'int'), SafeSQL($comment['ID'], 'int') )) or SQLError();
            if($getCommentStatus->num_rows > 0) {
                $commentStatus = $getCommentStatus->fetch_array(MYSQLI_ASSOC);
                $comment['liked'] = $commentStatus['Liked'];
            }
            // decode text
            $comment['Text'] = DecodeText($comment['Text']);
            $media['comments'][] = $comment;
        }
    }
}else {
    // check if user favorited this wall media before
    $getMediaStatus = $db->query(sprintf("SELECT Favorited FROM users_media_favorites WHERE UserID = %s AND PostType = 3 AND IsAlbum = 'N' AND MediaID = %s", SafeSQL($userArray['UserID'], 'int'), SafeSQL($media['ID'], 'int') )) or SQLError();
    if($getMediaStatus->num_rows > 0) {
        $media['favorited'] = true;
    }else {
        $media['favorited'] = false;
    }
    // check if user liked|disliked this wall album before
    $getMediaStatus = $db->query(sprintf("SELECT Liked FROM users_media_likes WHERE UserID = %s AND PostType = 3 AND IsAlbum = 'N' AND  MediaID = %s", SafeSQL($userArray['UserID'], 'int'), SafeSQL($media['ID'], 'int') )) or SQLError();
    if($getMediaStatus->num_rows > 0) {
        $mediaStatus = $getMediaStatus->fetch_array(MYSQLI_ASSOC);
        $media['liked'] = $mediaStatus['Liked'];
    }
    // get comments
    if($media['Comments'] > 0) {
        // prepare where statement
        if(count($userBlockedUsers) > 0) {
            $whereStatement = ' AND comm.UserID NOT IN (' . implode(',', $userBlockedUsers) . ')';
        }
        $media['prevComments'] = ($media['PComments'] > $systemSetting['MaxComments'])? $media['PComments'] - $systemSetting['MaxComments']: 0;
        $getComments = $db->query(sprintf("SELECT comm.*, user.UserName, user.UserFirstName, user.UserLastName, user.UserAvatarPathMedium AS UserAvatarPath FROM posts_comments_media comm INNER JOIN users user ON comm.UserID = user.UserID WHERE comm.PostType = 3 AND IsAlbum = 'N' AND comm.MediaID = %s AND comm.ParentNodeID = 0 ".$whereStatement." ORDER BY comm.Time ASC LIMIT %s,".$systemSetting['MaxComments'], SafeSQL($media['ID'], 'int'), $media['prevComments'] )) or SQLError();
        while($comment = $getComments->fetch_array(MYSQLI_ASSOC)) {
            // get Replies
            if($comment['Replies'] > 0) {
                $comment['prevReplies'] = ($comment['Replies'] > $systemSetting['MaxReplies'])? $comment['Replies'] - $systemSetting['MaxReplies']: 0;
                $getReplies = $db->query(sprintf("SELECT comm.*, user.UserName, user.UserFirstName, user.UserLastName, user.UserAvatarPathMedium AS UserAvatarPath FROM posts_comments_media comm INNER JOIN users user ON comm.UserID = user.UserID WHERE comm.ParentNodeID = %s ".$whereStatement." ORDER BY comm.Time ASC LIMIT %s,".$systemSetting['MaxReplies'], SafeSQL($comment['ID'], 'int'), $comment['prevReplies'] )) or SQLError();
                while($reply = $getReplies->fetch_array(MYSQLI_ASSOC)) {
                    // check if user liked|disliked this reply before
                    $getReplyStatus = $db->query(sprintf("SELECT Liked FROM users_comments_media_likes WHERE UserID = %s AND CommentID = %s", SafeSQL($userArray['UserID'], 'int'), SafeSQL($reply['ID'], 'int') )) or SQLError();
                    if($getReplyStatus->num_rows > 0) {
                        $replyStatus = $getReplyStatus->fetch_array(MYSQLI_ASSOC);
                        $reply['liked'] = $replyStatus['Liked'];
                    }
                    // decode text
                    $reply['Text'] = DecodeText($reply['Text']);
                    $comment['replies'][] = $reply;
                }
            }
            // check if user liked|disliked this comment before
            $getCommentStatus = $db->query(sprintf("SELECT Liked FROM users_comments_media_likes WHERE UserID = %s AND CommentID = %s", SafeSQL($userArray['UserID'], 'int'), SafeSQL($comment['ID'], 'int') )) or SQLError();
            if($getCommentStatus->num_rows > 0) {
                $commentStatus = $getCommentStatus->fetch_array(MYSQLI_ASSOC);
                $comment['liked'] = $commentStatus['Liked'];
            }
            // decode text
            $comment['Text'] = DecodeText($comment['Text']);
            $media['comments'][] = $comment;
        }
    }
    // prepare post variables
    $post['PostType'] = 3;
    $post['PostID'] = $media['ID'];
    $smarty->assign('post', $post);
}

// assign variables
$smarty->assign('media', $media);

// page footer
PageFooter("photo");

?>