<?php
/**
 * notifications system
 * 
 * @package Sngine
 * @author Zamblek
 */

// fetch kernal
require('kernal.php');

// check access level
AccessLevel('restricted');

// page header
PageHeader($translate->__("Your Notifications"));

// get notifications
if($userArray['UserNotifications'] > 0) {
    // prepare where statement
    if(count($userBlockedUsers) > 0) {
        $whereStatement = ' AND notifi.UserID NOT IN (' . implode(',', $userBlockedUsers) . ')';
    }
    
    $lastWeek = $now - (7*24*60*60);
    $getNotifications = $db->query(sprintf("SELECT notifi.*, user.UserName, user.UserFirstName, user.UserLastName FROM notifications notifi INNER JOIN users user ON notifi.UserID = user.UserID WHERE notifi.AuthorID = %s AND notifi.Time >= %s ".$whereStatement." ORDER BY notifi.Time DESC", SafeSQL($userArray['UserID'], 'int'), $lastWeek )) or SQLError();
    $days = array();
    while($notification = $getNotifications->fetch_array(MYSQLI_ASSOC)) {
        // follow
        if($notification['Action'] == 1) {
            $notification['image'] = 'follow';
            $notification['message'] = 'now follow you';
        // like post|comment|answer
        }elseif ($notification['Action'] == 2) {
            $notification['image'] = 'like';
            if($notification['Type'] == 'P') {
                $message = GetNotification($notification['PostType'], $notification['PostID']);
                $notification['message'] = 'likes your <a href="'.$message['link'].'">'.$message['app'].'</a>';
            }elseif ($notification['Type'] == 'C') {
                $notification['message'] = 'likes your comment';
            }else {
                $notification['message'] = 'voted your answer up';
            }
        // dislike post|comment|answer
        }elseif ($notification['Action'] == 3) {
            $notification['image'] = 'dislike';
            if($notification['Type'] == 'P') {
                $message = GetNotification($notification['PostType'], $notification['PostID']);
                $notification['message'] = 'dislikes your <a href="'.$message['link'].'">'.$message['app'].'</a>';
            }elseif ($notification['Type'] == 'C') {
                $notification['message'] = 'dislikes your comment';
            }else {
                $notification['message'] = 'voted your answer down';
            }
        // favorite
        }elseif ($notification['Action'] == 4) {
            $notification['image'] = 'favorite';
            $message = GetNotification($notification['PostType'], $notification['PostID']);
            $notification['message'] = 'favorites your <a href="'.$message['link'].'">'.$message['app'].'</a>';
        // comment|reply
        }elseif ($notification['Action'] == 5) {
            $notification['image'] = 'comments';
            if($notification['Type'] == 'P') {
                $message = GetNotification($notification['PostType'], $notification['PostID']);
                $notification['message'] = 'commented on your <a href="'.$message['link'].'">'.$message['app'].'</a>';
            }else {
                $notification['message'] = 'reply to your comment';
            }
        // answer
        }elseif ($notification['Action'] == 6) {
            $notification['image'] = 'comments';
            $message = GetNotification($notification['PostType'], $notification['PostID']);
            $notification['message'] = 'answered your <a href="'.$message['link'].'">'.$message['app'].'</a>';
        // noted
        }elseif ($notification['Action'] == 7) {
            $notification['image'] = 'comments';
            $notification['message'] = 'added a note to your answer';
        // poll
        }elseif ($notification['Action'] == 8) {
            $notification['image'] = 'like';
            $notification['message'] = 'voted in your poll';
        // @mention
        }elseif ($notification['Action'] == 9) {
            $notification['image'] = 'comments';
            if($notification['Type'] == 'P') {
                $message = GetNotification($notification['PostType'], $notification['PostID']);
                $notification['message'] = 'posted on your <a href="'.$message['link'].'">wall</a>';
            }elseif ($notification['Type'] == 'C') {
                $notification['message'] = 'mention you in a <a href="'.$message['link'].'">comment</a>';
            }
        }
        // check username
        $notification['UserURL'] = SITE_URL."/".$notification['UserName'];
        // group notifications by date
        $date = date('M d', $notification['Time']);
        if($date == date('M d')) {
            $days['Today'][] = $notification;
        }elseif ($date == date('M d',time() - (24 * 60 * 60))) {
            $days['Yesterday'][] = $notification;
        }else {
            $days[$date][] = $notification;
        }
    }
    $smarty->assign('days', $days);
    // live reset
    $db->query(sprintf("UPDATE users SET UserNewNotifications = 0 WHERE UserID = %s", SafeSQL($userArray['UserID'], 'int') )) or SQLError();
    $getNotifications = $db->query(sprintf("SELECT * FROM notifications WHERE AuthorID = %s AND Viewed = 'N'", SafeSQL($userArray['UserID'], 'int') )) or SQLError();
    if($getNotifications->num_rows > 0) {
        while($notification = $getNotifications->fetch_array(MYSQLI_ASSOC)) {
            $db->query(sprintf("UPDATE notifications SET Viewed = 'Y' WHERE ID = %s", SafeSQL($notification['ID'], 'int') )) or SQLError();
        }
    }
}

// page footer
PageFooter("notifications");

?>