<?php
/**
 * messages system
 * 
 * @package Sngine
 * @author Zamblek
 */

// fetch kernal
require('kernal.php');

// check access level
AccessLevel('restricted');

// page header
PageHeader($translate->__("Messages"));

// check data ID
if(!isset($_GET['id']) || $_GET['id'] == 0 || $_GET['id'] == "") {
    SystemError($translate->__("Invalid Link"), $translate->__("You may have clicked an expired link or mistyped the address."));
}else {
    // check if user authorized to see conversation
    $getConversation = $db->query(sprintf("SELECT conv.ID, conv.Recipients, user.Viewed FROM messages_conversations conv INNER JOIN messages_conversations_users user ON conv.ID = user.ConversationID WHERE user.ConversationID = %s AND user.UserID = %s AND user.Deleted = 'N'", SafeSQL($_GET['id'], 'int'),SafeSQL($userArray['UserID'], 'int') )) or SQLError();
    if($getConversation->num_rows == 0) {
        SystemError($translate->__("Invalid Link"), $translate->__("That message could not be found."));
    }
    $conversation = $getConversation->fetch_array(MYSQLI_ASSOC);
}

// mark as read if not
if($conversation['Viewed'] == 'N') {
    $db->query(sprintf("UPDATE messages_conversations_users SET Viewed = 'Y' WHERE ConversationID = %s AND UserID = %s", SafeSQL($_GET['id'], 'int'), SafeSQL($userArray['UserID'], 'int'))) or SQLError();
}

// get conversation recipients
if($conversation['Recipients'] < 2) {
    // just one to one conversation
    $getRecipients = $db->query(sprintf("SELECT user.UserID, user.UserName, user.UserFirstName, user.UserLastName, user.UserAvatarPathMedium AS UserAvatarPath FROM messages_conversations_users conv INNER JOIN users user ON conv.UserID = user.UserID WHERE conv.ConversationID = %s AND conv.UserID != %s", SafeSQL($_GET['id'], 'int'), SafeSQL($userArray['UserID'], 'int') )) or SQLError();
    $recipient = $getRecipients->fetch_array(MYSQLI_ASSOC);
    $conversation['users'] = $recipient;
    $conversation['hasOthers'] = false;
}else {
    // more than 2 recipients
    $getRecipients = $db->query(sprintf("SELECT user.UserID, user.UserName, user.UserFirstName, user.UserLastName, user.UserAvatarPathMedium AS UserAvatarPath FROM messages_conversations_users conv INNER JOIN users user ON conv.UserID = user.UserID WHERE conv.ConversationID = %s AND conv.UserID != %s", SafeSQL($_GET['id'], 'int'), SafeSQL($userArray['UserID'], 'int') )) or SQLError();
    $counter = 1;
    while($recipient = $getRecipients->fetch_array(MYSQLI_ASSOC)) {
        if($counter < 2) {
            $conversation['users'] = $recipient;
        }else {
            $conversation['otherUsers'][] = $recipient;
        }
        $counter++;
    }
    $conversation['others'] = $conversation['Recipients'] - 1;
    $conversation['hasOthers'] = true;
}
$smarty->assign('conversation', $conversation);

// get conversation messages
$getMessages = $db->query(sprintf("SELECT msg.*, user.UserName, user.UserFirstName, user.UserLastName, user.UserAvatarPathMedium AS UserAvatarPath FROM messages msg INNER JOIN users user ON msg.UserID = user.UserID WHERE msg.ConversationID = %s ORDER BY msg.Time ASC", SafeSQL($_GET['id'], 'int'))) or SQLError();
while($message = $getMessages->fetch_array(MYSQLI_ASSOC)) {
    // check if user deleted this message
    $checkDeleted = $db->query(sprintf("SELECT * FROM messages_users WHERE MessageID = %s AND UserID = %s AND Deleted = 'N'", SafeSQL($message['ID'], 'int'), SafeSQL($userArray['UserID'], 'int') )) or SQLError();
    if($checkDeleted->num_rows > 0) {
        // decode text
        $message['Text'] = DecodeText($message['Text']);
        $messages[] = $message;
    }
}
$smarty->assign('messages', $messages);
    
// page footer
PageFooter("message");

?>