<?php
/**
 * directory functions
 * 
 * @package Sngine
 * @author Zamblek
 */


/**
 * getContent
 * 
 * @param string $view
 * @param integer $spage
 * @return mixed
 */
function getContent($view, $spage) {
    if($view == 'people') {
        return getPeople($spage);
    }else {
        return getPosts($view, $spage);
    }
}

/**
 * getPosts
 * 
 * @param string $app
 * @param integer $spage
 * @return mixed
 */
function getPosts($app, $spage = 1) {
    global $db, $smarty, $systemSetting, $userArray;
    // define page
    $page = "directory.get.posts";
    $table = 'posts_'.$app;
    $size = $systemSetting['MaxFeeds'];
    // prepare application
    switch ($app) {
        case "news":
            $appId = 1;
        break;
        case "music":
            $appId = 2;
            $table = 'posts_tracks';
        break;
        case "photos":
            $appId = 3;
            $size = $systemSetting['MaxMediaFeeds'];
            $page = "directory.get.media";
        break;
        case "videos":
            $appId = 4;
            $size = $systemSetting['MaxMediaFeeds'];
            $page = "directory.get.media";
        break;
        case "discussions":
            $appId = 5;
        break;
        case "questions":
            $appId = 6;
        break;
        case "polls":
            $appId = 7;
        break;
        case "links":
            $appId = 8;
        break;
    }
    // prepare where statement
    $whereStatement  = " WHERE post.PostType = ".$appId;
    // prepare pagination
    $spage = (int) $spage;
    $spage = ($spage == 0) ? 1 : $spage;
    $total = $db->query("SELECT * FROM ".$table) or SQLError();
    $total = $total->num_rows;
    require_once('class-pagination.php');
    $pagination = new Pagination($spage, $size, $total, SITE_URL.'/directory/'.$app.'/%s/');
    $limitStatement = $pagination->getLimitSql();
    $smarty->assign('pager', $pagination->getPager());
    // get content
    $getPosts = $db->query("SELECT post.*, user.UserName, user.UserFirstName, user.UserLastName, user.UserAvatarPathMedium AS UserAvatarPath FROM posts post INNER JOIN users user ON post.UserID = user.UserID ".$whereStatement." ORDER BY post.ID DESC ".$limitStatement) or SQLError();
    if($getPosts->num_rows == 0) {
        return '<div class="dataNullState stopCronJobs">There are no more '.$app.' to show.</div>';
    }
    while($post = $getPosts->fetch_array(MYSQLI_ASSOC)) {
        // news posts
        if($post['PostType'] == 1) {
            $getData = $db->query(sprintf("SELECT * FROM posts_news WHERE ID = %s", Secure($post['PostID'], 'int'))) or SQLError();
            $post['data'] = $getData->fetch_array(MYSQLI_ASSOC);
            $post['data']['URL'] = GetURLText($post['data']['Text']);
            $post['data']['Text'] = DecodeText($post['data']['Text']);
        // music posts
        }elseif ($post['PostType'] == 2) {
            $getData = $db->query(sprintf("SELECT * FROM posts_tracks WHERE ID = %s", Secure($post['PostID'], 'int'))) or SQLError();
            $post['data'] = $getData->fetch_array(MYSQLI_ASSOC);
            if(IsEmpty($post['data']['Text'])) {
                $post['data']['URL'] = GetURLText($post['data']['Title']);
            }else {
                $post['data']['URL'] = GetURLText($post['data']['Text']);
            }
            $post['data']['Text'] = DecodeText($post['data']['Text']);
        // photos posts
        }elseif ($post['PostType'] == 3) {
            $getData = $db->query(sprintf("SELECT IsAlbum, MediaID FROM posts_photos WHERE ID = %s", Secure($post['PostID'], 'int'))) or SQLError();
            $post['data'] = $getData->fetch_array(MYSQLI_ASSOC);
            if($post['data']['IsAlbum'] == 'Y') {
                $getMedia =  $db->query(sprintf("SELECT album.Title, album.Text, album.New, album.ThumbnailID, source.Thumbnail FROM posts_photos_albums album LEFT JOIN posts_photos_sources source ON album.ThumbnailID = source.ID WHERE album.ID = %s", Secure($post['data']['MediaID'], 'int'))) or SQLError();
                $post['data']['media'] = $getMedia->fetch_array(MYSQLI_ASSOC);
            }else {
                $getMedia =  $db->query(sprintf("SELECT source.Source, source.Thumbnail, source.Text, source.AlbumID, album.Title FROM posts_photos_sources source INNER JOIN posts_photos_albums album ON source.AlbumID = album.ID WHERE source.ID = %s", Secure($post['data']['MediaID'], 'int'))) or SQLError();
                $post['data']['media'] = $getMedia->fetch_array(MYSQLI_ASSOC);
            }
            $post['data']['media']['Text'] = DecodeText($post['data']['media']['Text']);
        // videos posts
        }elseif ($post['PostType'] == 4) {
            $getData = $db->query(sprintf("SELECT IsAlbum, MediaID FROM posts_videos WHERE ID = %s", Secure($post['PostID'], 'int'))) or SQLError();
            $post['data'] = $getData->fetch_array(MYSQLI_ASSOC);
            if($post['data']['IsAlbum'] == 'Y') {
                $getMedia =  $db->query(sprintf("SELECT album.Title, album.Text, album.New, album.ThumbnailID, source.Thumbnail FROM posts_videos_albums album LEFT JOIN posts_videos_sources source ON album.ThumbnailID = source.ID WHERE album.ID = %s", Secure($post['data']['MediaID'], 'int'))) or SQLError();
                $post['data']['media'] = $getMedia->fetch_array(MYSQLI_ASSOC);
            }else {
                $getMedia =  $db->query(sprintf("SELECT source.Source, source.Type, source.Thumbnail, source.Text, source.AlbumID, album.Title FROM posts_videos_sources source INNER JOIN posts_videos_albums album ON source.AlbumID = album.ID WHERE source.ID = %s", Secure($post['data']['MediaID'], 'int'))) or SQLError();
                $post['data']['media'] = $getMedia->fetch_array(MYSQLI_ASSOC);
            }
            $post['data']['media']['Text'] = DecodeText($post['data']['media']['Text']);
        // discussions posts
        }elseif ($post['PostType'] == 5) {
            $getData = $db->query(sprintf("SELECT * FROM posts_discussions WHERE ID = %s", Secure($post['PostID'], 'int') )) or SQLError();
            $post['data'] = $getData->fetch_array(MYSQLI_ASSOC);
            $post['data']['Text'] = Parse($post['data']['Text']);
            $post['data']['Text'] = DecodeText($post['data']['Text']);
            $post['data']['URL'] = GetURLText($post['data']['Title']);
        // questions posts
        }elseif ($post['PostType'] == 6) {
            $getData = $db->query(sprintf("SELECT * FROM posts_questions WHERE ID = %s", Secure($post['PostID'], 'int') )) or SQLError();
            $post['data'] = $getData->fetch_array(MYSQLI_ASSOC);
            $post['Answers'] = $post['data']['Answers'];
            $post['data']['URL'] = GetURLText($post['data']['Title']);
        // polls posts
        }elseif ($post['PostType'] == 7) {
            $getData = $db->query(sprintf("SELECT * FROM posts_polls WHERE ID = %s", Secure($post['PostID'], 'int') )) or SQLError();
            $post['data'] = $getData->fetch_array(MYSQLI_ASSOC);
            // get poll options
            $getPollOptions = $db->query(sprintf("SELECT * FROM posts_polls_options WHERE PollID = %s", Secure($post['PostID'], 'int') )) or SQLError();
            while($pollOption = $getPollOptions->fetch_array(MYSQLI_ASSOC)) {
                $pollOption['Bar'] = ($pollOption['Votes'] / $post['data']['Votes']) * 100;
                // check if user select the option
                $getOption = $db->query(sprintf("SELECT * FROM users_polls_options WHERE UserID = %s AND PollID = %s AND OptionID = %s", Secure($userArray['UserID'], 'int'), Secure($post['PostID'], 'int'), Secure($pollOption['ID'], 'int') )) or SQLError();
                if($getOption->num_rows == 0) {
                    $pollOption['select'] = false;
                }else {
                    $pollOption['select'] = true;
                    $post['data']['selected'] = $pollOption['ID'];
                }
                $post['pollOptions'][] = $pollOption;
            }
            $post['data']['URL'] = GetURLText($post['data']['Question']);
        // links posts
        }elseif ($post['PostType'] == 8) {
            $getData = $db->query(sprintf("SELECT * FROM posts_links WHERE ID = %s", Secure($post['PostID'], 'int') )) or SQLError();
            $post['data'] = $getData->fetch_array(MYSQLI_ASSOC);
            $post['data']['Text'] = DecodeText($post['data']['Text']);
            $post['data']['Link'] = GetURLText($post['data']['Title']);
        }
        // check if user favorited this post before
        $getPostStatus = $db->query(sprintf("SELECT Favorited FROM users_posts_favorites WHERE UserID = %s AND PostType = %s AND PostID = %s", Secure($userArray['UserID'], 'int'), Secure($post['PostType'], 'int'), Secure($post['PostID'], 'int') )) or SQLError();
        if($getPostStatus->num_rows > 0) {
            $post['favorited'] = true;
        }else {
            $post['favorited'] = false;
        }
        // check if user liked|disliked this post before
        $getPostStatus = $db->query(sprintf("SELECT Liked FROM users_posts_likes WHERE UserID = %s AND PostType = %s AND PostID = %s", Secure($userArray['UserID'], 'int'), Secure($post['PostType'], 'int'), Secure($post['PostID'], 'int') )) or SQLError();
        if($getPostStatus->num_rows > 0) {
            $postStatus = $getPostStatus->fetch_array(MYSQLI_ASSOC);
            $post['liked'] = $postStatus['Liked'];
        }
        // get comments
        if($post['Comments'] > 0 && $post['Comments'] <= $systemSetting['MaxQComments']) {
            $post['prevComments'] = ($post['Comments'] > $systemSetting['MaxQCommentsViewed'])? $post['Comments'] - $systemSetting['MaxQCommentsViewed']: 0;
            $getComments = $db->query(sprintf("SELECT comm.*, user.UserName, user.UserFirstName, user.UserLastName, user.UserAvatarPathSmall AS UserAvatarPath FROM posts_comments comm INNER JOIN users user ON comm.UserID = user.UserID WHERE comm.PostType = %s AND comm.PostID = %s ".$whereStatementComments." ORDER BY comm.Time ASC LIMIT %s,".$systemSetting['MaxQCommentsViewed'], Secure($post['PostType'], 'int'), Secure($post['PostID'], 'int'), $post['prevComments'] )) or SQLError();
            while($comment = $getComments->fetch_array(MYSQLI_ASSOC)) {
                // check if user liked|disliked this comment before
                $getCommentStatus = $db->query(sprintf("SELECT Liked FROM users_comments_likes WHERE UserID = %s AND CommentID = %s", SafeSQL($userArray['UserID'], 'int'), SafeSQL($comment['ID'], 'int') )) or SQLError();
                if($getCommentStatus->num_rows > 0) {
                    $commentStatus = $getCommentStatus->fetch_array(MYSQLI_ASSOC);
                    $comment['liked'] = $commentStatus['Liked'];
                }
                // decode comment text
                $comment['Text'] = DecodeText($comment['Text']);
                $post['comments'][] = $comment;
            }
        }
        $posts[] = $post;
    }
    // assign variables
    $smarty->assign('app', $app);
    $smarty->assign('posts', $posts);
    // display page templete
    $content = $smarty->fetch("$page.tpl");
    return $content;
}

/**
 * getPeople
 * 
 * @param integer $spage
 * @return mixed
 */
function getPeople($spage = 1) {
    global $db, $smarty, $systemSetting, $userExist, $userFollowings;
    // define page
    $page = "directory.get.people";
    // prepare pagination
    $spage = (int) $spage;
    $spage = ($spage == 0) ? 1 : $spage;
    $total = $db->query("SELECT * FROM users") or SQLError();
    $total = $total->num_rows;
    require_once('class-pagination.php');
    $pagination = new Pagination($spage, $systemSetting['MaxPeople'], $total, SITE_URL.'/directory/people/%s/');
    $limitStatement = $pagination->getLimitSql();
    $smarty->assign('pager', $pagination->getPager());
    // get people
    $getPeople = $db->query(sprintf("SELECT * FROM users ORDER BY UserPosts DESC ".$limitStatement )) or SQLError();
    if($getPeople->num_rows == 0) {
        return '<div class="dataNullState stopCronJobs">There are no more users to show.</div>';
    }
    while($person = $getPeople->fetch_array(MYSQLI_ASSOC)) {
        // check if user follow any of them
        if($userExist) {
            $person['FollowingHim'] = (count($userFollowings) > 0 && in_array($person['UserID'], $userFollowings))? true: false;
        }
        $people[] = $person;
    }
    // assign variables
    $smarty->assign('people', $people);
    // display page templete
    $content = $smarty->fetch("$page.tpl");
    return $content;
}

?>