<?php
/**
 * user class
 * 
 * @package Sngine
 * @author Zamblek
 */

class User {
    
    public $_userExist = false;
    public $_userArray = array();
    public $_userFollowers = array();
    public $_userFollowings = array();
    public $_userBlockedUsers = array();
    public $_userBlockedPosts = array();
    
    protected $_cookieUserId = "c_user";
    protected $_cookieUserToken = "xs";
    
    /**
     * setCookies
     * 
     * @param integer $userid
     * @param boolean $remember
     * @return void
     */ 
    public function setCookies($userid, $remember = false, $path = '/') {
        
        global $db;
        
        // generate new token
        $token = md5(time());
        
        if($remember) {
            $expire = time()+2592000;
            setcookie($this->_cookieUserId, $userid, $expire, $path);
            setcookie($this->_cookieUserToken, $token, $expire, $path);
        }else {
            setcookie($this->_cookieUserId, $userid, 0, $path);
            setcookie($this->_cookieUserToken, $token, 0, $path);
        }
        
        // update user
        $update = $db->query(sprintf("UPDATE users SET UserToken = %s WHERE UserID = %s", Secure($token), Secure($userid, 'int') ));
        if(!$update) {
            throw new Exception($translate->__("There is some thing wrong happened. Try again later"));
        }
    }

    /**
     * getCookies 
     * 
     * @return void
     */
    public function getCookies($isAdmin = false) {
        
        global $db, $translate;
    	
        if(isset($_COOKIE[$this->_cookieUserId]) && isset($_COOKIE[$this->_cookieUserToken])) {
            if($isAdmin) {
                $checkUser = $db->query(sprintf("SELECT * FROM users WHERE UserID = %s AND UserGroup = 1", Secure($_COOKIE[$this->_cookieUserId], 'int') )) or SQLError();
            }else {
                $checkUser = $db->query(sprintf("SELECT * FROM users WHERE UserID = %s", Secure($_COOKIE[$this->_cookieUserId], 'int') )) or SQLError();
            }
            if($checkUser->num_rows >= 1) {
                $this->_userArray = $checkUser->fetch_array(MYSQLI_ASSOC);
                $this->_userFollowers = $this->getFollowers($this->_userArray['UserID']);
                $this->_userFollowings = $this->getFollowings($this->_userArray['UserID']);
                $this->_userBlockedUsers = $this->getBlockedUsers($this->_userArray['UserID']);
                $this->_userBlockedPosts = $this->getBlockedPosts($this->_userArray['UserID']);
                $this->_userExist = true;
            }else {
                $this->_userExist = false;
            }
        }else {
            $this->_userExist = false;
        }
        return $this->_userExist;
    }
    
    /**
     * signUp
     * 
     * @param string $firstname
     * @param string $lastname
     * @param string $username
     * @param string $email
     * @param string $confirm
     * @param string $password
     * @param string $sex
     * @param integer $month
     * @param integer $day
     * @param integer $year
     * @param string $recaptcha
     * @param string $response
     * @param string $ip
     * @return void
     */
    public function signUp($firstname, $lastname, $username, $email, $confirm, $password, $sex, $month, $day, $year, $recaptcha, $response, $ip) {
        
        global $db, $translate, $now;
        
        if(IsEmpty($firstname) || IsEmpty($lastname) || IsEmpty($username) || IsEmpty($email) || IsEmpty($confirm) || IsEmpty($password)) {
            throw new Exception($translate->__("You must fill in all of the fields."));
        }
        
        if(!ValidUserName($username)) {
            throw new Exception($translate->__("Please enter a valid username."));
        }
        
        if($this->checkUserName($username)) {
            throw new Exception($translate->__("Sorry, it looks like")." ".$username." ".$translate->__("belongs to an existing account."));
        }
        
        if(!ValidEmail($email)) {
            throw new Exception($translate->__("Please enter a valid email address."));
        }
        
        if($this->checkUserEmail($email)) {
            throw new Exception($translate->__("Sorry, it looks like")." ".$email." ".$translate->__("belongs to an existing account."));
        }
        
        if($email != $confirm) {
            throw new Exception($translate->__("Your emails do not match. Please try again."));
        }
        
        if(strlen($password) < 6) {
            throw new Exception($translate->__("Your password must be at least 6 characters long. Please try another."));
        }
        
        if(!ValidString($firstname)) {
            throw new Exception($translate->__("The first name contains invalid characters."));
        }
        
        if(!ValidString($lastname)) {
            throw new Exception($translate->__("The last name contains invalid characters."));
        }
        
        if($month == "none" || $day == "none" || $year == "none") {
            throw new Exception($translate->__("You must indicate your full birthday to register."));
        }
        
        if($year >= "1999" || $year < "1905" || $month > "12" || $month < "1" || $day > "31" || $day < "1" ) {
            throw new Exception($translate->__("Sorry, we are not able to process your registration."));
        }
        
        if($sex == "none") {
            throw new Exception($translate->__("Please select either Male or Female."));
        }
        $sex = ($sex == "m")? "M" : "F";
        
        require_once('class-recaptcha.php');
        $resp = recaptcha_check_answer(RECAPTCHA_PRIVATEKEY, $_SERVER["REMOTE_ADDR"], $recaptcha, $response);
        
        if(!$resp->is_valid) {
            throw new Exception($translate->__("The secuirty code is incorrect. Please try another."));
        }
        
        // create activation code
        $code = md5(time()*rand(1, 9999));
        
        // register user
        $insertUser = $db->query(sprintf("INSERT INTO users (UserEmail, UserToken, UserFirstName, UserLastName, UserName, UserPassword, UserSex, UserBirthMonth, UserBirthDay, UserBirthYear, SignupDate, UserIP, ActivationCode) VALUES (%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)", Secure($email), Secure($code), Secure(ucwords($firstname)), Secure(ucwords($lastname)), Secure(ucwords($username)), Secure(md5($password)), Secure($sex), Secure($month, 'int'), Secure($day, 'int'), Secure($year, 'int'), Secure($now), Secure($ip), Secure($code) ));
        if(!$insertUser) {
            throw new Exception($translate->__("Error! Try again later"));
        }
        
        // get userid
        $userId = $db->insert_id;
        
        // prepare to send activation email
        $subject = "Just one more step to get started on ".SITE_TITLE."";
        $body  = "Hi ".$firstname.",";
        $body .= "\r\n\r\nTo complete the sign-up process, please follow this link:";
        $body .= "\r\n\r\nhttp://www.".SITE_DOMAIN."/confirm.php?id=".$userId."&code=".$code;
        $body .= "\r\n\r\nWelcome to ".SITE_TITLE."!";
        $body .= "\r\n\r".SITE_TITLE." Team";
        
        // send activation email
        if(!SendMail($email, $subject, $body)) {
            $db->query(sprintf("DELETE FROM users WHERE UserID = %s", Secure($userId, 'int') ));
            throw new Exception($translate->__("There is some thing wrong happened. Try again later"));
        }
        
        // create media albums
        $db->query(sprintf("INSERT INTO posts_photos_albums (UserID, IsWall, Title, Time) VALUES (%s, 'Y', 'Wall Photos', %s)", Secure($userId, 'int'), Secure($now) ));
        $wallPhotos = $db->insert_id;
        $db->query(sprintf("INSERT INTO posts_videos_albums (UserID, IsWall, Title, Time) VALUES (%s, 'Y', 'Wall Videos', %s)", Secure($userId, 'int'), Secure($now) ));
        $wallVideos = $db->insert_id;
        $db->query(sprintf("UPDATE users SET UserWallPhotos = %s, UserWallVideos = %s WHERE UserID = %s", Secure($wallPhotos, 'int'), Secure($wallVideos, 'int'), Secure($userId, 'int') ));
        
        // set cookies
        try {
            $this->updateLastSign($userId);
            $this->setCookies($userId, false);
        }catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }
    
    /**
     * signIn
     * 
     * @param string $username_email
     * @param string $password
     * @param boolean $remember
     * @return void
     */ 
    public function signIn($username_email, $password, $remember = false, $isAdmin = false) {
		
        global $db, $translate, $now;
        
        if(IsEmpty($username_email) || IsEmpty($password)) {
            throw new Exception($translate->__("You must fill in all of the fields."));
        }
        
        // check if username or email
        if(ValidEmail($username_email)) {
            if(!$this->checkUserEmail($username_email)) {
                throw new Exception($translate->__("The email you entered does not belong to any account."));
            }
            $field = "UserEmail";
        }else {
            if(!ValidUserName($username_email)) {
                throw new Exception($translate->__("Please enter a valid email address or username."));
            }
            if(!$this->checkUserName($username_email)) {
                throw new Exception($translate->__("The username you entered does not belong to any account."));
            }
            $field = "UserName";
        }
        
        // get user
        if($isAdmin) {
            $getUser = $db->query(sprintf("SELECT UserID FROM users WHERE ".$field." = %s AND UserPassword = %s AND UserGroup = 1", Secure($username_email), Secure(md5($password)) ));
        }else {
            $getUser = $db->query(sprintf("SELECT UserID FROM users WHERE ".$field." = %s AND UserPassword = %s", Secure($username_email), Secure(md5($password)) ));
        }
        
        if(!$getUser) {
            throw new Exception("There is some thing wrong happened. Try again later");
        }
        if($getUser->num_rows == 0) {
            throw new Exception("<p class=\"mb5\"><strong>".$translate->__("Please re-enter your password")."</strong></p><p>".$translate->__("The password you entered is incorrect. If you forgot your password?")." <a href='".SITE_URL."/recover/'>".$translate->__("Request a new one.")."</a></p>");
        }
        $user = $getUser->fetch_array(MYSQLI_ASSOC);
        
        // set cookies
        try {
            $this->updateLastSign($user['UserID']);
            $this->setCookies($user['UserID'], $remember);
        }catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
        if($isAdmin) {
            header('Location: '.SITE_URL.'/admin');
        }else {
            header('Location: '.SITE_URL.'/home.php');
        }
        
	}
    
    /**
     * signOut
     * 
     * @return void
     */ 
    public function signOut() {
        
        session_destroy();
        unset($_COOKIE[$this->_cookieUserId]);
        unset($_COOKIE[$this->_cookieUserToken]);
    	setcookie($this->_cookieUserId, NULL, -1, '/');
        setcookie($this->_cookieUserToken, NULL, -1, '/');
    }
    
    /**
     * updateLastSign
     * 
     * @param integer $userId
     * @return void
     */ 
     public function updateLastSign($userId) {
        
        global $db, $now;
        
        $update = $db->query(sprintf("UPDATE users SET UserLastLogin = %s WHERE UserID = %s ", Secure($now), Secure($userId, 'int') ));
        if(!$update) {
            throw new Exception("There is some thing wrong happened. Try again later");
        }
     }
    
    /**
     * twitter_getLink
     * 
     * @return void
     */ 
    public static function twitter_getLink() {
        
        require_once('oauth/twitter/twitteroauth.php');
        
        $twitter = new TwitterOAuth(TW_APPID, TW_SECRET);
        $requestToken = $twitter->getRequestToken(TW_CALLBACK);
        
        if($twitter->http_code != 200) {
            throw new Exception("Could not connect to Twitter. Refresh the page or try again later.");
        }
        $_SESSION['tw_oauth_token'] = $requestToken['oauth_token'];
        $_SESSION['tw_oauth_token_secret'] = $requestToken['oauth_token_secret'];
        return $twitter->getAuthorizeURL($requestToken['oauth_token']);
    }
    
    /**
     * twitter_checkUser
     * 
     * @return void
     */ 
    public function twitter_checkUser() {
        
        global $db, $now;
        
        require_once('libs/oauth/twitter/twitteroauth.php');
        
        $twitter = new TwitterOAuth(TW_APPID, TW_SECRET, $_SESSION['tw_oauth_token'], $_SESSION['tw_oauth_token_secret']);
        $accessToken = $twitter->getAccessToken($_REQUEST['oauth_verifier']);
        
        if($twitter->http_code != 200) {
            session_destroy();
            throw new Exception("Could not connect to Twitter. Try again later.");
        }
        
        unset($_SESSION['tw_oauth_token']);
        unset($_SESSION['tw_oauth_token_secret']);
        
        $connection = new TwitterOAuth(TW_APPID, TW_SECRET, $accessToken['oauth_token'], $accessToken['oauth_token_secret']);
        $twUserArray = $connection->get('account/verify_credentials');
        
        if($connection->http_code != 200) {
            session_destroy();
            throw new Exception("Could not connect to Twitter. Try again later.");
        }
        
        $getUser = $db->query(sprintf("SELECT UserID FROM users WHERE tw_UserID = %s", Secure($twUserArray->id) )) or die("sql error #1 @twitter_checkUser");
        if($getUser->num_rows > 0) {
            /* user already exsit and just signing-in */
            if($this->_userExist) {
                $this->signOut();
            }
            $userArray = $getUser->fetch_array(MYSQLI_ASSOC);
            // set cookies
            try {
                $this->updateLastSign($userArray['UserID']);
                $this->setCookies($userArray['UserID'], true);
            }catch (Exception $e) {
                throw new Exception($e->getMessage());
            }
        }else {
            /* user cloud be connecting his twitter or signing-up */
            if($this->_userExist) {
                /* connect with the right account */
                $db->query(sprintf("UPDATE users SET tw_UserID = %s, tw_UserName = %s, tw_Token = %s, tw_TokenSecret = %s, Verified = 'Y' WHERE UserID = %s", Secure($twUserArray->id, 'int'), Secure($twUserArray->screen_name), Secure($accessToken['oauth_token']), Secure($accessToken['oauth_token_secret']), Secure($this->_userArray['UserID']) )) or die ("sql error #2 @twitter_checkUser");
                $this->signOut();
                // set cookies
                try {
                    $this->updateLastSign($this->_userArray['UserID']);
                    $this->setCookies($this->_userArray['UserID'], true);
                }catch (Exception $e) {
                    throw new Exception($e->getMessage());
                }
            }else {
                /* sign up with twitter account */
                // create user password
                $password = md5(time()*rand(1, 9999));
                // create user email
                $email = $password.'@'.SITE_DOMAIN;
                // prepare user firstname & lastname
                $tw_UserName = explode(" ", $twUserArray->name);
                // insert user
                $db->query(sprintf("INSERT INTO users (UserName, UserEmail, UserToken, UserPassword, tw_UserID, tw_UserName, tw_Token, tw_TokenSecret, UserFirstName, UserLastName, UserCountry, UserWebsite, UserIP, SignupDate, Verified) VALUES (%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, 'Y')", Secure($twUserArray->screen_name), Secure($email), Secure($password), Secure($password), Secure($twUserArray->id, 'int'), Secure($twUserArray->screen_name), Secure($accessToken['oauth_token']), Secure($accessToken['oauth_token_secret']), Secure($tw_UserName[0]), Secure($tw_UserName[1]), Secure($twUserArray->location), Secure($twUserArray->url), Secure($_SERVER[REMOTE_ADDR]), Secure($now) )) or die ("sql error #3 @twitter_checkUser");
                $userId = $db->insert_id;
                // prepare user media albums
                $db->query(sprintf("INSERT INTO posts_photos_albums (UserID, IsWall, Title, Time) VALUES (%s, 'Y', 'Wall Photos', %s)", Secure($userId, 'int'), Secure($now) )) or die ("sql error #4 @twitter_checkUser");
                $wallPhotos = $db->insert_id;
                $db->query(sprintf("INSERT INTO posts_videos_albums (UserID, IsWall, Title, Time) VALUES (%s, 'Y', 'Wall Videos', %s)", Secure($userId, 'int'), Secure($now) )) or die ("sql error #5 @twitter_checkUser");
                $wallVideos = $db->insert_id;
                $db->query(sprintf("UPDATE users SET UserWallPhotos = %s, UserWallVideos = %s WHERE UserID = %s", Secure($wallPhotos, 'int'), Secure($wallVideos, 'int'), Secure($userId, 'int') )) or die ("sql error #6 @twitter_checkUser");
                // set cookies
                try {
                    $this->updateLastSign($userId);
                    $this->setCookies($userId, true);
                }catch (Exception $e) {
                    throw new Exception($e->getMessage());
                }
            }
        }
    }
    
    /**
     * facebook_getLink
     * 
     * @return void
     */ 
    public static function facebook_getLink() {
        
        $url = 'https://www.facebook.com/dialog/oauth?client_id='.FB_APPID.'&redirect_uri='.FB_CALLBACK.'&scope=email,offline_access,publish_stream,read_stream';
        return $url;
    }
    
    /**
     * facebook_checkUser
     * 
     * @return void
     */ 
    public function facebook_checkUser() {
        
        global $db, $now;
        
        $getAccessLink  = 'https://graph.facebook.com/oauth/access_token?';
        $getAccessLink .= 'client_id=' . FB_APPID;
        $getAccessLink .= '&redirect_uri=' . urlencode(FB_CALLBACK);
        $getAccessLink .= '&client_secret=' . FB_SECRET;
        $getAccessLink .= '&code=' . $_REQUEST['code'];
        
        $accessToken = file_get_contents($getAccessLink);
        $graphAPI = "https://graph.facebook.com/me?" . $accessToken;
        $fbUser = json_decode(file_get_contents($graphAPI));
        
        $getUser = $db->query(sprintf("SELECT * FROM users WHERE fb_UserID = %s", Secure($fbUser->id) ));
        if(!$getUser) {
            throw new Exception("There is some thing wrong happened. Try again later");
        }
        if($getUser->num_rows > 0) {
            /* user exsit and just signing-in */
            $updateUser = $db->query(sprintf("UPDATE users SET fb_Token = %s WHERE fb_UserID = %s", Secure($accessToken), Secure($fbUser->id) ));
            if(!$updateUser) {
                throw new Exception("There is some thing wrong happened. Try again later");
            }
            if($this->_userExist) {
                $this->signOut();
            }
            $userArray = $getUser->fetch_array(MYSQLI_ASSOC);
            // set cookies
            try {
                $this->updateLastSign($userArray['UserID']);
                $this->setCookies($userArray['UserID'], true);
            }catch (Exception $e) {
                throw new Exception($e->getMessage());
            }
        }else {
            /* user cloud be connecting his facebook or signing-up */
            if($this->_userExist) {
                $updateUser = $db->query(sprintf("UPDATE users SET fb_UserID = %s, fb_UserName = %s, fb_Token = %s, Verified = 'Y' WHERE UserID = %s", Secure($fbUser->id), Secure($fbUser->username), Secure($accessToken), Secure($this->_userArray['UserID']) ));
                if(!$updateUser) {
                    throw new Exception("There is some thing wrong happened. Try again later");
                }
                $this->signOut();
                // set cookies
                try {
                    $this->updateLastSign($this->_userArray['UserID']);
                    $this->setCookies($this->_userArray['UserID'], true);
                }catch (Exception $e) {
                    throw new Exception($e->getMessage());
                }
            }else {
                /* sign up with facebook account */
                // create user password
                $password = md5(time()*rand(1, 9999));
                // insert user
                $db->query(sprintf("INSERT INTO users (fb_UserID, fb_UserName, fb_Token, UserPassword, UserToken, UserName, UserEmail, UserFirstName, UserLastName, UserCountry, UserBiography, UserIP, SignupDate, Verified) VALUES (%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, 'Y')", Secure($fbUser->id), Secure($fbUser->username), Secure($accessToken), Secure($password), Secure($password), Secure($fbUser->username), Secure($fbUser->email), Secure($fbUser->first_name), Secure($fbUser->last_name), Secure($fbUser->location->name), Secure(substr($fbUser->bio, 0, 255)), Secure($_SERVER[REMOTE_ADDR]), Secure($now) )) or die ("sql error #5 @facebook_checkUser");
                $userId = $db->insert_id;
                // prepare user media albums
                $db->query(sprintf("INSERT INTO posts_photos_albums (UserID, IsWall, Title, Time) VALUES (%s, 'Y', 'Wall Photos', %s)", Secure($userId, 'int'), Secure($now) )) or die ("sql error #6 @facebook_checkUser");
                $wallPhotos = $db->insert_id;
                $db->query(sprintf("INSERT INTO posts_videos_albums (UserID, IsWall, Title, Time) VALUES (%s, 'Y', 'Wall Videos', %s)", Secure($userId, 'int'), Secure($now) )) or die ("sql error #7 @facebook_checkUser");
                $wallVideos = $db->insert_id;
                $db->query(sprintf("UPDATE users SET UserWallPhotos = %s, UserWallVideos = %s WHERE UserID = %s", Secure($wallPhotos, 'int'), Secure($wallVideos, 'int'), Secure($userId, 'int') )) or die ("sql error #8 @facebook_checkUser");
                // set cookies
                try {
                    $this->updateLastSign($userId);
                    $this->setCookies($userId, true);
                }catch (Exception $e) {
                    throw new Exception($e->getMessage());
                }
            }
        }
    }
    
    /**
     * getFollowings 
     * 
     * @param integer $id
     * @return array
     */
    public function getFollowings($id) {
        
        global $db;
        
        $getFollowings = $db->query(sprintf("SELECT FollowingID FROM users_followings WHERE UserID = %s", SafeSQL($id, 'int'))) or die('sql error #1 @getFollowings');
        while($following = $getFollowings->fetch_array(MYSQLI_ASSOC)) {
            $followings[] = $following['FollowingID'];
        }
        return $followings;
    }
    
    /**
     * getFollowers 
     * 
     * @param integer $id
     * @return array
     */
    public function getFollowers($id) {
        
        global $db;
        
        $getFollowers = $db->query(sprintf("SELECT UserID FROM users_followings WHERE FollowingID = %s", SafeSQL($id, 'int'))) or die('sql error #1 @getFollowers');
        while($follower = $getFollowers->fetch_array(MYSQLI_ASSOC)) {
            $followers[] = $follower['UserID'];
        }
        return $followers;
        
    }
    
    /**
     * getBlockedUsers 
     * 
     * @param integer $id
     * @return array
     */
    public function getBlockedUsers($id) {
        
        global $db;
        
        // get hidden users
        $getHiddenUsers = $db->query(sprintf("SELECT HiddenID FROM users_hidden_users WHERE UserID = %s", SafeSQL($id, 'int'))) or die('sql error #1 @getHiddenUsers');
        while($hiddenUser = $getHiddenUsers->fetch_array(MYSQLI_ASSOC)) {
            $hiddenUsers[] = $hiddenUser['HiddenID'];
        }
        
        // get spammers
        $getSpammers = $db->query(sprintf("SELECT SpammerID FROM users_spammers WHERE UserID = %s", SafeSQL($id, 'int'))) or die('sql error #2 @getHiddenUsers');
        while($spammer = $getSpammers->fetch_array(MYSQLI_ASSOC)) {
            $spammers[] = $spammer['SpammerID'];
        }
        
        if(count($hiddenUsers) > 0 && count($spammers) > 0) {
            return array_unique(array_merge($hiddenUsers, $spammers));
        }
        
        if(count($hiddenUsers) > 0 && count($spammers) == 0) {
            return $hiddenUsers;
        }
        
        if(count($hiddenUsers) == 0 && count($spammers) > 0) {
            return $spammers;
        }
        
    }
    
    /**
     * getBlockedPosts 
     * 
     * @param integer $id
     * @return array
     */
    public function getBlockedPosts($id) {
        
        global $db;
        
        $getHiddenPosts = $db->query(sprintf("SELECT ActivityID FROM users_hidden_posts WHERE UserID = %s", SafeSQL($id, 'int'))) or die('sql error #1 @getHiddenPosts');
        while($hiddenPost = $getHiddenPosts->fetch_array(MYSQLI_ASSOC)) {
            $hiddenPosts[] = $hiddenPost['ActivityID'];
        }
        return $hiddenPosts;
    }
    
    /**
     * checkUserEmail
     * 
     * @param string $email
     * @return boolean
     */ 
	public function checkUserEmail($email) {

        global $db;
        
        $checkQuery = $db->query(sprintf("SELECT * FROM users WHERE UserEmail = %s", SafeSQL($email) )) or die("sql error #1 @checkUserEmail");
        if($checkQuery->num_rows == 0) {
            return false;
        }else {
            return true;
        }
    }
    
    /**
     * checkUserName
     * 
     * @param string $username
     * @return boolean
     */ 
	public function checkUserName($username) {

        global $db;
        
        $checkQuery = $db->query(sprintf("SELECT * FROM users WHERE UserName = %s", Secure($username) )) or die("sql error #1 @checkUserName");
        if($checkQuery->num_rows == 0) {
            return false;
        }else {
            return true;
        }
    }
    
}
?>