<?php
/**
 * image class
 * 
 * @package Sngine
 * @author Zamblek
 */

class Image {
    
    private $_img;
    private $_imgType;
    private $_imgWidth;
    private $_imgHeight;
    
    /**
     * Class Constructor
     * 
     * @param string $file
     */
    public function __construct($file) {
        
        $imgInfo = @getimagesize($file);
        if(!$imgInfo) {
            throw new Exception("The file type is not valid image");
        }
        $this->_imgType = $imgInfo[2];
        if($this->_imgType == IMAGETYPE_JPEG) {
            $this->_img = imagecreatefromjpeg($file);
        }elseif($this->_imgType == IMAGETYPE_GIF) {
            $this->_img = imagecreatefromgif($file);
        }elseif($this->_imgType == IMAGETYPE_PNG) {
            $this->_img = imagecreatefrompng($file);
        }else {
            throw new Exception("The file is type not valid image");
        }
    }
    
    /**
     * getType
     * 
     * @return string
     */
    public function getType() {
        return $this->_imgType;
    }
    
    /**
     * getWidth
     * 
     * @return integer
     */
    public function getWidth() {
        return imagesx($this->_img);
    }
    
    /**
     * getHeight
     * 
     * @return integer
     */
    public function getHeight() {
        return imagesy($this->_img);
    }
    
    /**
     * resize
     * 
     * @param integer $width
     * @param integer $height
     */
    public function resize($width, $height) {
        
        $newImg = imagecreatetruecolor($width, $height);
        imagecopyresampled($newImg, $this->_img, 0, 0, 0, 0, $width, $height, $this->getWidth(), $this->getHeight());
        $this->_img = $newImg;
    }
    
    /**
     * resizeToWidth
     * 
     * @param integer $width
     */
    public function resizeToWidth($width) {
        
        $ratio = $width / $this->getWidth();
        $height = $this->getheight() * $ratio;
        $this->resize($width, $height);
    }
    
    /**
     * resizeToHeight
     * 
     * @param integer $height
     */
    public function resizeToHeight($height) {
        
        $ratio = $height / $this->getHeight();
        $width = $this->getWidth() * $ratio;
        $this->resize($width, $height);
    }
    
    /**
     * save
     * 
     * @param string $file
     * @param string $imgType
     * @param integer $quality
     */
    public function save($file, $imgType = IMAGETYPE_JPEG, $quality = 100) {
        
        if($imgType == IMAGETYPE_JPEG) {
            imagejpeg($this->_img, $file, $quality);
        }elseif($image_type == IMAGETYPE_GIF) {
            imagegif($this->_img, $file);
        }elseif($image_type == IMAGETYPE_PNG) {
            imagepng($this->_img, $file);
        }
    }
    
}
?>