/**
 * plugin texteditor
 * 
 * @package Sngine JSL
 * @author Zamblek
 */

(function($){
	
	$.fn.texteditor = function() {
		
		var toolbar = new Array(3);
		
		toolbar['1'] = new Array(
			['bold',          'bold.png'      ],
			['italic',        'italic.png'    ],
			['underline',     'underline.png' ]
			);
		
		toolbar['2'] = new Array(
			['insertorderedlist',    'list_numbers.png' ],
			['insertunorderedlist',  'list_bullets.png' ],
			['blockquote',           'quote.png'        ]
			);
		
		function _generate(e) {
			
			// hide textarea
			$(e).hide();
			
			// determine textarea width & height
			var currentWidth  = $(e).css('width');
			var currentHeight  = $(e).css('height');
			
			// generate wysiwyg editor
			var editor = '<div class="textEditorToolBar mt5" style="width:'+ currentWidth +'">';
				
				
				// insert toolbars
				editor += '<span class="mr5">';
				for(var i = 0; i < toolbar['1'].length; i++) {
					editor += '<label id="' + toolbar['1'][i][0] + '" class="uiButton textEditorBtn"><img src="'+SITE_URL+'content/themes/default/images/wysiwyg/' + toolbar['1'][i][1] + '"/></label>'
				}
				editor += '</span>';
				
				editor += '<span class="mr5">';
				for(var i = 0; i < toolbar['2'].length; i++) {
					editor += '<label id="' + toolbar['2'][i][0] + '" class="uiButton textEditorBtn"><img src="'+SITE_URL+'content/themes/default/images/wysiwyg/' + toolbar['2'][i][1] + '"/></label>'
				}
				editor += '</span>';
				
			editor +='</div>';
			
			// generate wysiwyg iframe
			editor += '<iframe class="textEditorIFrame" style="width:'+ currentWidth +'; height:'+ currentHeight +'"></iframe>';
			
			$(e).parent().append(editor);
			
			// enable the iframe design mode
			var iframe = $('.textEditorIFrame').contents().get(0);
			iframe.designMode = "on";
			$(iframe.body).css({ fontFamily: 'lucida grande,tahoma,verdana,arial,sans-serif', fontSize: '11px', color: '#ffffff', padding: '6px 3px', margin: '0', direction: 'ltr', cursor: 'text' });
			$(iframe.body).html($(e).val());
			
			$('.textEditorIFrame').load(function() {
				var iframe = $('.textEditorIFrame').contents().get(0);
				iframe.designMode = "on";
				$(iframe.body).css({ fontFamily: 'lucida grande,tahoma,verdana,arial,sans-serif', fontSize: '11px', color: '#ffffff', padding: '6px 3px', margin: '0', direction: 'ltr' });
				$(iframe.body).html($(e).val());
			});
			
			$('.textEditorBtn').live('click',
				function() {
					var iframe = $('.textEditorIFrame').contents().get(0);
					if($(this).attr('id') == 'blockquote') {
						iframe.execCommand('FormatBlock', false, $(this).attr('id'));
					}else {
						iframe.execCommand($(this).attr('id'), false, null);
					}
				}
			);
			
			$('.postDiscussion').live('submit',
				function() {
					var iframe = $('.textEditorIFrame').contents().get(0);
					$(e).val($(iframe.body).html());
				}
			);

		}
		
		// initialize
		this.each(function() {

			// is a textarea?
			if (this.nodeName.toLowerCase() != "textarea") return;

			// initial resize
			_generate(this);
			
		});
		
		return this;
	}
	
})(jQuery);

// initialize all texteditor textareas
jQuery(document).ready(function() {
	jQuery("textarea[class*=texteditor]").texteditor();
});