/**
 * plugin popups
 * 
 * @package Sngine JSL
 * @author Zamblek
 */

(function($){
	
	$.popups = {
		
		popup: function(options) {
			
			// remove any opened popup
			$("#popup").remove();
			
			// default values
			var defaults = {
				source: "loading",
				data: "",
				width: 300,
				};
			var options = $.extend(defaults, options);
			
			// append the popup window
			$("body").append(
			  '<div id="popup" class="popupWrapper">' +
			    '<div class="popupContent">Loading...</div>' +
			  '</div>');
			
			$("#popup").css({
				width: options.width
			});
			
			$.popups._reposition();
			
			// handle the request
			if(options.source !== "loading") {
				$.ajax({
					type: "POST",
					url: options.source,
					data: options.data,
					success: function(data) {
						$('#popup').html(data);
					},
					error: function() {
						$('#popup').html('<div class="popupHeader"><div class="button-close popup right" onclick="$.popups._hide();"></div>Error</div><div class="popupContent">There is some thing wrong happened</div>');
					}
				});
			}
			
		},
		
		confirm: function(message, width, callback) {
			
			$("#popup").remove();
			
			$("body").append(
			  '<div id="popup" class="popupWrapper">' +
			    '<div class="popupHeader">'+ message + '</div>' +
			    '<div class="popupContent">' +
			      '<input type="button" value="Yes" class="uiButton light-blue bigButton mr5" id="popup_ok" /><input type="button" value="No" class="uiButton bigButton" id="popup_cancel" />' +
				'</div>' +
			  '</div>');
			
			$("#popup").css({
				width: width
			});
			
			// reposition the popup window
			$.popups._reposition();
			
			$("#popup_ok").click( function() {
				$.popups._hide();
				if( callback ) callback(true);
			});
			
			$("#popup_cancel").click( function() {
				$.popups._hide();
				if( callback ) callback( false );
			});
			
			$("#popup_ok").focus();
			
			$("#popup_ok, #popup_cancel").keypress( function(e) {
				if( e.keyCode == 13 ) $("#popup_ok").trigger('click');
				if( e.keyCode == 27 ) $("#popup_cancel").trigger('click');
			});
			
			
		},
		
		alert: function(options) {
			
			// remove any opened popup
			$("#popup").remove();
			
			// default values
			var defaults = {
				message: "",
				title: "Error",
				width: 450,
				};
			var options = $.extend(defaults, options);
			
			// append the popup window
			$("body").append(
			  '<div id="popup" class="popupWrapper">' +
			    '<div class="popupHeader"><div class="button-close popup right" onclick="$.popups._hide();"></div>' + options.title + '</div>' +
			    '<div class="popupContent">' + options.message + '</div>' +
			  '</div>');
			
			$("#popup").css({
				width: options.width
			});
			
			// reposition the popup window
			$.popups._reposition();
			
		},
		
		_reposition: function() {
			var top  = ($(window).height() - $("#popup").outerHeight()) / 2 + window.pageYOffset;
			var left = ($(window).width() - $("#popup").outerWidth()) / 2;
			
			if( top < 0 ) top = 0;
			if( left < 0 ) left = 0;
			
			$("#popup").css({
				top: top + 'px',
				left: left + 'px'
			});
		},
		
		_hide: function() {
			$("#popup").fadeOut( function() {
				$("#popup").remove();
			});
		}
		
	}
	
})(jQuery);