/**
 * page setting
 * 
 * @package Sngine JSL
 * @author Zamblek
 */

function handleResponse(key, status, error, img, thumbnail) {
	if(status === '0') {
		$('.uploadStatus').html('<div>'+error+'</div>');
	}else if(status === '1') {
		$('.uploadStatus').html('<div>Upload Successful</div>');
		$('img.changeAvatarImg').attr('src', img);
	}
}

$(function() {
	
	$('.changeAvatar').click (
        function() {
            $('.changeAvatarUpload').show();
        }
    );
	
	$('.doRemoveAvatar').click (
		function() {
			
			$.popups.confirm('Are you sure you want to delete your profile picture?', '400', 
				function(result){
					if(result) {
						
						$.ajax({
							url: SITE_URL+'ajax/users/picture/delete.php',
							type: 'POST',
							dataType: "json",
							cache: false,
							success: function(data) {
								if(!data) {
									$('img.changeAvatarImg').attr('src', SITE_URL+'content/themes/default/images/misc/no_avatar.jpg');
								}else {
									$.popups.alert({message: data.value, title: data.title});
								}
							}
						});
						
					}
				}
			);
		}
	);
	
	$('#uploadFile').live('change', 
		function() {
			$('#uploadForm').submit();
			$('.uploadStatus').html('<div class="right"><img src="'+SITE_URL+'content/themes/default/images/buttons/spinner.gif" /></div>Uploading...').show();
		}
	);
	
	
});
