/**
 * page search
 * 
 * @package Sngine JSL
 * @author Zamblek
 */

var openedSearchSocket = false;

function getResults(query, app, get, replace, page) {
    
    if(openedSearchSocket) return;
    openedSearchSocket = true;
	
	if(get == 'new') {
		if($('#dataSort').text() !== 'Most Recent') return;
		if($('ul#livefeeds').find('.stopCronJobs').length > 0) return;
		if(app == 'photos' || app == 'videos') return;
	}
	
	page = (page === undefined )? 1 : page;
	
	var startPoint = $('.firstNode:first').attr('id');
	startPoint = (startPoint === undefined )? 1 : startPoint;
	
	$.ajax({
		url: SITE_URL+'ajax/search/get.php',
		type: 'GET',
		data: 'q=' + query + '&app=' + app + '&get=' + get + '&filter=' + $('#dataFilter').text() + '&sort=' + $('#dataSort').text() + '&startPoint=' + startPoint + '&page=' + page,
		success: function(data){
			if(data) {
				if(replace || app == 'photos' || app == 'videos') {
					$('ul#livefeeds').hide().html(data).fadeIn();
				}else {
					$('ul#livefeeds').prepend($(data).fadeIn('slow'));
				}
				$('.viewMorePosts').remove();
				if($('.stopCronJobs').length == 0 && app != 'photos' && app != 'videos' && app != 'web') {
					$('ul#livefeeds').after('<div class="viewMore viewMorePosts"><div class="right hidden"><img src="'+SITE_URL+'/content/themes/default/images/buttons/spinner.gif" /></div>View More</div>');
				}
			}
            openedSearchSocket = false;
		}
	});
}

$(function() {
	
	$(window).load(function () {
		getResults($('.contentWrapper').attr('q'), $('.contentWrapper').attr('app'), 'all', true);
		
	});
	
	$(document).ready(function() {
		setInterval("getResults($('.contentWrapper').attr('q'), $('.contentWrapper').attr('app'), 'new', false, 1)", 10000);
	});
	
	$(".doFilter").click(
        function(){
			if($(this).text() === $('#dataFilter').text()) return;
			$('#dataFilter').text($(this).text());
			$('ul#livefeeds').html('<div class="pt10 pb10 pl10 pr10 tcenter"><img src="'+SITE_URL+'/content/themes/default/images/buttons/spinner-larg.gif" /></div>');
			getResults($('.contentWrapper').attr('q'), $('.contentWrapper').attr('app'), 'all', true);
		}
    );
	
	$(".doSort").click(
        function(){
			if($(this).text() === $('#dataSort').text()) return;
			$('#dataSort').text($(this).text());
			$('ul#livefeeds').html('<div class="pt10 pb10 pl10 pr10 tcenter"><img src="'+SITE_URL+'/content/themes/default/images/buttons/spinner-larg.gif" /></div>');
			getResults($('.contentWrapper').attr('q'), $('.contentWrapper').attr('app'), 'all', true);
		}
    );
	
	$('.pagerButton').live('click', 
        function() {
			getResults($('.contentWrapper').attr('q'), $('.contentWrapper').attr('app'), 'all', true, $(this).attr('id'));
		}
    );
	
	$(".viewMorePosts").live('click', 
        function() {
            
			var viewmore = $(this);
            var loading = $(this).find('div.hidden');
            var startPoint = $('li.lastNode:last').attr('id');
            
            loading.show();
			$.ajax({
				url: SITE_URL+'ajax/search/get.php',
				type: 'GET',
				data: 'q=' + encodeURIComponent($('.contentWrapper').attr('q')) + '&app=' + $('.contentWrapper').attr('app') + '&get=' + 'old' + '&filter=' + $('#dataFilter').text() + '&sort=' + $('#dataSort').text() + '&startPoint=' + startPoint,
				success: function(data){
					loading.hide();
					if(data) {
						$('ul#livefeeds').append(data);
					}else {
						viewmore.addClass('disactive').text('There are no more results to show.');
					}
				}
			});
		}
    );
	
});
