/**
 * page profile
 * 
 * @package Sngine JSL
 * @author Zamblek
 */

function getPeople(id, tab) {
	
	if($('.dataNullState').length > 0) return;
	
	var startPoint = $('li.lastNode:last').attr('id');
	startPoint = (startPoint === startPoint ) ? 0 : startPoint;
	
	$.ajax({
		url: SITE_URL+'ajax/users/people.php',
		type: 'GET',
		data: 'id=' + id + '&get=' + tab + '&sp=' + startPoint,
		success: function(data){
			if(data) {
				$('ul#livefeeds').html(data).fadeIn();
				$('.viewMorePeople').remove();
				$('ul#livefeeds').after('<div class="viewMore viewMorePeople"><div class="right hidden"><img src="'+SITE_URL+'content/themes/default/images/buttons/spinner.gif" /></div>View More</div>');
			}
		}
	});
}

function getAlbums(id, app) {
	
	$.ajax({
		url: SITE_URL+'ajax/media/albums/get.php',
		type: 'GET',
		data: 'id=' + id + '&app=' + app,
		success: function(data){
			if(data) {
				$('ul#livefeeds').html(data).fadeIn();
			}
		}
	});
}

function getPosts(app, get, replace, page) {
	
	page = (page === undefined )? 1 : page;
	
	var id = $('.contentWrapper').attr('id');
	var startPoint = $('.firstNode:first').attr('id');
	
	$.ajax({
		url: SITE_URL+'ajax/posts/get.php',
		type: 'GET',
		data: 'app=' + app + '&get=' + get + '&filter=Just User' + '&id=' + id + '&sort=' + $('#dataSort').text() + '&startPoint=' + startPoint + '&page=' + page,
		success: function(data){
			if(data) {
				if(replace) {
					$('ul#livefeeds').hide().html(data).fadeIn();
				}else {
					$('ul#livefeeds').prepend($(data).fadeIn('slow'));
				}
				
				$('.viewMorePosts').remove();
				
				if($('.stopCronJobs').length == 0 && app != 'photos' && app != 'videos') {
					$('ul#livefeeds').after('<div class="viewMore viewMorePosts"><div class="right hidden"><img src="'+SITE_URL+'/content/themes/default/images/buttons/spinner.gif" /></div>View More</div>');
				}
			}
		}
	});
}

$(function() {
    
    $(window).load(function () {
        
        var view = $('.contentWrapper').attr('view');
		var tab = $('.contentWrapper').attr('tab');
		var id = $('.contentWrapper').attr('id');
        
        if(view == 'people') {
			getPeople(id, tab);
		}else if ((view == 'photos' || view == 'videos') && tab == 'albums') {
			getAlbums(id, view);
		}else {
			view = (view == 'wall') ? 'home' : view;
            getPosts(view, 'all', true);
        }
		
	});
	
	$(".doSort").click(
        function(){
			
			var view = $('.contentWrapper').attr('view');
			
			if($(this).text() === $('#dataSort').text()) return;
			$('#dataSort').text($(this).text());
			getPosts(view, 'all', true);
		}
    );
	
	$('.pagerButton').live('click', 
        function() {
			getPosts($('.contentWrapper').attr('view'), 'all', true, $(this).attr('id'));
		}
    );
	
	$(".viewMorePosts").live('click', 
        function() {
			
			var id = $('.contentWrapper').attr('id');
			var view = $('.contentWrapper').attr('view');
            
			var viewmore = $(this);
            var loading = $(this).find('div.hidden');
            var startPoint = $('li.lastNode:last').attr('id');
            
            loading.show();
			$.ajax({
				url: SITE_URL+'ajax/posts/get.php',
				type: 'GET',
				data: 'app=' + view + '&get=' + 'old' + '&filter=Just User' + '&id=' + id + '&sort=' + $('#dataSort').text() + '&startPoint=' + startPoint,
				success: function(data){
					loading.hide();
					if(data) {
						$('ul#livefeeds').append(data);
					}else {
						viewmore.addClass('disactive').text('There are no more posts to show.');
					}
				}
			});
		}
    );
	
	$(".viewMorePeople").live('click', 
        function() {
			
			var tab = $('.contentWrapper').attr('tab');
			var id = $('.contentWrapper').attr('id');
            
			var viewmore = $(this);
            var loading = $(this).find('div.hidden');
            var startPoint = $('li.lastNode:last').attr('id');
			
            loading.show();
			$.ajax({
				url: SITE_URL+'ajax/users/people.php',
				type: 'GET',
				data: 'id=' + id + '&get=' + tab + '&sp=' + startPoint,
				success: function(data){
					loading.hide();
					if(data) {
						$('ul#livefeeds').append(data);
					}else {
						viewmore.addClass('disactive').text('There are no more people to show.');
					}
				}
			});
		}
    );
	
});
