/**
 * page editalbum
 * 
 * @package Sngine JSL
 * @author Zamblek
 */

function handleResponse(key, status, error, img, thumbnail) {
	if(status === '0') {
		$('.uploadStatus-'+key).html('<div class="button-close removePhoto right"></div>'+error);
	}else if(status === '1') {
		var html;
		html = '<div class="albumMediaContainer">' +
			       '<div class="albumMediaThumbnail"><div class="uiMediaThumb"><i style="background-image: url(&quot;' + thumbnail + '&quot;);"></i></div></div>' +
				   '<div class="albumMediaDetails ml10 pt10">' + 
				   		'<div class="button-close removePhoto right"></div>' +
						'<div class="mb10">Description:</div>' + 
						'<div class="mb10"><textarea key="'+key+'" class="uiInput thumbnailText" style="width: 175px; height: 48px;"></textarea></div>' +
						'<div><input type="hidden" name="key" value="'+key+'" /><input type="radio" key="'+key+'" id="thumbnail-'+key+'" name="selectThumbnail" /><label for="thumbnail-'+key+'">This is the album cover.</label></div>' +
					'</div>' +
				'</div>';
		$('.uploadStatus-'+key).html(html).fadeIn();
		$('.postAlbum').prepend('<input type="hidden" name="thumb['+key+'][src]" value="'+img+'" /><input type="hidden" name="thumb['+key+'][thumb]" value="'+thumbnail+'" />');
	}
}

$(function() {
	
	$('.uploadFile').change(
		function() {
			var form = $(this).parent();
			form.submit().hide();
			form.next().html('<div class="right"><img src="' + SITE_URL + 'content/themes/default/images/buttons/spinner.gif" /></div>Uploading...').fadeIn();
		}
	);
	
	$('.attachLink').live('submit', 
	    function(event) {
			
			event.preventDefault();
			
			var form = $(this);
			var loading = $(this).next();
			var key = $(this).find('input[name=key]').val();
			var input = $(this).find('input[type=text]');
			
            // check inputs values
			if(!input.hasClass('active')) {
				return;
			}
            
			form.hide();
			loading.html('<div class="right"><img src="' + SITE_URL + 'content/themes/default/images/buttons/spinner.gif" /></div>Fetching...').fadeIn();
			
			$.ajax({
                type: "POST",
                url: SITE_URL+"ajax/media/albums/scraper.php",
                data: 'url=' + encodeURIComponent(input.attr('value')),
				dataType: "json",
                cache: false,
                success: function(data) {
					if(data.status == 'error') {
						loading.hide();
						form.show();
						$.popups.alert({message: data.value, title: data.title});
					}else {
						var html;
						html = '<div class="albumMediaContainer">' +
							       '<div class="albumMediaThumbnail"><div class="uiMediaThumb"><i class="videoThumbnail" style="background-image: url(&quot;' + data.value.thumbnail + '&quot;);"></i><i class="plyrBtn"></i></div></div>' +
								   '<div class="albumMediaDetails ml10 pt10">' +
								   		'<div class="button-close removeVideo right"></div>' +
										'<div class="mb10">Description:</div>' +
										'<div class="mb10"><textarea key="'+key+'" class="uiInput thumbnailText" style="width: 175px; height: 48px;"></textarea></div>' +
										'<div><input type="hidden" name="key" value="'+key+'" /><input type="radio" key="'+key+'" id="thumbnail-'+key+'" name="selectThumbnail" /><label for="thumbnail-'+key+'">This is the album cover.</label></div>' +
									'</div>' +
								'</div>';
						loading.html(html);
						$('.postAlbum').prepend('<input type="hidden" name="thumb['+key+'][id]" value="'+data.value.id+'" /><input type="hidden" name="thumb['+key+'][type]" value="'+data.value.type+'" /><input type="hidden" name="thumb['+key+'][thumb]" value="'+data.value.thumbnail+'" />');
					}
				}
            });
            
			event.stopPropagation();
			
        }
    );
	
	$('.postAlbum').submit(
        function() {
			var data = '';
			$('.thumbnailText').each(function() {
				data += '<input type="hidden" name="thumb['+$(this).attr('key')+'][txt]" value="'+$(this).val()+'" />';
			})
			data += '<input type="hidden" name="albumCover" value="'+$('input[name=selectThumbnail]:checked').attr('key')+'" />';
			$(this).prepend(data);
		}
    );
	
	$('.doRemovePhotoAlbum, .doRemoveVideoAlbum').live('click', 
		function() {
			
			var node = $(this);
			var type = ($(this).hasClass('doRemovePhotoAlbum'))? 'photo' : 'video';
			
			$.popups.confirm('Are you sure you want to delete this ' + type + ' album ?', '400', 
				function(result){
					if(result) {
						
						$.ajax({
							url: SITE_URL+'ajax/media/albums/delete.php',
							type: 'POST',
							data: 'id=' + node.attr('id') + '&type=' + type,
							dataType: "json",
							cache: false,
							success: function(data) {
								if(!data) {
									window.location.replace(SITE_URL + "home.php");
								}else {
									$.popups.alert({message: data.value, title: data.title});
								}
							}
						});
						
					}
				}
			);
		}
	);
	
	$('.removePhoto, .removeVideo').live('click', 
		function() {
			
			var parent = $(this).parents('.uploadStatus');
			var key = parent.find('input[name=key]').val();
			
			if($(this).hasClass('removePhoto')) {
				$('.postAlbum').find('input[name="thumb['+key+'][src]"]').remove();
			}else {
				$('.postAlbum').find('input[name="thumb['+key+'][id]"]').remove();
				$('.postAlbum').find('input[name="thumb['+key+'][type]"]').remove();
			}
			$('.postAlbum').find('input[name="thumb['+key+'][thumb]"]').remove();
			
			parent.html('').hide();
			parent.prev().show();
		}
	);
	
	$('.doRemovePhoto, .doRemoveVideo').live('click', 
		function() {
			
			var type = ($(this).hasClass('doRemovePhoto'))? 'photo' : 'video';
			var target = $(this).parents('.uploadStatus');
			
			$.popups.confirm('Are you sure you want to delete this ' + type + '?', '400', 
				function(result){
					if(result) {
						
						$.ajax({
							url: SITE_URL+'ajax/media/posts/delete.php',
							type: 'POST',
							data: 'id=' + target.attr('id') + '&type=' + type,
							dataType: "json",
							cache: false,
							success: function(data) {
								if(!data) {
									if($('.uploadStatus').length == 1) {
										$('.centerPanelContent').html('<div class="dataNullState">There are no ' + type + 's to edit.</div>')
									}else {
										target.hide().remove();
									}
								}else {
									$.popups.alert({message: data.value, title: data.title});
								}
							}
						});
						
					}
				}
			);
		}
	);
	
	
});
