/**
 * core apps
 * 
 * @package Sngine JSL
 * @author Zamblek
 */

function getPosts(app, get, replace, page) {
    
    if(get == 'new') {
		if($('#dataSort').text() !== 'Most Recent') return;
		if($('ul#livefeeds').find('.stopCronJobs').length > 0) return;
		if(app == 'photos' || app == 'videos') return;
	}
	
	page = (page === undefined )? 1 : page;
	
	var startPoint = $('.firstNode:first').attr('id');
	
	$.ajax({
		url: SITE_URL+'ajax/posts/get.php',
		type: 'GET',
		data: 'app=' + app + '&get=' + get + '&filter=' + $('#dataFilter').text() + '&sort=' + $('#dataSort').text() + '&startPoint=' + startPoint + '&page=' + page,
		success: function(data){
			if(data) {
				if(replace || app == 'photos' || app == 'videos') {
					$('ul#livefeeds').hide().html(data).fadeIn();
				}else {
					$('ul#livefeeds').prepend($(data).fadeIn('slow'));
				}
				$("textarea[class*=expand]").TextAreaExpander();
				$('.viewMorePosts').remove();
				if($('.stopCronJobs').length == 0 && app != 'photos' && app != 'videos') {
					$('ul#livefeeds').after('<div class="viewMore viewMorePosts"><div class="right hidden"><img src="'+SITE_URL+'/content/themes/default/images/buttons/spinner.gif" /></div>View More</div>');
				}
			}
        }
	});
}

$(function() {
	
	$(window).load(function () {
		getPosts($('body').attr('page'), 'all', true);
	});
	
	$(document).ready(function() {
		setInterval("getPosts($('body').attr('page'), 'new', false, 1)", 10000);
	});
	
	$(".doFilter").click(
        function(){
			if($(this).text() === $('#dataFilter').text()) return;
			$('#dataFilter').text($(this).text());
			$('ul#livefeeds').html('<div class="pt10 pb10 pl10 pr10 tcenter"><img src="'+SITE_URL+'/content/themes/default/images/buttons/spinner-larg.gif" /></div>');
			getPosts($('body').attr('page'), 'all', true);
		}
    );
	
	$(".doSort").click(
        function(){
			if($(this).text() === $('#dataSort').text()) return;
			$('#dataSort').text($(this).text());
			$('ul#livefeeds').html('<div class="pt10 pb10 pl10 pr10 tcenter"><img src="'+SITE_URL+'/content/themes/default/images/buttons/spinner-larg.gif" /></div>');
			getPosts($('body').attr('page'), 'all', true);
		}
    );
	
	$('.pagerButton').live('click', 
        function() {
			getPosts($('body').attr('page'), 'all', true, $(this).attr('id'));
		}
    );
	
	$(".viewMorePosts").live('click', 
        function() {
            
			var viewmore = $(this);
            var loading = $(this).find('div.hidden');
            var startPoint = $('li.lastNode:last').attr('id');
            
            loading.show();
			$.ajax({
				url: SITE_URL+'ajax/posts/get.php',
				type: 'GET',
				data: 'app=' + $('body').attr('page') + '&get=' + 'old' + '&filter=' + $('#dataFilter').text() + '&sort=' + $('#dataSort').text() + '&startPoint=' + startPoint,
				success: function(data){
					loading.hide();
					if(data) {
						$('ul#livefeeds').append(data);
					}else {
						viewmore.addClass('disactive').text('There are no more posts to show.');
					}
				}
			});
		}
    );
	
});
